/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0003J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0007J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/PackagePartClassUtils;", "", "()V", "PART_CLASS_NAME_SUFFIX", "", "capitalizeAsJavaClassName", "str", "decapitalizeAsJavaClassName", "fileHasTopLevelCallables", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getDefaultPartFqName", "Lorg/jetbrains/kotlin/name/FqName;", "facadeClassFqName", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileNameByFacadeName", "facadeClassName", "getFilePartShortName", "fileName", "getFilesWithCallables", "", "files", "", "getPackagePartFqName", "packageFqName", "getPartClassName", "getPathHashCode", "", "kotlin-compiler"})
public final class PackagePartClassUtils {
    private static final String PART_CLASS_NAME_SUFFIX = "Kt";
    public static final PackagePartClassUtils INSTANCE;

    @JvmStatic
    public static final int getPathHashCode(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        String string = file.getPath();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
        return string3.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final String getPartClassName(@NotNull String str) {
        String string;
        Intrinsics.checkParameterIsNotNull(str, "str");
        CharSequence charSequence = str;
        if (charSequence.length() == 0) {
            string = "_" + PART_CLASS_NAME_SUFFIX;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = JvmAbi.sanitizeAsJavaIdentifier(str);
            Intrinsics.checkExpressionValueIsNotNull(string2, "JvmAbi.sanitizeAsJavaIdentifier(str)");
            string = stringBuilder.append(PackagePartClassUtils.capitalizeAsJavaClassName(string2)).append(PART_CLASS_NAME_SUFFIX).toString();
        }
        return string;
    }

    @JvmStatic
    private static final String capitalizeAsJavaClassName(String str) {
        String string;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            String string2;
            String string3 = str;
            int n = 0;
            int n2 = 1;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string2 = string5;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull(locale, "Locale.ENGLISH");
            Locale locale2 = locale;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toUpperCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull(string7, "(this as java.lang.String).toUpperCase(locale)");
            string2 = string7;
            string3 = str;
            int n3 = 1;
            stringBuilder = stringBuilder.append(string2);
            String string8 = string3;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n3);
            Intrinsics.checkExpressionValueIsNotNull(string9, "(this as java.lang.String).substring(startIndex)");
            string2 = string9;
            string = stringBuilder.append(string2).toString();
        } else {
            string = "_" + str;
        }
        return string;
    }

    @JvmStatic
    private static final String decapitalizeAsJavaClassName(String str) {
        String string;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            String string2;
            String string3 = str;
            int n = 0;
            int n2 = 1;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string2 = string5;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull(locale, "Locale.ENGLISH");
            Locale locale2 = locale;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull(string7, "(this as java.lang.String).toLowerCase(locale)");
            string2 = string7;
            string3 = str;
            int n3 = 1;
            stringBuilder = stringBuilder.append(string2);
            String string8 = string3;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n3);
            Intrinsics.checkExpressionValueIsNotNull(string9, "(this as java.lang.String).substring(startIndex)");
            string2 = string9;
            string = stringBuilder.append(string2).toString();
        } else if (str.charAt(0) == '_') {
            String string10 = str;
            int n = 1;
            String string11 = string10;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string12 = string11.substring(n);
            string = string12;
            Intrinsics.checkExpressionValueIsNotNull(string12, "(this as java.lang.String).substring(startIndex)");
        } else {
            string = str;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final FqName getDefaultPartFqName(@NotNull FqName facadeClassFqName, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(facadeClassFqName, "facadeClassFqName");
        Intrinsics.checkParameterIsNotNull(file, "file");
        FqName fqName2 = facadeClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "facadeClassFqName.parent()");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return PackagePartClassUtils.getPackagePartFqName(fqName2, string);
    }

    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull FqName packageFqName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        String partClassName = PackagePartClassUtils.getFilePartShortName(fileName);
        FqName fqName2 = packageFqName.child(Name.identifier(partClassName));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFqName.child(Name\u2026dentifier(partClassName))");
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<KtFile> getFilesWithCallables(@NotNull Collection<? extends KtFile> files) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(files, "files");
        Iterable $receiver$iv = files;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            if (!PackagePartClassUtils.fileHasTopLevelCallables(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @JvmStatic
    public static final boolean fileHasTopLevelCallables(@NotNull KtFile file) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(file, "file");
            Iterable $receiver$iv = file.getDeclarations();
            for (Object element$iv : $receiver$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                if (!(it instanceof KtProperty || it instanceof KtNamedFunction || it instanceof KtScript)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final String getFilePartShortName(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        String string = FileUtil.getNameWithoutExtension(fileName);
        Intrinsics.checkExpressionValueIsNotNull(string, "FileUtil.getNameWithoutExtension(fileName)");
        return PackagePartClassUtils.getPartClassName(string);
    }

    @JvmStatic
    @Nullable
    public static final String getFileNameByFacadeName(@NotNull String facadeClassName) {
        Intrinsics.checkParameterIsNotNull(facadeClassName, "facadeClassName");
        if (!StringsKt.endsWith$default(facadeClassName, PART_CLASS_NAME_SUFFIX, false, 2, null)) {
            return null;
        }
        String string = facadeClassName;
        int n = 0;
        int n2 = facadeClassName.length() - PART_CLASS_NAME_SUFFIX.length();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String baseName = string3;
        if (Intrinsics.areEqual(baseName, "_")) {
            return null;
        }
        return PackagePartClassUtils.decapitalizeAsJavaClassName(baseName) + "." + "kt";
    }

    private PackagePartClassUtils() {
        INSTANCE = this;
        PART_CLASS_NAME_SUFFIX = PART_CLASS_NAME_SUFFIX;
    }

    static {
        new PackagePartClassUtils();
    }
}

