/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library.remote;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenVersionComparable;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.remote.MavenRemoteManager;
import org.jetbrains.idea.maven.utils.library.remote.MavenRemoteTask;

public class MavenVersionsRemoteManager
extends MavenRemoteManager<List<String>, RepositoryLibraryDescription, MavenVersionsRemoteManager>
implements MavenRemoteTask<List<String>, RepositoryLibraryDescription> {
    public MavenVersionsRemoteManager(Project project) {
        super(project);
    }

    public static MavenVersionsRemoteManager getInstance(Project project) {
        return (MavenVersionsRemoteManager)project.getComponent(MavenVersionsRemoteManager.class);
    }

    public void getMavenArtifactVersionsAsync(String groupId, String artifactId, MavenRemoteTask.ResultProcessor<List<String>> resultProcessor) {
        this.schedule(this, RepositoryLibraryDescription.findDescription(groupId, artifactId), resultProcessor, false);
    }

    @Nullable
    public List<String> getMavenArtifactVersions(String groupId, String artifactId) {
        return (List)this.getSynchronously(this, RepositoryLibraryDescription.findDescription(groupId, artifactId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> execute(@NotNull RepositoryLibraryDescription repositoryLibraryDescription, ProgressIndicator indicator) {
        List<String> list;
        if (repositoryLibraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryLibraryDescription", "org/jetbrains/idea/maven/utils/library/remote/MavenVersionsRemoteManager", "execute"));
        }
        MavenEmbeddersManager manager = MavenProjectsManager.getInstance(this.myProject).getEmbeddersManager();
        MavenEmbedderWrapper embedder = manager.getEmbedder(MavenEmbeddersManager.FOR_GET_VERSIONS);
        embedder.customizeForGetVersions();
        try {
            List<MavenRemoteRepository> remoteRepositories = MavenVersionsRemoteManager.convertRepositories(repositoryLibraryDescription.getRemoteRepositories());
            List<String> versions = embedder.retrieveVersions(repositoryLibraryDescription.getGroupId(), repositoryLibraryDescription.getArtifactId(), remoteRepositories);
            Collections.sort(versions, (o1, o2) -> {
                MavenVersionComparable v1 = new MavenVersionComparable((String)o1);
                MavenVersionComparable v2 = new MavenVersionComparable((String)o2);
                return v2.compareTo(v1);
            });
            List<String> list2 = versions;
            list = list2;
        }
        catch (MavenProcessCanceledException e) {
            List<String> list3 = Collections.emptyList();
            List<String> list4 = list3;
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/remote/MavenVersionsRemoteManager", "execute"));
            }
            return list4;
        }
        finally {
            manager.release(embedder);
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/remote/MavenVersionsRemoteManager", "execute"));
        }
        return list;
    }

    private static List<MavenRemoteRepository> convertRepositories(Collection<MavenRepositoryInfo> infos) {
        ArrayList<MavenRemoteRepository> result = new ArrayList<MavenRemoteRepository>(infos.size());
        for (MavenRepositoryInfo each : infos) {
            if (each.getUrl() == null) continue;
            result.add(new MavenRemoteRepository(each.getId(), each.getName(), each.getUrl(), null, null, null));
        }
        return result;
    }

    @Override
    public String getName(@NotNull RepositoryLibraryDescription repositoryLibraryDescription) {
        if (repositoryLibraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryLibraryDescription", "org/jetbrains/idea/maven/utils/library/remote/MavenVersionsRemoteManager", "getName"));
        }
        return ProjectBundle.message("maven.loading.library.version.hint", repositoryLibraryDescription.getDisplayName());
    }
}

