/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.GitCommitListWithDiffPanel;
import git4idea.ui.GitRepositoryComboboxListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchIsNotFullyMergedDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitBranchIsNotFullyMergedDialog.class);
    private final Project myProject;
    private final Map<GitRepository, List<GitCommit>> myCommits;
    private final String myBranchToDelete;
    private final String myBaseBranch;
    private final List<String> myMergedToBranches;
    private final GitCommitListWithDiffPanel myCommitListWithDiffPanel;
    private final Collection<GitRepository> myRepositories;
    private final GitRepository myInitialRepository;

    public static boolean showAndGetAnswer(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> commits, @NotNull String branchToDelete, @NotNull List<String> mergedToBranches, @Nullable String baseBranch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "showAndGetAnswer"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "showAndGetAnswer"));
        }
        if (branchToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchToDelete", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "showAndGetAnswer"));
        }
        if (mergedToBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedToBranches", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "showAndGetAnswer"));
        }
        GitBranchIsNotFullyMergedDialog dialog = new GitBranchIsNotFullyMergedDialog(project, commits, branchToDelete, baseBranch, mergedToBranches);
        DialogManager.show(dialog);
        return dialog.isOK();
    }

    private GitBranchIsNotFullyMergedDialog(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> commits, @NotNull String branchToDelete, @Nullable String baseBranch, @NotNull List<String> mergedToBranches) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "<init>"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "<init>"));
        }
        if (branchToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchToDelete", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "<init>"));
        }
        if (mergedToBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedToBranches", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        this.myCommits = commits;
        this.myBranchToDelete = branchToDelete;
        this.myBaseBranch = baseBranch;
        this.myMergedToBranches = mergedToBranches;
        this.myRepositories = commits.keySet();
        this.myInitialRepository = this.calcInitiallySelectedRepository();
        this.myCommitListWithDiffPanel = new GitCommitListWithDiffPanel(this.myProject, new ArrayList<GitCommit>((Collection)this.myCommits.get(this.myInitialRepository)));
        this.init();
        this.setTitle("Branch Is Not Fully Merged");
        this.setOKButtonText("Delete");
        this.setOKButtonMnemonic(68);
        this.setCancelButtonText("Cancel");
    }

    @NotNull
    private GitRepository calcInitiallySelectedRepository() {
        for (GitRepository repository : this.myRepositories) {
            if (this.myCommits.get(repository).isEmpty()) continue;
            GitRepository gitRepository = repository;
            if (gitRepository == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "calcInitiallySelectedRepository"));
            }
            return gitRepository;
        }
        throw new AssertionError((Object)("The dialog shouldn't be shown. Unmerged commits: " + this.myCommits));
    }

    private String makeDescription() {
        boolean onBranch;
        String currentBranchOrRev;
        if (this.myRepositories.size() > 1) {
            LOG.assertTrue(this.myBaseBranch != null, (Object)"Branches have unexpectedly diverged");
            currentBranchOrRev = this.myBaseBranch;
            onBranch = true;
        } else {
            GitRepository repository = this.myInitialRepository;
            if (repository.isOnBranch()) {
                GitLocalBranch currentBranch = repository.getCurrentBranch();
                assert (currentBranch != null);
                currentBranchOrRev = currentBranch.getName();
                onBranch = true;
            } else {
                currentBranchOrRev = repository.getCurrentRevision();
                onBranch = false;
            }
        }
        StringBuilder description = new StringBuilder();
        if (onBranch) {
            description.append(GitBundle.message("branch.delete.not_fully_merged.description", this.myBranchToDelete, this.myBaseBranch));
        } else {
            description.append(GitBundle.message("branch.delete.not_fully_merged.description.not_on_branch", this.myBranchToDelete, currentBranchOrRev, this.myBaseBranch));
        }
        if (!this.myMergedToBranches.isEmpty()) {
            String listOfMergedBranches = StringUtil.join((String[])StringUtil.surround((String[])ArrayUtil.toStringArray(this.myMergedToBranches), (String)"<b>", (String)"</b>"), (String)", ");
            description.append("<br>");
            if (this.myMergedToBranches.size() == 1) {
                description.append(GitBundle.message("branch.delete.merged_to.one", this.myBranchToDelete, listOfMergedBranches));
            } else {
                description.append(GitBundle.message("branch.delete.merged_to.many", this.myBranchToDelete, listOfMergedBranches));
            }
        }
        description.append("<br>").append(GitBundle.message("branch.delete.warning", this.myBranchToDelete));
        return description.toString();
    }

    protected JComponent createNorthPanel() {
        JBLabel descriptionLabel = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)this.makeDescription()));
        final JComboBox<Object> repositorySelector = new JComboBox<Object>(ArrayUtil.toObjectArray(this.myRepositories, GitRepository.class));
        repositorySelector.setRenderer((ListCellRenderer<Object>)((Object)new GitRepositoryComboboxListCellRenderer(repositorySelector)));
        repositorySelector.setSelectedItem(this.myInitialRepository);
        repositorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List commits = (List)GitBranchIsNotFullyMergedDialog.this.myCommits.get((GitRepository)repositorySelector.getSelectedItem());
                GitBranchIsNotFullyMergedDialog.this.myCommitListWithDiffPanel.setCommits(new ArrayList<GitCommit>(commits));
            }
        });
        JPanel repoSelectorPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel("Repository: ");
        label.setLabelFor((Component)repoSelectorPanel);
        repoSelectorPanel.add((Component)label, "West");
        repoSelectorPanel.add(repositorySelector);
        if (this.myRepositories.size() < 2) {
            repoSelectorPanel.setVisible(false);
        }
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)descriptionLabel);
        northPanel.add((Component)repoSelectorPanel, "South");
        return northPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add(this.myCommitListWithDiffPanel);
        return rootPanel;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    @NotNull
    protected Action[] createActions() {
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        Action[] actionArray = new Action[]{cancelAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitListWithDiffPanel.getPreferredFocusComponent();
    }

    protected String getDimensionServiceKey() {
        return GitBranchIsNotFullyMergedDialog.class.getName();
    }
}

