/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import git4idea.stash.GitStashUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitShelveUtils {
    private static final Logger LOG = Logger.getInstance((String)GitShelveUtils.class.getName());

    public static void doSystemUnshelve(final Project project, ShelvedChangeList shelvedChangeList, ShelveChangesManager shelveManager, @Nullable String leftConflictTitle, @Nullable String rightConflictTitle) {
        VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        String projectPath = baseDir.getPath() + "/";
        LOG.info("refreshing files ");
        GitShelveUtils.refreshFilesBeforeUnshelve(project, shelvedChangeList, projectPath);
        LOG.info("Unshelving shelvedChangeList: " + shelvedChangeList);
        final List changes = shelvedChangeList.getChanges(project);
        shelveManager.unshelveChangeList(shelvedChangeList, changes, shelvedChangeList.getBinaryFiles(), null, false, true, true, leftConflictTitle, rightConflictTitle);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GitShelveUtils.markUnshelvedFilesNonUndoable(project, changes);
            }
        }, ModalityState.defaultModalityState());
    }

    private static void markUnshelvedFilesNonUndoable(final @NotNull Project project, @NotNull List<ShelvedChange> changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/stash/GitShelveUtils", "markUnshelvedFilesNonUndoable"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/stash/GitShelveUtils", "markUnshelvedFilesNonUndoable"));
        }
        final UndoManagerImpl undoManager = (UndoManagerImpl)UndoManager.getInstance((Project)project);
        if (undoManager != null && !changes.isEmpty()) {
            ContainerUtil.process(changes, (Processor)new Processor<ShelvedChange>(){

                public boolean process(ShelvedChange change) {
                    VirtualFile vfUnderProject = VfsUtil.findFileByIoFile((File)new File(project.getBasePath(), change.getAfterPath()), (boolean)false);
                    if (vfUnderProject != null) {
                        DocumentReference documentReference = DocumentReferenceManager.getInstance().create(vfUnderProject);
                        undoManager.nonundoableActionPerformed(documentReference, false);
                        undoManager.invalidateActionsFor(documentReference);
                    }
                    return true;
                }
            });
        }
    }

    private static void refreshFilesBeforeUnshelve(Project project, ShelvedChangeList shelvedChangeList, String projectPath) {
        HashSet<File> filesToRefresh = new HashSet<File>();
        for (ShelvedChange c : shelvedChangeList.getChanges(project)) {
            if (c.getBeforePath() != null) {
                filesToRefresh.add(new File(projectPath + c.getBeforePath()));
            }
            if (c.getAfterPath() == null) continue;
            filesToRefresh.add(new File(projectPath + c.getAfterPath()));
        }
        for (ShelvedBinaryFile f : shelvedChangeList.getBinaryFiles()) {
            if (f.BEFORE_PATH != null) {
                filesToRefresh.add(new File(projectPath + f.BEFORE_PATH));
            }
            if (f.AFTER_PATH == null) continue;
            filesToRefresh.add(new File(projectPath + f.AFTER_PATH));
        }
        LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh);
    }

    @Nullable
    public static ShelvedChangeList shelveChanges(Project project, ShelveChangesManager shelveManager, Collection<Change> changes, String description, List<VcsException> exceptions, boolean rollback, boolean markToBeDeleted) {
        try {
            ShelvedChangeList shelve = shelveManager.shelveChanges(changes, description, rollback, markToBeDeleted);
            ((ChangeListener)project.getMessageBus().syncPublisher(ShelveChangesManager.SHELF_TOPIC)).stateChanged(new ChangeEvent(GitStashUtils.class));
            return shelve;
        }
        catch (IOException e) {
            exceptions.add(new VcsException("Shelving changes failed: " + description, (Throwable)e));
            return null;
        }
        catch (VcsException e) {
            exceptions.add(e);
            return null;
        }
    }
}

