/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;
import org.jetbrains.idea.maven.server.embedder.MavenExecutionResult;

public abstract class Maven3ServerEmbedder
extends MavenRemoteObject
implements MavenServerEmbedder {
    public static final boolean USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING = System.getProperty("idea.maven3.use.compat.resolver") != null;
    private static final String MAVEN_VERSION = System.getProperty("idea.maven.embedder.version");

    protected Maven3ServerEmbedder(MavenServerSettings settings) {
        Maven3ServerEmbedder.initLog4J(settings);
    }

    private static void initLog4J(MavenServerSettings settings) {
        try {
            BasicConfigurator.configure();
            Level rootLoggerLevel = Maven3ServerEmbedder.toLog4JLevel(settings.getLoggingLevel());
            Logger.getRootLogger().setLevel(rootLoggerLevel);
            if (!rootLoggerLevel.isGreaterOrEqual((Priority)Level.ERROR)) {
                Logger.getLogger((String)"org.apache.maven.wagon.providers.http.httpclient.wire").setLevel(Level.ERROR);
                Logger.getLogger((String)"org.apache.http.wire").setLevel(Level.ERROR);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Level toLog4JLevel(int level) {
        switch (level) {
            case 0: {
                return Level.ALL;
            }
            case 3: {
                return Level.ERROR;
            }
            case 4: {
                return Level.FATAL;
            }
            case 5: {
                return Level.OFF;
            }
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.WARN;
            }
        }
        return Level.INFO;
    }

    protected abstract ArtifactRepository getLocalRepository();

    @NotNull
    public List<String> retrieveAvailableVersions(@NotNull String groupId, @NotNull String artifactId, @NotNull List<MavenRemoteRepository> remoteRepositories) throws RemoteException {
        List list;
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "retrieveAvailableVersions"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "retrieveAvailableVersions"));
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteRepositories", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "retrieveAvailableVersions"));
        }
        try {
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "", "compile", "pom", null, (ArtifactHandler)new DefaultArtifactHandler("pom"));
            List versions = this.getComponent(ArtifactMetadataSource.class).retrieveAvailableVersions((Artifact)artifact, this.getLocalRepository(), this.convertRepositories(remoteRepositories));
            list = ContainerUtil.map((Collection)versions, (Function)new Function<ArtifactVersion, String>(){

                public String fun(ArtifactVersion version) {
                    return version.toString();
                }
            });
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info(e);
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "retrieveAvailableVersions"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "retrieveAvailableVersions"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<ProjectBuildingResult> getProjectBuildingResults(@NotNull MavenExecutionRequest request, @NotNull Collection<File> files) {
        Object buildingResults;
        block11: {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "getProjectBuildingResults"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "getProjectBuildingResults"));
            }
            ProjectBuilder builder = this.getComponent(ProjectBuilder.class);
            CustomMaven3ModelInterpolator2 modelInterpolator = (CustomMaven3ModelInterpolator2)this.getComponent(ModelInterpolator.class);
            String savedLocalRepository = modelInterpolator.getLocalRepository();
            modelInterpolator.setLocalRepository(request.getLocalRepositoryPath().getAbsolutePath());
            buildingResults = new SmartList();
            ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
            projectBuildingRequest.setValidationLevel(0);
            projectBuildingRequest.setResolveDependencies(false);
            try {
                if (files.size() == 1) {
                    Maven3ServerEmbedder.buildSinglePom(builder, (List<ProjectBuildingResult>)buildingResults, projectBuildingRequest, files.iterator().next());
                    break block11;
                }
                try {
                    buildingResults = builder.build(new ArrayList<File>(files), false, projectBuildingRequest);
                }
                catch (ProjectBuildingException e) {
                    for (ProjectBuildingResult result : e.getResults()) {
                        if (result.getProject() != null) {
                            buildingResults.add(result);
                            continue;
                        }
                        Maven3ServerEmbedder.buildSinglePom(builder, (List<ProjectBuildingResult>)buildingResults, projectBuildingRequest, result.getPomFile());
                    }
                }
            }
            finally {
                modelInterpolator.setLocalRepository(savedLocalRepository);
            }
        }
        Object object = buildingResults;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "getProjectBuildingResults"));
        }
        return object;
    }

    private static void buildSinglePom(ProjectBuilder builder, List<ProjectBuildingResult> buildingResults, ProjectBuildingRequest projectBuildingRequest, File pomFile) {
        try {
            ProjectBuildingResult build = builder.build(pomFile, projectBuildingRequest);
            buildingResults.add(build);
        }
        catch (ProjectBuildingException e) {
            buildingResults.addAll(e.getResults());
        }
    }

    protected void addMvn2CompatResults(MavenProject project, List<Exception> exceptions, List<ResolutionListener> listeners, ArtifactRepository localRepository, Collection<MavenExecutionResult> executionResults) {
        ArtifactResolutionRequest resolutionRequest = new ArtifactResolutionRequest();
        resolutionRequest.setArtifactDependencies(project.getDependencyArtifacts());
        resolutionRequest.setArtifact(project.getArtifact());
        resolutionRequest.setManagedVersionMap(project.getManagedVersionMap());
        resolutionRequest.setLocalRepository(localRepository);
        resolutionRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
        resolutionRequest.setListeners(listeners);
        resolutionRequest.setResolveRoot(false);
        resolutionRequest.setResolveTransitively(true);
        ArtifactResolver resolver = this.getComponent(ArtifactResolver.class);
        ArtifactResolutionResult result = resolver.resolve(resolutionRequest);
        project.setArtifacts(result.getArtifacts());
        executionResults.add(new MavenExecutionResult(project, exceptions));
    }

    @NotNull
    protected abstract List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> var1) throws RemoteException;

    @Nullable
    public String getMavenVersion() {
        return MAVEN_VERSION;
    }

    public abstract <T> T getComponent(Class<T> var1, String var2);

    public abstract <T> T getComponent(Class<T> var1);

    public abstract void executeWithMavenSession(MavenExecutionRequest var1, Runnable var2);

    public abstract MavenExecutionRequest createRequest(File var1, List<String> var2, List<String> var3, List<String> var4) throws RemoteException;
}

