/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.runner.Description;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.VintageTestDescriptor;
import org.junit.vintage.engine.discovery.RunnerTestDescriptorAwareFilter;

class UniqueIdFilter
extends RunnerTestDescriptorAwareFilter {
    private final UniqueId uniqueId;
    private Deque<Description> path;
    private Set<Description> descendants;

    public UniqueIdFilter(UniqueId uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Override
    void initialize(RunnerTestDescriptor runnerTestDescriptor) {
        Optional identifiedTestDescriptor = runnerTestDescriptor.findByUniqueId(this.uniqueId);
        this.descendants = this.determineDescendants(identifiedTestDescriptor);
        this.path = this.determinePath(runnerTestDescriptor, identifiedTestDescriptor);
    }

    private Deque<Description> determinePath(RunnerTestDescriptor runnerTestDescriptor, Optional<? extends TestDescriptor> identifiedTestDescriptor) {
        LinkedList<Description> path = new LinkedList<Description>();
        Optional current = identifiedTestDescriptor;
        while (current.isPresent() && !current.get().equals((Object)runnerTestDescriptor)) {
            path.addFirst(((VintageTestDescriptor)current.get()).getDescription());
            current = current.get().getParent();
        }
        return path;
    }

    private Set<Description> determineDescendants(Optional<? extends TestDescriptor> identifiedTestDescriptor) {
        if (identifiedTestDescriptor.isPresent()) {
            return identifiedTestDescriptor.get().getAllDescendants().stream().map(VintageTestDescriptor.class::cast).map(VintageTestDescriptor::getDescription).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public boolean shouldRun(Description description) {
        return this.path.contains(description) || this.descendants.contains(description);
    }

    public String describe() {
        return "Unique ID " + this.uniqueId;
    }
}

