/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class QuickFixGetFamilyNameViolationInspection
extends DevKitInspectionBase {
    private static final Logger LOG = Logger.getInstance(QuickFixGetFamilyNameViolationInspection.class);

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClass aClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/inspections/QuickFixGetFamilyNameViolationInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/devkit/inspections/QuickFixGetFamilyNameViolationInspection", "checkMethod"));
        }
        if ("getFamilyName".equals(method.getName()) && method.getParameterList().getParametersCount() == 0 && !method.hasModifierProperty("abstract") && InheritanceUtil.isInheritor((PsiClass)(aClass = method.getContainingClass()), (String)QuickFix.class.getName()) && QuickFixGetFamilyNameViolationInspection.doesMethodViolate(method)) {
            PsiIdentifier identifier = method.getNameIdentifier();
            LOG.assertTrue(identifier != null);
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, "QuickFix's getFamilyName() implementation must not depend on a specific context", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true)};
        }
        return null;
    }

    private static boolean doesMethodViolate(PsiMethod method) {
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        Collection referenceIterator = PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiJavaCodeReferenceElement.class);
        for (PsiJavaCodeReferenceElement reference : referenceIterator) {
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PsiVariable) {
                if ((resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) && !PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)resolved, (boolean)false)) {
                    return true;
                }
                if (resolved instanceof PsiField && !((PsiField)resolved).hasModifierProperty("static")) {
                    return true;
                }
            }
            if (!(resolved instanceof PsiMethod) || ((PsiMethod)resolved).hasModifierProperty("static")) continue;
            PsiClass resolvedContainingClass = ((PsiMethod)resolved).getContainingClass();
            PsiClass methodContainingClass = method.getContainingClass();
            if (resolvedContainingClass == null || methodContainingClass == null || methodContainingClass != resolvedContainingClass && !methodContainingClass.isInheritor(resolvedContainingClass, true) || !QuickFixGetFamilyNameViolationInspection.doesMethodViolate((PsiMethod)resolved)) continue;
            return true;
        }
        return false;
    }
}

