/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVariableKind;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;

public class CleanupDetector
extends Detector
implements UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue RECYCLE_RESOURCE = Issue.create("Recycle", "Missing `recycle()` calls", "Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled (with a `recycle()` call) after use. This lint check looks for missing `recycle()` calls.", Category.PERFORMANCE, 7, Severity.WARNING, IMPLEMENTATION);
    public static final Issue COMMIT_FRAGMENT = Issue.create("CommitTransaction", "Missing `commit()` calls", "After creating a `FragmentTransaction`, you typically need to commit it as well", Category.CORRECTNESS, 7, Severity.WARNING, IMPLEMENTATION);
    private static final String RECYCLE = "recycle";
    private static final String RELEASE = "release";
    private static final String OBTAIN = "obtain";
    private static final String SHOW = "show";
    private static final String ACQUIRE_CPC = "acquireContentProviderClient";
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    private static final String COMMIT = "commit";
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    private static final String QUERY = "query";
    private static final String RAW_QUERY = "rawQuery";
    private static final String QUERY_WITH_FACTORY = "queryWithFactory";
    private static final String RAW_QUERY_WITH_FACTORY = "rawQueryWithFactory";
    private static final String CLOSE = "close";
    private static final String MOTION_EVENT_CLS = "android.view.MotionEvent";
    private static final String RESOURCES_CLS = "android.content.res.Resources";
    private static final String PARCEL_CLS = "android.os.Parcel";
    private static final String TYPED_ARRAY_CLS = "android.content.res.TypedArray";
    private static final String VELOCITY_TRACKER_CLS = "android.view.VelocityTracker";
    private static final String DIALOG_FRAGMENT = "android.app.DialogFragment";
    private static final String DIALOG_V4_FRAGMENT = "android.support.v4.app.DialogFragment";
    private static final String FRAGMENT_MANAGER_CLS = "android.app.FragmentManager";
    private static final String FRAGMENT_MANAGER_V4_CLS = "android.support.v4.app.FragmentManager";
    private static final String FRAGMENT_TRANSACTION_CLS = "android.app.FragmentTransaction";
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android.support.v4.app.FragmentTransaction";
    public static final String SURFACE_CLS = "android.view.Surface";
    public static final String SURFACE_TEXTURE_CLS = "android.graphics.SurfaceTexture";
    public static final String CONTENT_PROVIDER_CLIENT_CLS = "android.content.ContentProviderClient";
    public static final String CONTENT_RESOLVER_CLS = "android.content.ContentResolver";
    public static final String CONTENT_PROVIDER_CLS = "android.content.ContentProvider";
    public static final String SQLITE_DATABASE_CLS = "android.database.sqlite.SQLiteDatabase";
    public static final String CURSOR_CLS = "android.database.Cursor";

    @Override
    public List<String> getApplicableFunctionNames() {
        return Arrays.asList(BEGIN_TRANSACTION, OBTAIN, OBTAIN_NO_HISTORY, OBTAIN_STYLED_ATTRIBUTES, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, ACQUIRE_CPC, QUERY, RAW_QUERY, QUERY_WITH_FACTORY, RAW_QUERY_WITH_FACTORY);
    }

    @Override
    @Nullable
    public List<String> getApplicableConstructorTypes() {
        return Arrays.asList(SURFACE_TEXTURE_CLS, SURFACE_CLS);
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        if (node.matchesFunctionName(BEGIN_TRANSACTION)) {
            CleanupDetector.checkTransactionCommits(context, node);
        } else {
            CleanupDetector.checkResourceRecycled(context, node, node.getFunctionName());
        }
    }

    @Override
    public void visitConstructor(UastAndroidContext context, UCallExpression functionCall, UFunction constructor) {
        UClass containingClass = UastUtils.getContainingClass(constructor);
        if (containingClass != null) {
            CleanupDetector.checkRecycled(context, functionCall, containingClass.getFqName(), RELEASE);
        }
    }

    private static void checkResourceRecycled(@NonNull UastAndroidContext context, @NonNull UCallExpression node, @NonNull String name2) {
        UFunction method = node.resolve(context);
        if (method == null) {
            return;
        }
        UClass containingClass = UastUtils.getContainingClass(method);
        if (containingClass == null) {
            return;
        }
        if ((OBTAIN.equals(name2) || OBTAIN_NO_HISTORY.equals(name2)) && containingClass.isSubclassOf(MOTION_EVENT_CLS)) {
            CleanupDetector.checkRecycled(context, node, MOTION_EVENT_CLS, RECYCLE);
        } else if (OBTAIN.equals(name2) && containingClass.isSubclassOf(PARCEL_CLS)) {
            CleanupDetector.checkRecycled(context, node, PARCEL_CLS, RECYCLE);
        } else if (OBTAIN.equals(name2) && containingClass.isSubclassOf(VELOCITY_TRACKER_CLS)) {
            CleanupDetector.checkRecycled(context, node, VELOCITY_TRACKER_CLS, RECYCLE);
        } else if ((OBTAIN_STYLED_ATTRIBUTES.equals(name2) || OBTAIN_ATTRIBUTES.equals(name2) || OBTAIN_TYPED_ARRAY.equals(name2)) && (containingClass.isSubclassOf("android.content.Context") || containingClass.isSubclassOf(RESOURCES_CLS))) {
            UType returnType2 = method.getReturnType();
            if (returnType2 != null && returnType2.matchesFqName(TYPED_ARRAY_CLS)) {
                CleanupDetector.checkRecycled(context, node, TYPED_ARRAY_CLS, RECYCLE);
            }
        } else if (ACQUIRE_CPC.equals(name2) && containingClass.isSubclassOf(CONTENT_RESOLVER_CLS)) {
            CleanupDetector.checkRecycled(context, node, CONTENT_PROVIDER_CLIENT_CLS, RELEASE);
        } else if ((QUERY.equals(name2) || RAW_QUERY.equals(name2) || QUERY_WITH_FACTORY.equals(name2) || RAW_QUERY_WITH_FACTORY.equals(name2)) && (containingClass.isSubclassOf(SQLITE_DATABASE_CLS) || containingClass.isSubclassOf(CONTENT_RESOLVER_CLS) || containingClass.isSubclassOf(CONTENT_PROVIDER_CLS) || containingClass.isSubclassOf(CONTENT_PROVIDER_CLIENT_CLS))) {
            CleanupDetector.checkRecycled(context, node, CURSOR_CLS, CLOSE);
        }
    }

    private static void checkRecycled(@NonNull UastAndroidContext context, @NonNull UElement node, final @NonNull String recycleType, final @NonNull String recycleName) {
        UVariable boundVariable = CleanupDetector.getVariable(context, node);
        if (boundVariable == null) {
            return;
        }
        UFunction method = UastUtils.getContainingFunction(node);
        if (method == null) {
            return;
        }
        FinishVisitor visitor2 = new FinishVisitor(context, boundVariable){

            @Override
            protected boolean isCleanupCall(@NonNull UCallExpression call) {
                UExpression operand2;
                UElement parent;
                UClass containingClass;
                if (!call.matchesFunctionName(recycleName)) {
                    return false;
                }
                UDeclaration resolved = call.resolve(this.mContext);
                return resolved != null && (containingClass = UastUtils.getContainingClassOrEmpty(resolved)).isSubclassOf(recycleType) && (parent = call.getParent()) instanceof UQualifiedExpression && (resolved = UastUtils.resolveIfCan(operand2 = ((UQualifiedExpression)parent).getReceiver(), this.mContext)) != null && this.mVariables.contains(resolved);
            }
        };
        method.accept(visitor2);
        if (visitor2.isCleanedUp() || visitor2.variableEscapes()) {
            return;
        }
        String className = recycleType.substring(recycleType.lastIndexOf(46) + 1);
        String message2 = RECYCLE.equals(recycleName) ? String.format("This `%1$s` should be recycled after use with `#recycle()`", className) : String.format("This `%1$s` should be freed up after use with `#%2$s()`", className, recycleName);
        UElement locationNode = node instanceof UCallExpression ? ((UCallExpression)node).getFunctionNameElement() : node;
        Location location = context.getLocation(locationNode);
        context.report(RECYCLE_RESOURCE, node, location, message2);
    }

    private static boolean checkTransactionCommits(@NonNull UastAndroidContext context, @NonNull UCallExpression node) {
        if (CleanupDetector.isBeginTransaction(context, node)) {
            UVariable boundVariable = CleanupDetector.getVariable(context, node);
            if (boundVariable == null && CleanupDetector.isCommittedInChainedCalls(context, node)) {
                return true;
            }
            if (boundVariable != null) {
                UFunction method = UastUtils.getContainingFunction(node);
                if (method == null) {
                    return true;
                }
                FinishVisitor commitVisitor = new FinishVisitor(context, boundVariable){

                    @Override
                    protected boolean isCleanupCall(@NonNull UCallExpression call) {
                        UExpression first;
                        UDeclaration resolved;
                        List<UExpression> arguments;
                        if (CleanupDetector.isTransactionCommitMethodCall(this.mContext, call)) {
                            UExpression operand2 = UastUtils.getReceiver(call);
                            if (operand2 instanceof UResolvable) {
                                UDeclaration resolved2 = ((UResolvable)((Object)operand2)).resolve(this.mContext);
                                if (resolved2 != null && this.mVariables.contains(resolved2)) {
                                    return true;
                                }
                                if (resolved2 instanceof UFunction && operand2 instanceof UCallExpression && CleanupDetector.isCommittedInChainedCalls(this.mContext, (UCallExpression)operand2)) {
                                    while (operand2 instanceof UCallExpression) {
                                        operand2 = UastUtils.getReceiver((UCallExpression)operand2);
                                    }
                                    if (operand2 instanceof USimpleReferenceExpression && (resolved2 = ((USimpleReferenceExpression)operand2).resolve(this.mContext)) != null && this.mVariables.contains(resolved2)) {
                                        return true;
                                    }
                                }
                            }
                        } else if (CleanupDetector.isShowFragmentMethodCall(this.mContext, call) && (arguments = call.getValueArguments()).size() == 2 && (resolved = UastUtils.resolveIfCan(first = arguments.get(0), this.mContext)) != null && this.mVariables.contains(resolved)) {
                            return true;
                        }
                        return false;
                    }
                };
                method.accept(commitVisitor);
                if (commitVisitor.isCleanedUp() || commitVisitor.variableEscapes()) {
                    return true;
                }
            }
            String message2 = "This transaction should be completed with a `commit()` call";
            context.report(COMMIT_FRAGMENT, node, context.getLocation(node.getFunctionReference()), message2);
        }
        return false;
    }

    private static boolean isCommittedInChainedCalls(@NonNull UastAndroidContext context, @NonNull UCallExpression node) {
        UCallExpression methodInvocation;
        UExpression lastExpression;
        List<UExpression> chain = UastUtils.getQualifiedChain(node);
        return chain.size() > 0 && (lastExpression = chain.get(chain.size() - 1)) instanceof UCallExpression && (CleanupDetector.isTransactionCommitMethodCall(context, methodInvocation = (UCallExpression)lastExpression) || CleanupDetector.isShowFragmentMethodCall(context, methodInvocation));
    }

    private static boolean isTransactionCommitMethodCall(@NonNull UastAndroidContext context, @NonNull UCallExpression call) {
        return (call.matchesFunctionName(COMMIT) || call.matchesFunctionName(COMMIT_ALLOWING_LOSS)) && CleanupDetector.isMethodOnFragmentClass(context, call, FRAGMENT_TRANSACTION_CLS, FRAGMENT_TRANSACTION_V4_CLS);
    }

    private static boolean isShowFragmentMethodCall(@NonNull UastAndroidContext context, @NonNull UCallExpression call) {
        return call.matchesFunctionName(SHOW) && CleanupDetector.isMethodOnFragmentClass(context, call, DIALOG_FRAGMENT, DIALOG_V4_FRAGMENT);
    }

    private static boolean isMethodOnFragmentClass(@NonNull UastAndroidContext context, @NonNull UCallExpression call, @NonNull String fragmentClass, @NonNull String v4FragmentClass) {
        UFunction resolved = call.resolve(context);
        if (resolved != null) {
            UClass containingClass = UastUtils.getContainingClassOrEmpty(resolved);
            return containingClass.isSubclassOf(fragmentClass) || containingClass.isSubclassOf(v4FragmentClass);
        }
        return false;
    }

    @Nullable
    public static UVariable getVariable(@NonNull UastAndroidContext context, @NonNull UElement expression2) {
        if (!(expression2 instanceof UExpression)) {
            return null;
        }
        UQualifiedExpression topMostQualified = UastUtils.findOutermostQualifiedExpression((UExpression)expression2);
        if (topMostQualified == null) {
            return null;
        }
        UElement parent = topMostQualified.getParent();
        if (parent instanceof UBinaryExpression) {
            UDeclaration resolved;
            UExpression lhs;
            UBinaryExpression binaryExpression = (UBinaryExpression)parent;
            if (binaryExpression.getOperator() == UastBinaryOperator.ASSIGN && (lhs = binaryExpression.getLeftOperand()) instanceof UResolvable && (resolved = ((UResolvable)((Object)lhs)).resolve(context)) instanceof UVariable) {
                return (UVariable)resolved;
            }
        } else if (parent instanceof UVariable) {
            return (UVariable)parent;
        }
        return null;
    }

    private static boolean isBeginTransaction(@NonNull UastAndroidContext context, @NonNull UCallExpression node) {
        UClass containingClass;
        UFunction method;
        assert (node.matchesFunctionName(BEGIN_TRANSACTION)) : node.renderString();
        return node.matchesFunctionName(BEGIN_TRANSACTION) && (method = node.resolve(context)) != null && ((containingClass = UastUtils.getContainingClassOrEmpty(method)).isSubclassOf(FRAGMENT_MANAGER_CLS) || containingClass.isSubclassOf(FRAGMENT_MANAGER_V4_CLS));
    }

    private static abstract class FinishVisitor
    extends AbstractUastVisitor {
        protected final UastAndroidContext mContext;
        protected final List<UVariable> mVariables;
        private boolean mContainsCleanup;
        private boolean mEscapes;

        public FinishVisitor(UastAndroidContext context, @NonNull UVariable variable2) {
            this.mContext = context;
            this.mVariables = Lists.newArrayList((Object[])new UVariable[]{variable2});
        }

        public boolean isCleanedUp() {
            return this.mContainsCleanup;
        }

        public boolean variableEscapes() {
            return this.mEscapes;
        }

        @Override
        public boolean visitElement(@NotNull UElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/CleanupDetector$FinishVisitor", "visitElement"));
            }
            return this.mContainsCleanup || super.visitElement(node);
        }

        protected abstract boolean isCleanupCall(@NonNull UCallExpression var1);

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/android/tools/klint/checks/CleanupDetector$FinishVisitor", "visitCallExpression"));
            }
            if (this.mContainsCleanup) {
                return true;
            }
            if (!this.mEscapes) {
                for (UExpression expression2 : call.getValueArguments()) {
                    UClass cls;
                    UFunction method;
                    UDeclaration resolved;
                    if (!(expression2 instanceof USimpleReferenceExpression) || (resolved = ((USimpleReferenceExpression)expression2).resolve(this.mContext)) == null || !this.mVariables.contains(resolved)) continue;
                    this.mEscapes = true;
                    if (!CleanupDetector.OBTAIN.equals(call.getFunctionName()) || (method = call.resolve(this.mContext)) == null || !(cls = UastUtils.getContainingClassOrEmpty(method)).matchesFqName(CleanupDetector.MOTION_EVENT_CLS)) continue;
                    this.mEscapes = false;
                }
            }
            if (this.isCleanupCall(call)) {
                this.mContainsCleanup = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean visitVariable(@NotNull UVariable node) {
            UDeclaration resolved;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/CleanupDetector$FinishVisitor", "visitVariable"));
            }
            UExpression initializer2 = node.getInitializer();
            if (initializer2 instanceof USimpleReferenceExpression && (resolved = ((USimpleReferenceExpression)initializer2).resolve(this.mContext)) != null && this.mVariables.contains(resolved)) {
                if (node.getKind() == UastVariableKind.LOCAL_VARIABLE) {
                    this.mVariables.add(node);
                } else if (node.getKind() == UastVariableKind.MEMBER) {
                    this.mEscapes = true;
                }
            }
            return false;
        }

        @Override
        public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
            UExpression rhs;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/CleanupDetector$FinishVisitor", "visitBinaryExpression"));
            }
            if (node.getOperator() == UastBinaryOperator.ASSIGN && (rhs = node.getRightOperand()) instanceof USimpleReferenceExpression) {
                UDeclaration resolvedLhs;
                UDeclaration resolved = ((USimpleReferenceExpression)rhs).resolve(this.mContext);
                UExpression leftOperand2 = node.getLeftOperand();
                if (resolved != null && this.mVariables.contains(resolved) && leftOperand2 instanceof UResolvable && (resolvedLhs = ((UResolvable)((Object)leftOperand2)).resolve(this.mContext)) instanceof UVariable) {
                    UVariable variable2 = (UVariable)resolvedLhs;
                    if (variable2.getKind() == UastVariableKind.LOCAL_VARIABLE) {
                        this.mVariables.add(variable2);
                    } else if (variable2.getKind() == UastVariableKind.MEMBER) {
                        this.mEscapes = true;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean visitReturnExpression(@NotNull UReturnExpression node) {
            UDeclaration resolved;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/CleanupDetector$FinishVisitor", "visitReturnExpression"));
            }
            UExpression value2 = node.getReturnExpression();
            if (value2 instanceof USimpleReferenceExpression && (resolved = ((USimpleReferenceExpression)value2).resolve(this.mContext)) != null && this.mVariables.contains(resolved)) {
                this.mEscapes = true;
            }
            return false;
        }
    }
}

