/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class CustomViewDetector
extends Detector
implements UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CustomViewDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("CustomViewStyleable", "Mismatched Styleable/Custom View Name", "The convention for custom views is to use a `declare-styleable` whose name matches the custom view class name. The IDE relies on this convention such that for example code completion can be offered for attributes in a custom view in layout XML resource files.\n\n(Similarly, layout parameter classes should use the suffix `_Layout`.)", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList(OBTAIN_STYLED_ATTRIBUTES);
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        if (node.getParent() instanceof UExpression) {
            int parameterIndex;
            if (!context.getLintContext().isContextMethod(node)) {
                return;
            }
            List<UExpression> expressions2 = node.getValueArguments();
            int size = expressions2.size();
            if (size == 1) {
                parameterIndex = 0;
            } else if (size > 1) {
                parameterIndex = 1;
            } else {
                return;
            }
            UExpression expression2 = expressions2.get(parameterIndex);
            if (!(expression2 instanceof UQualifiedExpression)) {
                return;
            }
            String s = expression2.renderString();
            if (!s.startsWith("R.styleable.")) {
                return;
            }
            String styleableName = s.substring("R.styleable.".length());
            UClass resolvedClass = UastUtils.getContainingClass(node);
            if (resolvedClass == null) {
                return;
            }
            String className = resolvedClass.getName();
            if (resolvedClass.isSubclassOf("android.view.View")) {
                if (!styleableName.equals(className)) {
                    String message2 = String.format("By convention, the custom view (`%1$s`) and the declare-styleable (`%2$s`) should have the same name (various editor features rely on this convention)", className, styleableName);
                    context.report(ISSUE, node, context.getLocation(expression2), message2);
                }
            } else if (resolvedClass.isSubclassOf("android.view.ViewGroup.LayoutParams")) {
                UClass outer = UastUtils.getContainingClass(resolvedClass);
                if (outer == null) {
                    return;
                }
                String layoutClassName = outer.getName();
                String expectedName = layoutClassName + "_Layout";
                if (!styleableName.equals(expectedName)) {
                    String message3 = String.format("By convention, the declare-styleable (`%1$s`) for a layout parameter class (`%2$s`) is expected to be the surrounding class (`%3$s`) plus \"`_Layout`\", e.g. `%4$s`. (Various editor features rely on this convention.)", styleableName, className, layoutClassName, expectedName);
                    context.report(ISSUE, node, context.getLocation(expression2), message3);
                }
            }
        }
    }
}

