/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryExpressionWithTypeUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;

public class CutPasteDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("CutPasteId", "Likely cut & paste mistakes", "This lint check looks for cases where you have cut & pasted calls to `findViewById` but have forgotten to update the R.id field. It's possible that your code is simply (redundantly) looking up the field repeatedly, but lint cannot distinguish that from a case where you for example want to initialize fields `prev` and `next` and you cut & pasted `findViewById(R.id.prev)` and forgot to update the second initialization to `R.id.next`.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(CutPasteDetector.class, Scope.SOURCE_FILE_SCOPE));
    private UFunction mLastMethod;
    private Map<String, UCallExpression> mIds;
    private Map<String, String> mLhs;
    private Map<String, String> mCallOperands;

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList("findViewById");
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        UExpression first;
        String lhs = CutPasteDetector.getLhs(node);
        if (lhs == null) {
            return;
        }
        UFunction method = UastUtils.getContainingFunction(node);
        if (method == null) {
            return;
        }
        if (method != this.mLastMethod) {
            this.mIds = Maps.newHashMap();
            this.mLhs = Maps.newHashMap();
            this.mCallOperands = Maps.newHashMap();
            this.mLastMethod = method;
        }
        UElement parent = node.getParent();
        String callOperand = "";
        if (parent instanceof UQualifiedExpression) {
            callOperand = ((UQualifiedExpression)parent).getReceiver().renderString();
        }
        if ((first = node.getValueArguments().get(0)) instanceof UQualifiedExpression) {
            UQualifiedExpression type2;
            UQualifiedExpression select = (UQualifiedExpression)first;
            String id = select.getSelector().renderString();
            UExpression operand2 = select.getReceiver();
            if (operand2 instanceof UQualifiedExpression && (type2 = (UQualifiedExpression)operand2).getSelector().renderString().equals("id")) {
                if (this.mIds.containsKey(id)) {
                    if (lhs.equals(this.mLhs.get(id))) {
                        return;
                    }
                    if (!callOperand.equals(this.mCallOperands.get(id))) {
                        return;
                    }
                    UCallExpression earlierCall = this.mIds.get(id);
                    if (!CutPasteDetector.isReachableFrom(method, earlierCall, node)) {
                        return;
                    }
                    Location location = context.getLocation(node);
                    Location secondary = context.getLocation(earlierCall);
                    if (location != null && secondary != null) {
                        secondary.setMessage("First usage here");
                        location.setSecondary(secondary);
                        context.report(ISSUE, node, location, String.format("The id `%1$s` has already been looked up in this method; possible cut & paste error?", first.toString()));
                    }
                } else {
                    this.mIds.put(id, node);
                    this.mLhs.put(id, lhs);
                    this.mCallOperands.put(id, callOperand);
                }
            }
        }
    }

    @Nullable
    private static String getLhs(@NonNull UCallExpression call) {
        UElement parent = call.getParent();
        if (UastBinaryExpressionWithTypeUtils.isTypeCast(parent)) {
            assert (parent != null);
            parent = parent.getParent();
        }
        if (parent instanceof UVariable) {
            UVariable vde = (UVariable)parent;
            return vde.getName();
        }
        if (parent instanceof UBinaryExpression) {
            UBinaryExpression be = (UBinaryExpression)parent;
            UExpression left = be.getLeftOperand();
            if (left instanceof USimpleReferenceExpression || left instanceof UQualifiedExpression) {
                return be.getLeftOperand().toString();
            }
            if (left instanceof UArrayAccessExpression) {
                UArrayAccessExpression aa = (UArrayAccessExpression)left;
                return aa.getReceiver().toString();
            }
        }
        return null;
    }

    private static boolean isReachableFrom(@NonNull UElement method, @NonNull UCallExpression from, @NonNull UCallExpression to) {
        ReachableVisitor visitor2 = new ReachableVisitor(from, to);
        method.accept(visitor2);
        return visitor2.isReachable();
    }

    private static class ReachableVisitor
    extends AbstractUastVisitor {
        @NonNull
        private final UCallExpression mFrom;
        @NonNull
        private final UCallExpression mTo;
        private boolean mReachable;
        private boolean mSeenEnd;

        public ReachableVisitor(@NonNull UCallExpression from, @NonNull UCallExpression to) {
            this.mFrom = from;
            this.mTo = to;
        }

        boolean isReachable() {
            return this.mReachable;
        }

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/CutPasteDetector$ReachableVisitor", "visitCallExpression"));
            }
            if (node == this.mFrom) {
                this.mReachable = true;
            } else if (node == this.mTo) {
                this.mSeenEnd = true;
            }
            return false;
        }

        @Override
        public boolean visitIfExpression(@NotNull UIfExpression node) {
            boolean wasReachable;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/CutPasteDetector$ReachableVisitor", "visitIfExpression"));
            }
            UExpression condition2 = node.getCondition();
            UExpression body2 = node.getThenBranch();
            UExpression elseBody = node.getElseBranch();
            condition2.accept(this);
            if (body2 != null) {
                wasReachable = this.mReachable;
                body2.accept(this);
                this.mReachable = wasReachable;
            }
            if (elseBody != null) {
                wasReachable = this.mReachable;
                elseBody.accept(this);
                this.mReachable = wasReachable;
            }
            return false;
        }

        @Override
        public boolean visitElement(@NotNull UElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/CutPasteDetector$ReachableVisitor", "visitElement"));
            }
            return this.mSeenEnd;
        }
    }
}

