/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class GetSignaturesDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("PackageManagerGetSignatures", "Potential Multiple Certificate Exploit", "Improper validation of app signatures could lead to issues where a malicious app submits itself to the Play Store with both its real certificate and a fake certificate and gains access to functionality or information it shouldn't have due to another application only checking for the fake certificate and ignoring the rest. Please make sure to validate all signatures returned by this method.", Category.SECURITY, 8, Severity.INFORMATIONAL, new Implementation(GetSignaturesDetector.class, Scope.SOURCE_FILE_SCOPE)).addMoreInfo("https://bluebox.com/technical/android-fake-id-vulnerability/");
    private static final String PACKAGE_MANAGER_CLASS = "android.content.pm.PackageManager";
    private static final String GET_PACKAGE_INFO = "getPackageInfo";
    private static final int GET_SIGNATURES_FLAG = 64;

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList(GET_PACKAGE_INFO);
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        UType firstParameterType;
        UFunction resolved = node.resolve(context);
        if (resolved == null || !UastUtils.getContainingClassOrEmpty(resolved).isSubclassOf(PACKAGE_MANAGER_CLASS)) {
            return;
        }
        List<UExpression> argumentList = node.getValueArguments();
        if (argumentList.size() == 2 && (firstParameterType = argumentList.get(0).getExpressionType()) != null && firstParameterType.matchesFqName("java.lang.String")) {
            GetSignaturesDetector.maybeReportIssue(GetSignaturesDetector.calculateValue(context, argumentList.get(1)), context, node);
        }
    }

    private static void maybeReportIssue(int flagValue, UastAndroidContext context, UCallExpression node) {
        if ((flagValue & 0x40) != 0) {
            context.report(ISSUE, node, context.getLocation(node.getValueArguments().get(1)), "Reading app signatures from getPackageInfo: The app signatures could be exploited if not validated properly; see issue explanation for details.");
        }
    }

    private static int calculateValue(UastAndroidContext context, UExpression expression2) {
        Object value2;
        UExpression initializer2;
        UDeclaration resolvedNode;
        if (UastLiteralUtils.isIntegralLiteral(expression2)) {
            return (int)UastLiteralUtils.getLongValue((ULiteralExpression)expression2);
        }
        if (expression2 instanceof UResolvable && (resolvedNode = ((UResolvable)((Object)expression2)).resolve(context)) instanceof UVariable && (initializer2 = ((UVariable)resolvedNode).getInitializer()) != null && (value2 = initializer2.evaluate()) instanceof Integer) {
            return (Integer)value2;
        }
        if (expression2 instanceof UBinaryExpression) {
            UBinaryExpression binaryExpression = (UBinaryExpression)expression2;
            UastBinaryOperator operator2 = binaryExpression.getOperator();
            int leftValue = GetSignaturesDetector.calculateValue(context, binaryExpression.getLeftOperand());
            int rightValue = GetSignaturesDetector.calculateValue(context, binaryExpression.getRightOperand());
            if (operator2 == UastBinaryOperator.BITWISE_OR) {
                return leftValue | rightValue;
            }
            if (operator2 == UastBinaryOperator.BITWISE_AND) {
                return leftValue & rightValue;
            }
            if (operator2 == UastBinaryOperator.BITWISE_XOR) {
                return leftValue ^ rightValue;
            }
        }
        return 0;
    }
}

