/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastFunctionKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;

public class JavaScriptInterfaceDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("JavascriptInterface", "Missing @JavascriptInterface on methods", "As of API 17, you must annotate methods in objects registered with the `addJavascriptInterface` method with a `@JavascriptInterface` annotation.", Category.SECURITY, 8, Severity.ERROR, new Implementation(JavaScriptInterfaceDetector.class, Scope.SOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/webkit/WebView.html#addJavascriptInterface(java.lang.Object, java.lang.String)");
    private static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";
    private static final String JAVASCRIPT_INTERFACE_CLS = "android.webkit.JavascriptInterface";
    private static final String WEB_VIEW_CLS = "android.webkit.WebView";

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList(ADD_JAVASCRIPT_INTERFACE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        UFunction method;
        if (context.getLintContext().getMainProject().getTargetSdk() < 17) {
            return;
        }
        if (node.getValueArgumentCount() != 2) {
            return;
        }
        if (!JavaScriptInterfaceDetector.isCallOnWebView(context, node)) {
            return;
        }
        UExpression first = node.getValueArguments().get(0);
        UDeclaration resolved = UastUtils.resolveIfCan(first, context);
        if (resolved instanceof UVariable) {
            method = UastUtils.getContainingFunction(node);
            if (method == null) return;
            ConcreteTypeVisitor v = new ConcreteTypeVisitor(context, node);
            method.accept(v);
            resolved = v.getType();
            if (resolved == null) {
                return;
            }
        } else if (resolved instanceof UFunction) {
            method = (UFunction)resolved;
            if (method.getKind() == UastFunctionKind.CONSTRUCTOR) {
                resolved = UastUtils.getContainingClass(method);
            } else {
                UClass resolvedClass;
                UType returnType2 = method.getReturnType();
                if (returnType2 != null && (resolvedClass = returnType2.resolve(context)) != null) {
                    resolved = resolvedClass;
                }
            }
        } else {
            UClass resolvedClass;
            UType type2 = first.getExpressionType();
            if (type2 != null && (resolvedClass = type2.resolve(context)) != null) {
                resolved = resolvedClass;
            }
        }
        if (!(resolved instanceof UClass)) return;
        UClass cls = (UClass)resolved;
        if (JavaScriptInterfaceDetector.isJavaScriptAnnotated(context, cls)) {
            return;
        }
        Location location = context.getLocation(node.getFunctionNameElement());
        String message2 = String.format("None of the methods in the added interface (%1$s) have been annotated with `@android.webkit.JavascriptInterface`; they will not be visible in API 17", cls.getName());
        context.report(ISSUE, node, location, message2);
    }

    private static boolean isCallOnWebView(UastAndroidContext context, UCallExpression call) {
        UFunction resolved = call.resolve(context);
        return UastUtils.getContainingClassOrEmpty(resolved).matchesFqName(WEB_VIEW_CLS);
    }

    private static boolean isJavaScriptAnnotated(UastAndroidContext context, UClass clz) {
        while (clz != null) {
            for (UAnnotation annotation : clz.getAnnotations()) {
                if (!JAVASCRIPT_INTERFACE_CLS.equals(annotation.getFqName())) continue;
                return true;
            }
            for (UFunction method : clz.getFunctions()) {
                for (UAnnotation annotation : method.getAnnotations()) {
                    if (!JAVASCRIPT_INTERFACE_CLS.equals(annotation.getFqName())) continue;
                    return true;
                }
            }
            clz = clz.getSuperClass(context);
        }
        return false;
    }

    private static class ConcreteTypeVisitor
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;
        private final UCallExpression mTargetCall;
        private boolean mFoundCall;
        private Map<UElement, UClass> mTypes = Maps.newIdentityHashMap();
        private Map<UVariable, UClass> mVariableTypes = Maps.newHashMap();

        public ConcreteTypeVisitor(UastAndroidContext context, UCallExpression call) {
            this.mContext = context;
            this.mTargetCall = call;
        }

        public UClass getType() {
            UDeclaration resolved;
            UExpression first = this.mTargetCall.getValueArguments().get(0);
            UClass resolvedClass = this.mTypes.get(first);
            if (resolvedClass == null && first instanceof UResolvable && (resolved = ((UResolvable)((Object)first)).resolve(this.mContext)) instanceof UVariable && (resolvedClass = this.mVariableTypes.get(resolved)) == null) {
                return ((UVariable)resolved).getType().resolve(this.mContext);
            }
            return resolvedClass;
        }

        @Override
        public boolean visitElement(@NotNull UElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/JavaScriptInterfaceDetector$ConcreteTypeVisitor", "visitElement"));
            }
            return this.mFoundCall || super.visitElement(node);
        }

        @Override
        public void afterVisitCallExpression(@NotNull UCallExpression node) {
            UFunction resolved;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/JavaScriptInterfaceDetector$ConcreteTypeVisitor", "afterVisitCallExpression"));
            }
            if (node.getKind() == UastCallKind.FUNCTION_CALL && node == this.mTargetCall) {
                this.mFoundCall = true;
            } else if (node.getKind() == UastCallKind.CONSTRUCTOR_CALL && (resolved = node.resolve(this.mContext)) != null) {
                this.mTypes.put(node, UastUtils.getContainingClass(resolved));
            }
        }

        @Override
        public void afterVisitSimpleReferenceExpression(@NotNull USimpleReferenceExpression node) {
            UClass resolvedClass;
            UDeclaration resolved;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/JavaScriptInterfaceDetector$ConcreteTypeVisitor", "afterVisitSimpleReferenceExpression"));
            }
            if (this.mTypes.get(node) == null && (resolved = node.resolve(this.mContext)) instanceof UVariable && (resolvedClass = this.mVariableTypes.get(resolved)) != null) {
                this.mTypes.put(node, resolvedClass);
            }
        }

        @Override
        public void afterVisitBinaryExpression(@NotNull UBinaryExpression node) {
            UExpression rhs;
            UClass resolvedClass;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/JavaScriptInterfaceDetector$ConcreteTypeVisitor", "afterVisitBinaryExpression"));
            }
            if (node.getOperator() == UastBinaryOperator.ASSIGN && (resolvedClass = this.mTypes.get(rhs = node.getRightOperand())) != null) {
                UDeclaration variable2;
                UExpression lhs = node.getLeftOperand();
                this.mTypes.put(lhs, resolvedClass);
                if (lhs instanceof UResolvable && (variable2 = ((UResolvable)((Object)lhs)).resolve(this.mContext)) instanceof UVariable) {
                    this.mVariableTypes.put((UVariable)variable2, resolvedClass);
                }
            }
        }

        @Override
        public void afterVisitIfExpression(@NotNull UIfExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/JavaScriptInterfaceDetector$ConcreteTypeVisitor", "afterVisitIfExpression"));
            }
            if (node.isTernary()) {
                UClass resolvedClass = this.mTypes.get(node.getThenBranch());
                if (resolvedClass == null) {
                    resolvedClass = this.mTypes.get(node.getElseBranch());
                }
                if (resolvedClass != null) {
                    this.mTypes.put(node, resolvedClass);
                }
            }
        }

        @Override
        public void afterVisitVariable(@NotNull UVariable node) {
            UClass resolvedClass;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/JavaScriptInterfaceDetector$ConcreteTypeVisitor", "afterVisitVariable"));
            }
            UExpression initializer2 = node.getInitializer();
            if (initializer2 != null && (resolvedClass = this.mTypes.get(initializer2)) != null) {
                this.mTypes.put(node, resolvedClass);
                this.mVariableTypes.put(node, resolvedClass);
            }
        }

        @Override
        public void afterVisitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/JavaScriptInterfaceDetector$ConcreteTypeVisitor", "afterVisitBinaryExpressionWithType"));
            }
            UClass resolvedClass = this.mTypes.get(node);
            if (resolvedClass != null) {
                this.mTypes.put(node, resolvedClass);
            }
        }
    }
}

