/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class SdCardDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("SdCardPath", "Hardcoded reference to `/sdcard`", "Your code should not reference the `/sdcard` path directly; instead use `Environment.getExternalStorageDirectory().getPath()`.\n\nSimilarly, do not reference the `/data/data/` path directly; it can vary in multi-user scenarios. Instead, use `Context.getFilesDir().getPath()`.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(SdCardDetector.class, Scope.SOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/topics/data/data-storage.html#filesExternal");

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public UastVisitor createUastVisitor(UastAndroidContext context) {
        return new StringChecker(context);
    }

    private static class StringChecker
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;

        public StringChecker(UastAndroidContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitLiteralExpression(@NotNull ULiteralExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/SdCardDetector$StringChecker", "visitLiteralExpression"));
            }
            if (!node.isString()) {
                return false;
            }
            String s = (String)node.getValue();
            if (s == null || s.isEmpty()) {
                return false;
            }
            char c = s.charAt(0);
            if (c != '/' && c != 'f') {
                return false;
            }
            if (s.startsWith("/sdcard") || s.startsWith("/mnt/sdcard/") || s.startsWith("/system/media/sdcard") || s.startsWith("file://sdcard/") || s.startsWith("file:///sdcard/")) {
                String message2 = "Do not hardcode \"/sdcard/\"; use `Environment.getExternalStorageDirectory().getPath()` instead";
                Location location = this.mContext.getLocation(node);
                this.mContext.report(ISSUE, node, location, message2);
            } else if (s.startsWith("/data/data/") || s.startsWith("/data/user/")) {
                String message3 = "Do not hardcode \"`/data/`\"; use `Context.getFilesDir().getPath()` instead";
                Location location = this.mContext.getLocation(node);
                this.mContext.report(ISSUE, node, location, message3);
            }
            return false;
        }
    }
}

