/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceType;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.ResourceXmlDetector;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.android.tools.klint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnusedResourceDetector
extends ResourceXmlDetector
implements UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(UnusedResourceDetector.class, EnumSet.of(Scope.MANIFEST, Scope.ALL_RESOURCE_FILES, Scope.ALL_SOURCE_FILES, Scope.TEST_SOURCES));
    public static final Issue ISSUE = Issue.create("UnusedResources", "Unused resources", "Unused resources make applications larger and slow down builds.", Category.PERFORMANCE, 3, Severity.WARNING, IMPLEMENTATION);
    public static final Issue ISSUE_IDS = Issue.create("UnusedIds", "Unused id", "This resource id definition appears not to be needed since it is not referenced from anywhere. Having id definitions, even if unused, is not necessarily a bad idea since they make working on layouts and menus easier, so there is not a strong reason to delete these.", Category.PERFORMANCE, 1, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    private Set<String> mDeclarations;
    private Set<String> mReferences;
    private Map<String, Location> mUnused;
    private static final String ANALYTICS_FILE = "analytics.xml";

    @Override
    public void run(@NonNull Context context) {
        assert (false);
    }

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    public void beforeCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.mDeclarations = new HashSet<String>(300);
            this.mReferences = new HashSet<String>(300);
        }
    }

    @Override
    public void beforeCheckFile(@NonNull Context context) {
        File file = context.file;
        boolean isXmlFile = LintUtils.isXmlFile(file);
        if (isXmlFile || LintUtils.isBitmapFile(file)) {
            String parentName;
            String fileName = file.getName();
            int dash = (parentName = file.getParentFile().getName()).indexOf(45);
            String typeName = parentName.substring(0, dash == -1 ? parentName.length() : dash);
            ResourceType type2 = ResourceType.getEnum((String)typeName);
            if (type2 != null && LintUtils.isFileBasedResourceType(type2)) {
                String baseName = fileName.substring(0, fileName.length() - ".xml".length());
                String resource = "R." + typeName + '.' + baseName;
                if (context.getPhase() == 1) {
                    this.mDeclarations.add(resource);
                } else {
                    assert (context.getPhase() == 2);
                    if (this.mUnused.containsKey(resource)) {
                        if (isXmlFile && context instanceof XmlContext) {
                            XmlContext xmlContext = (XmlContext)context;
                            if (xmlContext.document != null && xmlContext.document.getDocumentElement() != null) {
                                Element root = xmlContext.document.getDocumentElement();
                                if (xmlContext.getDriver().isSuppressed(xmlContext, ISSUE, root)) {
                                    this.mUnused.remove(resource);
                                    return;
                                }
                            }
                        }
                        if (!context.getProject().getReportIssues()) {
                            this.mUnused.remove(resource);
                            return;
                        }
                        this.recordLocation(resource, Location.create(file));
                    }
                }
            }
        }
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.mDeclarations.removeAll(this.mReferences);
            Set<String> unused = this.mDeclarations;
            this.mReferences = null;
            this.mDeclarations = null;
            ArrayList<String> styles = new ArrayList<String>();
            for (String string : unused) {
                if (!string.startsWith("R.style") && !string.startsWith("R.attr")) continue;
                styles.add(string);
            }
            unused.removeAll(styles);
            if (!unused.isEmpty() && !context.isEnabled(ISSUE_IDS)) {
                ArrayList ids = new ArrayList();
                for (String resource : unused) {
                    if (!resource.startsWith("R.id.")) continue;
                    ids.add(resource);
                }
                unused.removeAll(ids);
            }
            if (!unused.isEmpty() && !context.getDriver().hasParserErrors()) {
                this.mUnused = new HashMap<String, Location>(unused.size());
                for (String string : unused) {
                    this.mUnused.put(string, null);
                }
                context.requestRepeat(this, Scope.ALL_RESOURCES_SCOPE);
            }
        } else {
            assert (context.getPhase() == 2);
            if (!this.mUnused.isEmpty()) {
                for (Map.Entry<String, Location> entry : this.mUnused.entrySet()) {
                    int secondDot;
                    Object typeName;
                    ResourceType type2;
                    String resource = entry.getKey();
                    Location location = entry.getValue();
                    if (location != null || (type2 = ResourceType.getEnum((String)(typeName = resource.substring(2, secondDot = resource.indexOf(46, 2))))) == null || !LintUtils.isFileBasedResourceType(type2)) continue;
                    String name2 = resource.substring(secondDot + 1);
                    ArrayList folders = Lists.newArrayList();
                    List<File> resourceFolders = context.getProject().getResourceFolders();
                    for (File res : resourceFolders) {
                        File[] f = res.listFiles();
                        if (f == null) continue;
                        folders.addAll(Arrays.asList(f));
                    }
                    if (folders == null) continue;
                    Collections.sort(folders, new Comparator<File>(){

                        @Override
                        public int compare(File file1, File file2) {
                            return file1.getName().compareTo(file2.getName());
                        }
                    });
                    for (File folder : folders) {
                        Object[] files;
                        if (!folder.getName().startsWith((String)typeName) || (files = folder.listFiles()) == null) continue;
                        Arrays.sort(files);
                        for (Object file : files) {
                            String fileName = ((File)file).getName();
                            if (!fileName.startsWith(name2) || !fileName.startsWith(".", name2.length())) continue;
                            this.recordLocation(resource, Location.create((File)file));
                        }
                    }
                }
                ArrayList<String> sorted = new ArrayList<String>(this.mUnused.keySet());
                Collections.sort(sorted);
                Boolean skippedLibraries = null;
                for (String string : sorted) {
                    Location location = this.mUnused.get(string);
                    if (location != null) {
                        location = Location.reverse(location);
                    }
                    if (location == null) {
                        if (skippedLibraries == null) {
                            skippedLibraries = false;
                            for (Project project : context.getDriver().getProjects()) {
                                if (project.getReportIssues()) continue;
                                skippedLibraries = true;
                                break;
                            }
                        }
                        if (skippedLibraries.booleanValue()) continue;
                    }
                    String message2 = String.format("The resource `%1$s` appears to be unused", string);
                    Issue issue = UnusedResourceDetector.getIssue(string);
                    context.report(issue, location, message2);
                }
            }
        }
    }

    private static Issue getIssue(String resource) {
        return resource.startsWith("R.id.") ? ISSUE_IDS : ISSUE;
    }

    private void recordLocation(String resource, Location location) {
        Location oldLocation = this.mUnused.get(resource);
        if (oldLocation != null) {
            location.setSecondary(oldLocation);
        }
        this.mUnused.put(resource, location);
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("style", "resources", "array", "string-array", "integer-array", "plurals");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        block15: {
            block14: {
                if (!"resources".equals(element.getTagName())) break block14;
                for (Element item : LintUtils.getChildren(element)) {
                    Attr nameAttribute = item.getAttributeNode("name");
                    if (nameAttribute == null) continue;
                    String name2 = SdkUtils.getResourceFieldName((String)nameAttribute.getValue());
                    String type2 = item.getTagName();
                    if (type2.equals("item")) {
                        type2 = item.getAttribute("type");
                        if (type2 == null || type2.isEmpty()) {
                            type2 = "id";
                        }
                    } else if (type2.equals("declare-styleable")) {
                        type2 = "styleable";
                    } else if (type2.contains("array")) {
                        type2 = "array";
                    }
                    String resource = "R." + type2 + '.' + name2;
                    if (context.getPhase() == 1) {
                        this.mDeclarations.add(resource);
                        this.checkChildRefs(item);
                        continue;
                    }
                    assert (context.getPhase() == 2);
                    if (!this.mUnused.containsKey(resource)) continue;
                    if (context.getDriver().isSuppressed(context, UnusedResourceDetector.getIssue(resource), item)) {
                        this.mUnused.remove(resource);
                        continue;
                    }
                    if (!context.getProject().getReportIssues()) {
                        this.mUnused.remove(resource);
                        continue;
                    }
                    if (UnusedResourceDetector.isAnalyticsFile(context)) {
                        this.mUnused.remove(resource);
                        continue;
                    }
                    this.recordLocation(resource, context.getLocation(nameAttribute));
                }
                break block15;
            }
            if (this.mReferences == null) break block15;
            assert ("style".equals(element.getTagName()) || "array".equals(element.getTagName()) || "plurals".equals(element.getTagName()) || "integer-array".equals(element.getTagName()) || "string-array".equals(element.getTagName()));
            for (Element item : LintUtils.getChildren(element)) {
                this.checkChildRefs(item);
            }
        }
    }

    public static boolean isAnalyticsFile(Context context) {
        File file = context.file;
        return file.getPath().endsWith(ANALYTICS_FILE) && file.getName().equals(ANALYTICS_FILE);
    }

    private void checkChildRefs(Element item) {
        NodeList childNodes = item.getChildNodes();
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int index = text.indexOf("?attr/");
            if (index != -1) {
                String name2 = text.substring(index + "?attr/".length()).trim();
                this.mReferences.add("R.attr." + name2);
                continue;
            }
            index = text.indexOf(64);
            if (index == -1 || text.indexOf(47, index) == -1 || text.startsWith("@android:", index)) continue;
            String token = text.substring(index + 1).trim().replace('/', '.');
            String r = "R." + token;
            this.mReferences.add(r);
        }
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String value2 = attribute.getValue();
        if (value2.startsWith("@+") && !value2.startsWith("@+android")) {
            String resource = "R." + value2.substring(2).replace('/', '.');
            if (context.getPhase() == 1) {
                this.mDeclarations.add(resource);
            } else if (this.mUnused.containsKey(resource)) {
                if (context.getDriver().isSuppressed(context, UnusedResourceDetector.getIssue(resource), attribute)) {
                    this.mUnused.remove(resource);
                    return;
                }
                if (!context.getProject().getReportIssues()) {
                    this.mUnused.remove(resource);
                    return;
                }
                this.recordLocation(resource, context.getLocation(attribute));
                return;
            }
        } else if (this.mReferences != null) {
            if (value2.startsWith("@") && !value2.startsWith("@android:")) {
                String r = "R." + value2.substring(1).replace('/', '.');
                this.mReferences.add(r);
            } else if (value2.startsWith("?attr/")) {
                this.mReferences.add("R.attr." + value2.substring("?attr/".length()));
            }
        }
        if (attribute.getNamespaceURI() != null && !"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI()) && this.mReferences != null) {
            this.mReferences.add("R.attr." + attribute.getLocalName());
        }
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    @Override
    public boolean appliesToResourceRefs() {
        return true;
    }

    @Override
    public void visitResourceReference(UastAndroidContext context, UElement element, String type2, String name2, boolean isFramework) {
        if (this.mReferences != null && !isFramework) {
            String reference = "R." + type2 + '.' + name2;
            this.mReferences.add(reference);
        }
    }

    @Override
    public AbstractUastVisitor createUastVisitor(@NonNull UastAndroidContext context) {
        if (this.mReferences != null) {
            return new UnusedResourceVisitor();
        }
        return null;
    }

    private class UnusedResourceVisitor
    extends AbstractUastVisitor {
        private UnusedResourceVisitor() {
        }

        @Override
        public boolean visitClass(@NotNull UClass node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/UnusedResourceDetector$UnusedResourceVisitor", "visitClass"));
            }
            String description = node.getName();
            if (description.equals("R")) {
                for (UDeclaration uDeclaration : node.getNestedClasses()) {
                    for (UVariable variable2 : node.getProperties()) {
                        String resource = "R." + uDeclaration.getName() + '.' + variable2.getName();
                        UnusedResourceDetector.this.mDeclarations.add(resource);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

