/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ViewHolderDetector
extends Detector
implements UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(ViewHolderDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("ViewHolder", "View Holder Candidates", "When implementing a view Adapter, you should avoid unconditionally inflating a new layout; if an available item is passed in for reuse, you should try to use that one instead. This helps make for example ListView scrolling much smoother.", Category.PERFORMANCE, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/training/improving-layouts/smooth-scrolling.html#ViewHolder");
    private static final String GET_VIEW = "getView";
    static final String INFLATE = "inflate";

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Override
    public UastVisitor createUastVisitor(UastAndroidContext context) {
        return new ViewAdapterVisitor(context);
    }

    private static class InflationVisitor
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;
        private List<UElement> mNodes;
        private boolean mHaveConditional;

        public InflationVisitor(UastAndroidContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            String methodName;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ViewHolderDetector$InflationVisitor", "visitCallExpression"));
            }
            UElement parent = node.getParent();
            if (parent instanceof UQualifiedExpression && ViewHolderDetector.INFLATE.equals(methodName = node.getFunctionName()) && node.getValueArgumentCount() >= 1) {
                boolean insideIf = false;
                for (UElement p = parent.getParent(); p != null; p = p.getParent()) {
                    if (p instanceof UIfExpression || p instanceof USwitchExpression) {
                        insideIf = true;
                        this.mHaveConditional = true;
                        break;
                    }
                    if (p == node) break;
                }
                if (!insideIf) {
                    if (this.mNodes == null) {
                        this.mNodes = Lists.newArrayList();
                    }
                    this.mNodes.add(node);
                }
            }
            return false;
        }

        public void finish() {
            if (!this.mHaveConditional && this.mNodes != null) {
                for (UElement node : this.mNodes) {
                    String message2 = "Unconditional layout inflation from view adapter: Should use View Holder pattern (use recycled view passed into this method as the second parameter) for smoother scrolling";
                    this.mContext.report(ISSUE, node, this.mContext.getLocation(node), message2);
                }
            }
        }
    }

    private static class ViewAdapterVisitor
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;

        public ViewAdapterVisitor(UastAndroidContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitFunction(@NotNull UFunction node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ViewHolderDetector$ViewAdapterVisitor", "visitFunction"));
            }
            if (ViewAdapterVisitor.isViewAdapterMethod(node)) {
                InflationVisitor visitor2 = new InflationVisitor(this.mContext);
                node.accept(visitor2);
                visitor2.finish();
            }
            return false;
        }

        private static boolean isViewAdapterMethod(UFunction node) {
            List<UVariable> parameters2;
            if (ViewHolderDetector.GET_VIEW.equals(node.getName()) && (parameters2 = node.getValueParameters()).size() == 3) {
                return parameters2.get(2).getType().matchesFqName("android.view.ViewGroup");
            }
            return false;
        }
    }
}

