/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.client.api;

import com.android.annotations.NonNull;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.detector.api.ClassContext;
import com.android.tools.klint.detector.api.Detector;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Beta
class AsmVisitor {
    private static final int TYPE_COUNT = 16;
    private final Map<String, List<Detector.ClassScanner>> mMethodNameToChecks = new HashMap<String, List<Detector.ClassScanner>>();
    private final Map<String, List<Detector.ClassScanner>> mMethodOwnerToChecks = new HashMap<String, List<Detector.ClassScanner>>();
    private final List<Detector> mFullClassChecks = new ArrayList<Detector>();
    private final List<? extends Detector> mAllDetectors;
    private List<Detector.ClassScanner>[] mNodeTypeDetectors;

    AsmVisitor(@NonNull LintClient client, @NonNull List<? extends Detector> classDetectors) {
        this.mAllDetectors = classDetectors;
        for (Detector detector : classDetectors) {
            int[] nArray;
            List<String> owners;
            Detector.ClassScanner scanner = (Detector.ClassScanner)((Object)detector);
            boolean checkFullClass = true;
            List<String> names = scanner.getApplicableCallNames();
            if (names != null) {
                checkFullClass = false;
                for (String string : names) {
                    List<Detector.ClassScanner> list = this.mMethodNameToChecks.get(string);
                    if (list == null) {
                        list = new ArrayList<Detector.ClassScanner>();
                        this.mMethodNameToChecks.put(string, list);
                    }
                    list.add(scanner);
                }
            }
            if ((owners = scanner.getApplicableCallOwners()) != null) {
                checkFullClass = false;
                for (String element2 : owners) {
                    List<Detector.ClassScanner> list = this.mMethodOwnerToChecks.get(element2);
                    if (list == null) {
                        list = new ArrayList<Detector.ClassScanner>();
                        this.mMethodOwnerToChecks.put(element2, list);
                    }
                    list.add(scanner);
                }
            }
            if ((nArray = scanner.getApplicableAsmNodeTypes()) != null) {
                checkFullClass = false;
                for (int type2 : nArray) {
                    List<Detector.ClassScanner> checks;
                    if (type2 < 0 || type2 >= 16) {
                        client.log(null, "Out of range node type %1$d from detector %2$s", type2, scanner);
                        continue;
                    }
                    if (this.mNodeTypeDetectors == null) {
                        this.mNodeTypeDetectors = new List[16];
                    }
                    if ((checks = this.mNodeTypeDetectors[type2]) == null) {
                        this.mNodeTypeDetectors[type2] = checks = new ArrayList<Detector.ClassScanner>();
                    }
                    checks.add(scanner);
                }
            }
            if (!checkFullClass) continue;
            this.mFullClassChecks.add(detector);
        }
    }

    void runClassDetectors(ClassContext context) {
        ClassNode classNode = context.getClassNode();
        for (Detector detector : this.mAllDetectors) {
            detector.beforeCheckFile(context);
        }
        for (Detector detector : this.mFullClassChecks) {
            Detector.ClassScanner scanner = (Detector.ClassScanner)((Object)detector);
            scanner.checkClass(context, classNode);
            detector.afterCheckFile(context);
        }
        if (!this.mMethodNameToChecks.isEmpty() || !this.mMethodOwnerToChecks.isEmpty() || this.mNodeTypeDetectors != null && this.mNodeTypeDetectors.length > 0) {
            List methodList = classNode.methods;
            for (Object m : methodList) {
                MethodNode method = (MethodNode)m;
                InsnList nodes = method.instructions;
                int n = nodes.size();
                for (int i = 0; i < n; ++i) {
                    List<Detector.ClassScanner> scanners;
                    AbstractInsnNode instruction = nodes.get(i);
                    int type2 = instruction.getType();
                    if (type2 == 5) {
                        String name2;
                        MethodInsnNode call = (MethodInsnNode)instruction;
                        String owner = call.owner;
                        List<Detector.ClassScanner> scanners2 = this.mMethodOwnerToChecks.get(owner);
                        if (scanners2 != null) {
                            for (Detector.ClassScanner scanner : scanners2) {
                                scanner.checkCall(context, classNode, method, call);
                            }
                        }
                        if ((scanners2 = this.mMethodNameToChecks.get(name2 = call.name)) != null) {
                            for (Detector.ClassScanner scanner : scanners2) {
                                scanner.checkCall(context, classNode, method, call);
                            }
                        }
                    }
                    if (this.mNodeTypeDetectors == null || type2 >= this.mNodeTypeDetectors.length || (scanners = this.mNodeTypeDetectors[type2]) == null) continue;
                    for (Detector.ClassScanner scanner : scanners) {
                        scanner.checkInstruction(context, classNode, method, instruction);
                    }
                }
            }
        }
        for (Detector detector : this.mAllDetectors) {
            detector.afterCheckFile(context);
        }
    }
}

