/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.detector.api;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TextFormat;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Beta
public final class Issue
implements Comparable<Issue> {
    private final String mId;
    private final String mBriefDescription;
    private final String mExplanation;
    private final Category mCategory;
    private final int mPriority;
    private final Severity mSeverity;
    private Object mMoreInfoUrls;
    private boolean mEnabledByDefault = true;
    private Implementation mImplementation;

    private Issue(@NonNull String id, @NonNull String shortDescription, @NonNull String explanation, @NonNull Category category, int priority, @NonNull Severity severity, @NonNull Implementation implementation) {
        assert (!shortDescription.isEmpty());
        assert (!explanation.isEmpty());
        this.mId = id;
        this.mBriefDescription = shortDescription;
        this.mExplanation = explanation;
        this.mCategory = category;
        this.mPriority = priority;
        this.mSeverity = severity;
        this.mImplementation = implementation;
    }

    @NonNull
    public static Issue create(@NonNull String id, @NonNull String briefDescription, @NonNull String explanation, @NonNull Category category, int priority, @NonNull Severity severity, @NonNull Implementation implementation) {
        return new Issue(id, briefDescription, explanation, category, priority, severity, implementation);
    }

    @Deprecated
    @NonNull
    public static Issue create(@NonNull String id, @NonNull String briefDescription, @NonNull String description, @NonNull String explanation, @NonNull Category category, int priority, @NonNull Severity severity, @NonNull Implementation implementation) {
        return new Issue(id, briefDescription, explanation, category, priority, severity, implementation);
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public String getBriefDescription(@NonNull TextFormat format) {
        return TextFormat.RAW.convertTo(this.mBriefDescription, format);
    }

    @NonNull
    public String getExplanation(@NonNull TextFormat format) {
        return TextFormat.RAW.convertTo(this.mExplanation, format);
    }

    @NonNull
    public Category getCategory() {
        return this.mCategory;
    }

    public int getPriority() {
        return this.mPriority;
    }

    @NonNull
    public Severity getDefaultSeverity() {
        return this.mSeverity;
    }

    @NonNull
    public List<String> getMoreInfo() {
        if (this.mMoreInfoUrls == null) {
            return Collections.emptyList();
        }
        if (this.mMoreInfoUrls instanceof String) {
            return Collections.singletonList((String)this.mMoreInfoUrls);
        }
        assert (this.mMoreInfoUrls instanceof List);
        return (List)this.mMoreInfoUrls;
    }

    @NonNull
    public Issue addMoreInfo(@NonNull String moreInfoUrl) {
        if (this.mMoreInfoUrls == null) {
            this.mMoreInfoUrls = moreInfoUrl;
        } else if (this.mMoreInfoUrls instanceof String) {
            String existing = (String)this.mMoreInfoUrls;
            ArrayList<String> list = new ArrayList<String>(2);
            list.add(existing);
            list.add(moreInfoUrl);
            this.mMoreInfoUrls = list;
        } else {
            assert (this.mMoreInfoUrls instanceof List);
            ((List)this.mMoreInfoUrls).add(moreInfoUrl);
        }
        return this;
    }

    public boolean isEnabledByDefault() {
        return this.mEnabledByDefault;
    }

    @NonNull
    public Implementation getImplementation() {
        return this.mImplementation;
    }

    public void setImplementation(@NonNull Implementation implementation) {
        this.mImplementation = implementation;
    }

    @Override
    public int compareTo(@NonNull Issue other) {
        return this.getId().compareTo(other.getId());
    }

    @NonNull
    public Issue setEnabledByDefault(boolean enabledByDefault) {
        this.mEnabledByDefault = enabledByDefault;
        return this;
    }

    public String toString() {
        return this.mId;
    }
}

