/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

class DomPsiConverter {
    private static final NodeList EMPTY = new NodeList(){

        @Override
        @NotNull
        public Node item(int i) {
            throw new IllegalArgumentException();
        }

        @Override
        public int getLength() {
            return 0;
        }
    };
    @Nullable
    private static final NamedNodeMap EMPTY_ATTRIBUTES = new NamedNodeMap(){

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        @Nullable
        public Node getNamedItem(String s) {
            return null;
        }

        @Override
        @Nullable
        public Node getNamedItemNS(String s, String s2) throws DOMException {
            return null;
        }

        @Override
        @NotNull
        public Node setNamedItem(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeNamedItem(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node item(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Node setNamedItemNS(Node node) throws DOMException {
            return null;
        }

        @Override
        @NotNull
        public Node removeNamedItemNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }
    };

    private DomPsiConverter() {
    }

    @Nullable
    public static Document convert(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "org/jetbrains/android/inspections/klint/DomPsiConverter", "convert"));
        }
        try {
            XmlDocument xmlDocument = xmlFile.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            return DomPsiConverter.convert(xmlDocument);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Exception e) {
            String path = xmlFile.getName();
            VirtualFile virtualFile = xmlFile.getVirtualFile();
            if (virtualFile != null) {
                path = virtualFile.getPath();
            }
            throw new RuntimeException("Could not convert file " + path, e);
        }
    }

    @Nullable
    private static Document convert(@NotNull XmlDocument document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/android/inspections/klint/DomPsiConverter", "convert"));
        }
        return new DomDocument(document);
    }

    @NotNull
    public static TextRange getTextRange(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/android/inspections/klint/DomPsiConverter", "getTextRange"));
        }
        assert (node instanceof DomNode);
        DomNode domNode = (DomNode)node;
        XmlElement element = domNode.myElement;
        if (node.getNodeType() == 1) {
            TextRange textRange = DomPsiConverter.getTextNameRange(node);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter", "getTextRange"));
            }
            return textRange;
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange getTextNameRange(@NotNull Node node) {
        XmlElement nameElement2;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/android/inspections/klint/DomPsiConverter", "getTextNameRange"));
        }
        assert (node instanceof DomNode);
        DomNode domNode = (DomNode)node;
        XmlElement element = domNode.myElement;
        if (node.getNodeType() == 1 && element instanceof XmlTag) {
            String tag = node.getNodeName();
            int index = element.getText().indexOf(tag);
            if (index != -1) {
                TextRange textRange = element.getTextRange();
                int start = textRange.getStartOffset() + index;
                TextRange textRange2 = new TextRange(start, start + tag.length());
                if (textRange2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter", "getTextNameRange"));
                }
                return textRange2;
            }
        } else if (node.getNodeType() == 2 && element instanceof XmlAttribute && (nameElement2 = ((XmlAttribute)element).getNameElement()) != null) {
            TextRange textRange = nameElement2.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter", "getTextNameRange"));
            }
            return textRange;
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter", "getTextNameRange"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange getTextValueRange(@NotNull Node node) {
        XmlAttributeValue valueElement;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/android/inspections/klint/DomPsiConverter", "getTextValueRange"));
        }
        assert (node instanceof DomNode);
        DomNode domNode = (DomNode)node;
        XmlElement element = domNode.myElement;
        TextRange textRange = element.getTextRange();
        if (node.getNodeType() == 2 && element instanceof XmlAttribute && (valueElement = ((XmlAttribute)element).getValueElement()) != null) {
            TextRange textRange2 = valueElement.getValueTextRange();
            if (textRange2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter", "getTextValueRange"));
            }
            return textRange2;
        }
        TextRange textRange3 = textRange;
        if (textRange3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter", "getTextValueRange"));
        }
        return textRange3;
    }

    private static class DomAttr
    extends DomNode
    implements Attr {
        @NotNull
        private final DomElement myOwner;
        @NotNull
        private final XmlAttribute myAttribute;

        private DomAttr(@NotNull Document document, @NotNull DomElement owner, @NotNull XmlAttribute attribute) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "<init>"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "<init>"));
            }
            if (attribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "<init>"));
            }
            super(document, null, (XmlElement)attribute);
            this.myOwner = owner;
            this.myAttribute = attribute;
        }

        @Override
        @NotNull
        public String getNodeName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getNodeName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getNodeValue() throws DOMException {
            String string = this.getValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getNodeValue"));
            }
            return string;
        }

        @Override
        public short getNodeType() {
            return 2;
        }

        @Override
        @NotNull
        public String getName() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                String string = (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return this.getName();
                    }
                });
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getName"));
                }
                return string;
            }
            String string = this.myAttribute.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getName"));
            }
            return string;
        }

        @Override
        public boolean getSpecified() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getValue() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                String string = (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return this.getValue();
                    }
                });
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getValue"));
                }
                return string;
            }
            String value2 = this.myAttribute.getValue();
            if (value2 == null) {
                value2 = "";
            }
            String string = value2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getValue"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getLocalName() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                String string = (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return this.getLocalName();
                    }
                });
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getLocalName"));
                }
                return string;
            }
            String string = this.myAttribute.getLocalName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getLocalName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getPrefix() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                String string = (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return this.getPrefix();
                    }
                });
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getPrefix"));
                }
                return string;
            }
            String string = this.myAttribute.getNamespacePrefix();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getPrefix"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getNamespaceURI() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                String string = (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return this.getNamespaceURI();
                    }
                });
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getNamespaceURI"));
                }
                return string;
            }
            String string = this.myAttribute.getNamespace();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getNamespaceURI"));
            }
            return string;
        }

        @Override
        public void setValue(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element getOwnerElement() {
            DomElement domElement = this.myOwner;
            if (domElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomAttr", "getOwnerElement"));
            }
            return domElement;
        }

        @Override
        @NotNull
        public TypeInfo getSchemaTypeInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isId() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomComment
    extends DomNode
    implements Comment {
        @NotNull
        private final XmlComment myComment;

        private DomComment(@NotNull Document owner, @NotNull DomNode parent, @NotNull XmlComment comment) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomComment", "<init>"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomComment", "<init>"));
            }
            if (comment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomComment", "<init>"));
            }
            super(owner, parent, (XmlElement)comment);
            this.myComment = comment;
        }

        @Override
        @Nullable
        public String getNodeName() {
            return null;
        }

        @Override
        @NotNull
        public String getNodeValue() throws DOMException {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                String string = (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return this.getNodeValue();
                    }
                });
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomComment", "getNodeValue"));
                }
                return string;
            }
            String string = this.myComment.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomComment", "getNodeValue"));
            }
            return string;
        }

        @Override
        public short getNodeType() {
            return 8;
        }

        @Override
        @NotNull
        public String getTextContent() throws DOMException {
            String string = this.getNodeValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomComment", "getTextContent"));
            }
            return string;
        }
    }

    private static class DomText
    extends DomNode
    implements Text {
        @NotNull
        private final XmlText myText;

        private DomText(@NotNull Document owner, @NotNull DomNode parent, @NotNull XmlText text) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomText", "<init>"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomText", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomText", "<init>"));
            }
            super(owner, parent, (XmlElement)text);
            this.myText = text;
        }

        @Override
        @Nullable
        public String getNodeName() {
            return null;
        }

        @Override
        @NotNull
        public String getNodeValue() throws DOMException {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                String string = (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return this.getNodeValue();
                    }
                });
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomText", "getNodeValue"));
                }
                return string;
            }
            String string = this.myText.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomText", "getNodeValue"));
            }
            return string;
        }

        @Override
        public short getNodeType() {
            return 3;
        }

        @Override
        @NotNull
        public Text splitText(int i) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isElementContentWhitespace() {
            String s = this.myText.getText();
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public String getWholeText() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Text replaceWholeText(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomElement
    extends DomNode
    implements Element {
        private final XmlTag myTag;
        @Nullable
        private NamedNodeMap myAttributes;

        private DomElement(@NotNull Document owner, @NotNull DomNode parent, @NotNull XmlTag tag) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "<init>"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "<init>"));
            }
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "<init>"));
            }
            super(owner, parent, (XmlElement)tag);
            this.myTag = tag;
        }

        @Override
        @NotNull
        public String getNodeName() {
            String string = this.getTagName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getNodeName"));
            }
            return string;
        }

        @Override
        @Nullable
        public String getNodeValue() throws DOMException {
            return null;
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        @NotNull
        public NamedNodeMap getAttributes() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                NamedNodeMap namedNodeMap = (NamedNodeMap)application.runReadAction((Computable)new Computable<NamedNodeMap>(){

                    public NamedNodeMap compute() {
                        return this.getAttributes();
                    }
                });
                if (namedNodeMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttributes"));
                }
                return namedNodeMap;
            }
            if (this.myAttributes == null) {
                XmlAttribute[] attributes = this.myTag.getAttributes();
                this.myAttributes = attributes.length == 0 ? EMPTY_ATTRIBUTES : new DomNamedNodeMap(this, attributes);
            }
            NamedNodeMap namedNodeMap = this.myAttributes;
            if (namedNodeMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttributes"));
            }
            return namedNodeMap;
        }

        @Override
        @NotNull
        public String getTagName() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                String string = (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return this.getTagName();
                    }
                });
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getTagName"));
                }
                return string;
            }
            String string = this.myTag.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getTagName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getAttribute(@NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttribute"));
            }
            Node node = this.getAttributes().getNamedItem(name2);
            if (node != null) {
                String string = node.getNodeValue();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttribute"));
                }
                return string;
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttribute"));
            }
            return "";
        }

        @Override
        @NotNull
        public String getAttributeNS(@NotNull String namespace, @NotNull String name2) throws DOMException {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttributeNS"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttributeNS"));
            }
            Node node = this.getAttributes().getNamedItemNS(namespace, name2);
            if (node != null) {
                String string = node.getNodeValue();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttributeNS"));
                }
                return string;
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttributeNS"));
            }
            return "";
        }

        @Override
        @Nullable
        public Attr getAttributeNodeNS(@NotNull String namespace, @NotNull String name2) throws DOMException {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttributeNodeNS"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttributeNodeNS"));
            }
            Node node = this.getAttributes().getNamedItemNS(namespace, name2);
            if (node != null) {
                return (Attr)node;
            }
            return null;
        }

        @Override
        @Nullable
        public Attr getAttributeNode(@NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getAttributeNode"));
            }
            Node node = this.getAttributes().getNamedItem(name2);
            if (node != null) {
                return (Attr)node;
            }
            return null;
        }

        @Override
        public boolean hasAttribute(@NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "hasAttribute"));
            }
            return this.getAttributes().getNamedItem(name2) != null;
        }

        @Override
        public boolean hasAttributeNS(@NotNull String namespace, @NotNull String name2) throws DOMException {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "hasAttributeNS"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "hasAttributeNS"));
            }
            return this.getAttributes().getNamedItemNS(namespace, name2) != null;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagName(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getElementsByTagName"));
            }
            NodeList childNodes = this.getChildNodes();
            if (childNodes == EMPTY) {
                NodeList nodeList = EMPTY;
                if (nodeList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getElementsByTagName"));
                }
                return nodeList;
            }
            DomNodeList matches = new DomNodeList();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = childNodes.item(i);
                if (!s.equals(node.getNodeName())) continue;
                matches.add((DomNode)node);
            }
            DomNodeList domNodeList = matches;
            if (domNodeList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomElement", "getElementsByTagName"));
            }
            return domNodeList;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagNameNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr setAttributeNode(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr removeAttributeNode(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttributeNS(String s, String s2, String s3) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAttributeNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAttribute(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr setAttributeNodeNS(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public TypeInfo getSchemaTypeInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttribute(String s, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttributeNS(String s, String s2, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttributeNode(Attr attr, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomDocument
    extends DomNode
    implements Document {
        @NotNull
        private final XmlDocument myPsiDocument;
        @Nullable
        private DomElement myRoot;

        private DomDocument(@NotNull XmlDocument document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomDocument", "<init>"));
            }
            super(null, null, (XmlElement)document);
            this.myPsiDocument = document;
        }

        @Override
        @Nullable
        public String getNodeName() {
            return null;
        }

        @Override
        @Nullable
        public String getNodeValue() throws DOMException {
            return null;
        }

        @Override
        public short getNodeType() {
            return 9;
        }

        @Override
        @NotNull
        public NodeList getChildNodes() {
            if (this.myChildren == null) {
                DomNodeList list = new DomNodeList();
                this.myChildren = list;
                DomNode documentElement = (DomNode)((Object)this.getDocumentElement());
                if (documentElement != null) {
                    list.add(documentElement);
                }
            }
            NodeList nodeList = this.myChildren;
            if (nodeList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomDocument", "getChildNodes"));
            }
            return nodeList;
        }

        @Override
        @NotNull
        public DocumentType getDoctype() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DOMImplementation getImplementation() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Element getDocumentElement() {
            if (this.myRoot == null) {
                XmlTag rootTag = this.myPsiDocument.getRootTag();
                if (rootTag == null) {
                    return null;
                }
                this.myRoot = new DomElement(this, this, rootTag);
            }
            return this.myRoot;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagName(String s) {
            Element root = this.getDocumentElement();
            if (root != null) {
                NodeList nodeList = root.getElementsByTagName(s);
                if (nodeList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomDocument", "getElementsByTagName"));
                }
                return nodeList;
            }
            NodeList nodeList = EMPTY;
            if (nodeList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomDocument", "getElementsByTagName"));
            }
            return nodeList;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagNameNS(String s, String s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element createElement(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DocumentFragment createDocumentFragment() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Text createTextNode(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Comment createComment(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public CDATASection createCDATASection(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ProcessingInstruction createProcessingInstruction(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr createAttribute(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public EntityReference createEntityReference(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node importNode(Node node, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element createElementNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr createAttributeNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element getElementById(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getInputEncoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getXmlEncoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getXmlStandalone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setXmlStandalone(boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getXmlVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setXmlVersion(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getStrictErrorChecking() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStrictErrorChecking(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getDocumentURI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDocumentURI(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node adoptNode(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DOMConfiguration getDomConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void normalizeDocument() {
        }

        @Override
        @NotNull
        public Node renameNode(Node node, String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class DomNode
    implements Node {
        @Nullable
        protected final Document myOwner;
        @Nullable
        protected final DomNode myParent;
        @NotNull
        protected final XmlElement myElement;
        @Nullable
        protected NodeList myChildren;
        @Nullable
        protected DomNode myNext;
        @Nullable
        protected DomNode myPrevious;

        protected DomNode(@Nullable Document owner, @Nullable DomNode parent, @NotNull XmlElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomNode", "<init>"));
            }
            this.myOwner = owner;
            this.myParent = parent;
            this.myElement = element;
        }

        @Override
        @Nullable
        public Node getParentNode() {
            return this.myParent;
        }

        @Override
        @NotNull
        public NodeList getChildNodes() {
            if (this.myChildren == null) {
                PsiElement[] children = this.myElement.getChildren();
                if (children.length > 0) {
                    DomNodeList list = new DomNodeList();
                    this.myChildren = list;
                    assert (this.myOwner != null);
                    for (PsiElement child : children) {
                        if (child instanceof XmlTag) {
                            list.add(new DomElement(this.myOwner, this, (XmlTag)child));
                            continue;
                        }
                        if (child instanceof XmlText) {
                            list.add(new DomText(this.myOwner, this, (XmlText)child));
                            continue;
                        }
                        if (!(child instanceof XmlComment)) continue;
                        list.add(new DomComment(this.myOwner, this, (XmlComment)child));
                    }
                } else {
                    this.myChildren = EMPTY;
                }
            }
            NodeList nodeList = this.myChildren;
            if (nodeList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomNode", "getChildNodes"));
            }
            return nodeList;
        }

        @Override
        @Nullable
        public Node getFirstChild() {
            NodeList childNodes = this.getChildNodes();
            if (childNodes.getLength() > 0) {
                return childNodes.item(0);
            }
            return null;
        }

        @Override
        @Nullable
        public Node getLastChild() {
            NodeList childNodes = this.getChildNodes();
            if (childNodes.getLength() > 0) {
                return childNodes.item(0);
            }
            return null;
        }

        @Override
        @Nullable
        public Node getPreviousSibling() {
            return this.myPrevious;
        }

        @Override
        @Nullable
        public Node getNextSibling() {
            return this.myNext;
        }

        @Override
        @Nullable
        public NamedNodeMap getAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Document getOwnerDocument() {
            return this.myOwner;
        }

        @Override
        public void setNodeValue(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node insertBefore(Node node, Node node2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node replaceChild(Node node, Node node2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeChild(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node appendChild(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasChildNodes() {
            return this.getChildNodes().getLength() > 0;
        }

        @Override
        @NotNull
        public Node cloneNode(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void normalize() {
        }

        @Override
        public boolean isSupported(String s, String s2) {
            return false;
        }

        @Override
        @NotNull
        public String getNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getPrefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrefix(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getLocalName() {
            return null;
        }

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        @Nullable
        public String getBaseURI() {
            return null;
        }

        @Override
        public short compareDocumentPosition(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.myElement.getText();
        }

        @Override
        public void setTextContent(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSameNode(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String lookupPrefix(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefaultNamespace(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String lookupNamespaceURI(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEqualNode(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object getFeature(String s, String s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object setUserData(String s, Object o, UserDataHandler userDataHandler) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object getUserData(String s) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String getData() throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void setData(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public int getLength() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String substringData(int i, int i2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void appendData(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void insertData(int i, String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void deleteData(int i, int i2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void replaceData(int i, int i2, String s) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomNamedNodeMap
    implements NamedNodeMap {
        @NotNull
        protected final Map<String, DomNode> myMap;
        @NotNull
        protected final Map<String, Map<String, DomNode>> myNsMap;
        @NotNull
        protected final List<DomNode> mItems;

        private DomNamedNodeMap(@NotNull DomElement element, @NotNull XmlAttribute[] attributes) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomNamedNodeMap", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomNamedNodeMap", "<init>"));
            }
            int count = attributes.length;
            int namespaceCount = 0;
            for (XmlAttribute attribute : attributes) {
                if (attribute.getNamespace().isEmpty()) continue;
                ++namespaceCount;
            }
            this.myMap = new HashMap(count - namespaceCount);
            this.myNsMap = new HashMap(namespaceCount);
            this.mItems = new ArrayList<DomNode>(count);
            assert (element.myOwner != null);
            for (XmlAttribute attribute : attributes) {
                DomAttr attr = new DomAttr(element.myOwner, element, attribute);
                this.mItems.add(attr);
                String namespace = attribute.getNamespace();
                if (!namespace.isEmpty()) {
                    HashMap map2 = this.myNsMap.get(namespace);
                    if (map2 == null) {
                        map2 = new HashMap();
                        this.myNsMap.put(namespace, (Map<String, DomNode>)map2);
                    }
                    map2.put(attribute.getLocalName(), attr);
                    continue;
                }
                this.myMap.put(attribute.getName(), attr);
            }
        }

        @Override
        public Node item(int i) {
            return this.mItems.get(i);
        }

        @Override
        public int getLength() {
            return this.mItems.size();
        }

        @Override
        public Node getNamedItem(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomNamedNodeMap", "getNamedItem"));
            }
            return this.myMap.get(s);
        }

        @Override
        @Nullable
        public Node getNamedItemNS(@NotNull String namespace, @NotNull String name2) throws DOMException {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomNamedNodeMap", "getNamedItemNS"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomNamedNodeMap", "getNamedItemNS"));
            }
            Map<String, DomNode> map2 = this.myNsMap.get(namespace);
            if (map2 != null) {
                return map2.get(name2);
            }
            return null;
        }

        @Override
        @NotNull
        public Node setNamedItem(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeNamedItem(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node setNamedItemNS(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeNamedItemNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomNodeList
    implements NodeList {
        protected final List<DomNode> myChildren = new ArrayList<DomNode>();

        private DomNodeList() {
        }

        @Override
        @NotNull
        public Node item(int i) {
            Node node = this.myChildren.get(i);
            if (node == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomNodeList", "item"));
            }
            return node;
        }

        @Override
        public int getLength() {
            return this.myChildren.size();
        }

        void add(@NotNull DomNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/android/inspections/klint/DomPsiConverter$DomNodeList", "add"));
            }
            int size = this.myChildren.size();
            if (size > 0) {
                DomNode last;
                node.myPrevious = last = this.myChildren.get(size - 1);
                last.myNext = node;
            }
            this.myChildren.add(node);
        }
    }
}

