/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.SourceProvider;
import com.android.tools.klint.client.api.LintRequest;
import com.android.tools.klint.detector.api.ClassContext;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.DefaultPosition;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.intellij.facet.Facet;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.klint.AndroidModelFacade;
import org.jetbrains.android.inspections.klint.IntellijLintRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.java.JavaUClass;

public class IntellijLintUtils {
    private static final ProjectSystemId GRADLE_ID = new ProjectSystemId("GRADLE");

    private IntellijLintUtils() {
    }

    @NonNull
    public static Location getLocation(@NonNull File file, @NonNull PsiElement element) {
        PsiClass clz;
        PsiIdentifier nameIdentifier;
        assert (element.getContainingFile().getVirtualFile() == null || FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)element.getContainingFile().getVirtualFile()), (File)file));
        if (element instanceof PsiClass && (nameIdentifier = (clz = (PsiClass)element).getNameIdentifier()) != null) {
            element = nameIdentifier;
        }
        TextRange textRange = element.getTextRange();
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create(file, start, end);
    }

    @Nullable
    public static PsiFile getPsiFile(@NonNull Context context) {
        VirtualFile file = VfsUtil.findFileByIoFile((File)context.file, (boolean)false);
        if (file == null) {
            return null;
        }
        LintRequest request = context.getDriver().getRequest();
        Project project = ((IntellijLintRequest)request).getProject();
        if (project.isDisposed()) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(file);
    }

    public static boolean isSuppressed(@NonNull UElement element, @NonNull UFile file, @NonNull Issue issue) {
        return false;
    }

    @Nullable
    public static String getInternalName(@NonNull PsiClass psiClass) {
        PsiClass parent;
        if (psiClass instanceof PsiAnonymousClass && (parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class)) != null) {
            String internalName2 = IntellijLintUtils.getInternalName(parent);
            if (internalName2 == null) {
                return null;
            }
            return internalName2 + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
        }
        String sig = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (sig == null) {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName != null) {
                return ClassContext.getInternalName(qualifiedName);
            }
            return null;
        }
        if (sig.indexOf(46) != -1) {
            sig = ClassContext.getInternalName(sig);
        }
        return sig;
    }

    public static String getInternalName(@NotNull UClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/android/inspections/klint/IntellijLintUtils", "getInternalName"));
        }
        if (clazz instanceof JavaUClass) {
            return IntellijLintUtils.getInternalName(((JavaUClass)clazz).getPsi());
        }
        return null;
    }

    public static AndroidModelFacade getModelFacade(AndroidFacet facet) {
        return new AndroidModelFacade(facet);
    }

    public static boolean isGradleModule(Facet<?> facet) {
        Module module = facet.getModule();
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GRADLE_ID, (Module)module);
    }

    @NotNull
    public static List<File> getResourceDirectories(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/inspections/klint/IntellijLintUtils", "getResourceDirectories"));
        }
        if (IntellijLintUtils.isGradleModule(facet)) {
            SourceProvider buildTypeSourceProvider;
            ArrayList<File> resDirectories = new ArrayList<File>();
            resDirectories.addAll(facet.getMainSourceProvider().getResDirectories());
            List<SourceProvider> flavorSourceProviders = IntellijLintUtils.getModelFacade(facet).getFlavorSourceProviders();
            if (flavorSourceProviders != null) {
                for (SourceProvider provider : flavorSourceProviders) {
                    for (File file : provider.getResDirectories()) {
                        if (!file.isDirectory()) continue;
                        resDirectories.add(file);
                    }
                }
            }
            if ((buildTypeSourceProvider = IntellijLintUtils.getModelFacade(facet).getBuildTypeSourceProvider()) != null) {
                for (File file : buildTypeSourceProvider.getResDirectories()) {
                    if (!file.isDirectory()) continue;
                    resDirectories.add(file);
                }
            }
            ArrayList<File> arrayList = resDirectories;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/IntellijLintUtils", "getResourceDirectories"));
            }
            return arrayList;
        }
        ArrayList<File> arrayList = new ArrayList<File>(facet.getMainSourceProvider().getResDirectories());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/IntellijLintUtils", "getResourceDirectories"));
        }
        return arrayList;
    }
}

