/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.CommittedChangeListForRevision;
import java.util.Collection;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;

public class HgCommittedChangeList
extends CommittedChangeListForRevision {
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private String myBranch;

    public HgCommittedChangeList(@NotNull HgVcs vcs, @NotNull HgRevisionNumber revision, @NotNull String branch, String comment, String committerName, Date commitDate, Collection<Change> changes) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "<init>"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "<init>"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "<init>"));
        }
        super(revision.asString() + ": " + comment, comment, committerName, commitDate, changes, (VcsRevisionNumber)revision);
        this.myVcs = vcs;
        this.myBranch = StringUtil.isEmpty((String)branch) ? "default" : branch;
    }

    @NotNull
    public HgRevisionNumber getRevisionNumber() {
        HgRevisionNumber hgRevisionNumber = (HgRevisionNumber)super.getRevisionNumber();
        if (hgRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "getRevisionNumber"));
        }
        return hgRevisionNumber;
    }

    @NotNull
    public String getBranch() {
        String string = this.myBranch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "getBranch"));
        }
        return string;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public String toString() {
        return this.getComment();
    }
}

