/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.impl.JpsArtifactReferenceImpl;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;

public class JpsArtifactImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsArtifactImpl<P>>
implements JpsArtifact {
    private static final JpsElementChildRole<JpsCompositePackagingElement> ROOT_ELEMENT_CHILD_ROLE = JpsElementChildRoleBase.create((String)"root element");
    private final JpsArtifactType<P> myArtifactType;
    private String myOutputPath;
    private boolean myBuildOnMake;

    public JpsArtifactImpl(@NotNull String name, @NotNull JpsCompositePackagingElement rootElement, @NotNull JpsArtifactType<P> type, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl", "<init>"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl", "<init>"));
        }
        super(name);
        this.myArtifactType = type;
        this.myContainer.setChild(ROOT_ELEMENT_CHILD_ROLE, (JpsElement)rootElement);
        this.myContainer.setChild(type.getPropertiesRole(), properties);
    }

    private JpsArtifactImpl(JpsArtifactImpl<P> original) {
        super(original);
        this.myArtifactType = original.myArtifactType;
        this.myOutputPath = original.myOutputPath;
    }

    @NotNull
    public JpsArtifactImpl<P> createCopy() {
        JpsArtifactImpl<P> jpsArtifactImpl = new JpsArtifactImpl<P>(this);
        if (jpsArtifactImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl", "createCopy"));
        }
        return jpsArtifactImpl;
    }

    public String getOutputPath() {
        return this.myOutputPath;
    }

    public void setOutputPath(@Nullable String outputPath) {
        if (!Comparing.equal((String)this.myOutputPath, (String)outputPath)) {
            this.myOutputPath = outputPath;
            this.fireElementChanged();
        }
    }

    @Nullable
    public String getOutputFilePath() {
        if (StringUtil.isEmpty((String)this.myOutputPath)) {
            return null;
        }
        JpsCompositePackagingElement root = this.getRootElement();
        return root instanceof JpsArchivePackagingElement ? this.myOutputPath + "/" + ((JpsArchivePackagingElement)root).getArchiveName() : this.myOutputPath;
    }

    @NotNull
    public JpsArtifactType<P> getArtifactType() {
        JpsArtifactType<P> jpsArtifactType = this.myArtifactType;
        if (jpsArtifactType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl", "getArtifactType"));
        }
        return jpsArtifactType;
    }

    @NotNull
    public JpsArtifactReferenceImpl createReference() {
        JpsArtifactReferenceImpl jpsArtifactReferenceImpl = new JpsArtifactReferenceImpl(this.getName());
        if (jpsArtifactReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl", "createReference"));
        }
        return jpsArtifactReferenceImpl;
    }

    @NotNull
    public JpsCompositePackagingElement getRootElement() {
        JpsCompositePackagingElement jpsCompositePackagingElement = (JpsCompositePackagingElement)this.myContainer.getChild(ROOT_ELEMENT_CHILD_ROLE);
        if (jpsCompositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl", "getRootElement"));
        }
        return jpsCompositePackagingElement;
    }

    public void setRootElement(@NotNull JpsCompositePackagingElement rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl", "setRootElement"));
        }
        this.myContainer.setChild(ROOT_ELEMENT_CHILD_ROLE, (JpsElement)rootElement);
    }

    public P getProperties() {
        return (P)this.myContainer.getChild(this.myArtifactType.getPropertiesRole());
    }

    public boolean isBuildOnMake() {
        return this.myBuildOnMake;
    }

    public void setBuildOnMake(boolean buildOnMake) {
        if (this.myBuildOnMake != buildOnMake) {
            this.myBuildOnMake = buildOnMake;
            this.fireElementChanged();
        }
    }
}

