/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.MethodMessage;
import com.oracle.truffle.api.interop.java.TruffleList;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class ToJavaNode
extends Node {
    private static final Object[] EMPTY = new Object[0];
    @Node.Child
    private Node isExecutable = Message.IS_EXECUTABLE.createNode();

    ToJavaNode() {
    }

    public Object convert(VirtualFrame frame, Object value, Class<?> type) {
        Object convertedValue;
        if (value == null) {
            return null;
        }
        if (ToJavaNode.isPrimitiveType(value.getClass())) {
            convertedValue = ToJavaNode.toPrimitive(value, type);
            assert (convertedValue != null);
        } else if (value instanceof JavaObject && type.isInstance(((JavaObject)value).obj)) {
            convertedValue = ((JavaObject)value).obj;
        } else if (value instanceof TruffleObject && ToJavaNode.isJavaFunctionInterface(type) && this.isExecutable(frame, (TruffleObject)value)) {
            convertedValue = ToJavaNode.asJavaFunction(type, (TruffleObject)value);
        } else if (value instanceof TruffleObject) {
            convertedValue = ToJavaNode.asJavaObject(type, null, (TruffleObject)value);
        } else {
            assert (type.isAssignableFrom(value.getClass()));
            convertedValue = value;
        }
        return convertedValue;
    }

    private boolean isExecutable(VirtualFrame frame, TruffleObject object) {
        return ForeignAccess.sendIsExecutable(this.isExecutable, frame, object);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isJavaFunctionInterface(Class<?> type) {
        if (!type.isInterface()) {
            return false;
        }
        for (Annotation annotation : type.getAnnotations()) {
            if (!annotation.toString().equals("@java.lang.FunctionalInterface()")) continue;
            return true;
        }
        return type.getMethods().length == 1;
    }

    @CompilerDirectives.TruffleBoundary
    private static <T> T asJavaObject(Class<T> clazz, Type type, TruffleObject foreignObject) {
        List<Object> obj;
        if (clazz.isInstance(foreignObject)) {
            obj = foreignObject;
        } else {
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException();
            }
            if (foreignObject == null) {
                return null;
            }
            if (clazz == List.class && Boolean.TRUE.equals(ToJavaNode.binaryMessage(Message.HAS_SIZE, foreignObject, new Object[0]))) {
                ParameterizedType parametrizedType;
                Type[] arr;
                Class elementType = Object.class;
                if (type instanceof ParameterizedType && (arr = (parametrizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1 && arr[0] instanceof Class) {
                    elementType = (Class)arr[0];
                }
                obj = TruffleList.create(elementType, foreignObject);
            } else {
                obj = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new TruffleHandler(foreignObject));
            }
        }
        return clazz.cast(obj);
    }

    @CompilerDirectives.TruffleBoundary
    private static <T> T asJavaFunction(Class<T> functionalType, TruffleObject function) {
        Object obj = Proxy.newProxyInstance(functionalType.getClassLoader(), new Class[]{functionalType}, (InvocationHandler)new SingleHandler(function));
        return functionalType.cast(obj);
    }

    private static Message findMessage(MethodMessage mm) {
        CompilerAsserts.neverPartOfCompilation();
        if (mm == null) {
            return null;
        }
        return Message.valueOf(mm.message());
    }

    private static Object toJava(Object ret, Method method) {
        CompilerAsserts.neverPartOfCompilation();
        Class<?> retType = method.getReturnType();
        Object primitiveRet = ToJavaNode.toPrimitive(ret, retType);
        if (primitiveRet != null) {
            return primitiveRet;
        }
        if (ret instanceof TruffleObject && Boolean.TRUE.equals(ToJavaNode.binaryMessage(Message.IS_NULL, ret, new Object[0]))) {
            return null;
        }
        if (retType.isInstance(ret)) {
            return ret;
        }
        if (ret instanceof TruffleObject) {
            TruffleObject truffleObject = (TruffleObject)ret;
            if (retType.isInterface()) {
                return ToJavaNode.asJavaObject(retType, method.getGenericReturnType(), truffleObject);
            }
        }
        return ret;
    }

    private static boolean isPrimitiveType(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Character.TYPE || clazz == Character.class || CharSequence.class.isAssignableFrom(clazz);
    }

    static boolean isPrimitive(Object attr) {
        return ToJavaNode.toPrimitive(attr, null) != null;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object toPrimitive(Object value, Class<?> requestedType) {
        Object attr;
        if (value instanceof TruffleObject) {
            if (!Boolean.TRUE.equals(ToJavaNode.binaryMessage(Message.IS_BOXED, value, new Object[0]))) {
                return null;
            }
            try {
                attr = ToJavaNode.message(Message.UNBOX, value, new Object[0]);
            }
            catch (InteropException e) {
                throw new IllegalStateException();
            }
        } else {
            attr = value;
        }
        if (attr instanceof Number) {
            if (requestedType == null) {
                return attr;
            }
            Number n = (Number)attr;
            if (requestedType == Byte.TYPE || requestedType == Byte.class) {
                return n.byteValue();
            }
            if (requestedType == Short.TYPE || requestedType == Short.class) {
                return n.shortValue();
            }
            if (requestedType == Integer.TYPE || requestedType == Integer.class) {
                return n.intValue();
            }
            if (requestedType == Long.TYPE || requestedType == Long.class) {
                return n.longValue();
            }
            if (requestedType == Float.TYPE || requestedType == Float.class) {
                return Float.valueOf(n.floatValue());
            }
            if (requestedType == Double.TYPE || requestedType == Double.class) {
                return n.doubleValue();
            }
            if (requestedType == Character.TYPE || requestedType == Character.class) {
                return Character.valueOf((char)n.intValue());
            }
            return n;
        }
        if (attr instanceof CharSequence) {
            if ((requestedType == Character.TYPE || requestedType == Character.class) && ((String)attr).length() == 1) {
                return Character.valueOf(((String)attr).charAt(0));
            }
            return String.valueOf(attr);
        }
        if (attr instanceof Character) {
            return attr;
        }
        if (attr instanceof Boolean) {
            return attr;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    static Object message(Message m, Object receiver, Object ... arr) throws InteropException {
        Node n = m.createNode();
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new TemporaryRoot(TruffleLanguage.class, n, (TruffleObject)receiver));
        return callTarget.call(arr);
    }

    private static Object binaryMessage(Message m, Object receiver, Object ... arr) {
        try {
            return ToJavaNode.message(m, receiver, arr);
        }
        catch (InteropException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class TemporaryRoot
    extends RootNode {
        @Node.Child
        private Node foreignAccess;
        private final TruffleObject function;

        TemporaryRoot(Class<? extends TruffleLanguage> lang, Node foreignAccess, TruffleObject function) {
            super(lang, null, null);
            this.foreignAccess = foreignAccess;
            this.function = function;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return ForeignAccess.execute(this.foreignAccess, frame, this.function, frame.getArguments());
        }
    }

    private static final class TruffleHandler
    implements InvocationHandler {
        private final TruffleObject obj;

        TruffleHandler(TruffleObject obj) {
            this.obj = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            CompilerAsserts.neverPartOfCompilation();
            Object[] args = arguments == null ? EMPTY : arguments;
            for (int i = 0; i < args.length; ++i) {
                InvocationHandler h;
                if (args[i] == null || !Proxy.isProxyClass(args[i].getClass()) || !((h = Proxy.getInvocationHandler(args[i])) instanceof TruffleHandler)) continue;
                args[i] = ((TruffleHandler)h).obj;
            }
            if (Object.class == method.getDeclaringClass()) {
                return method.invoke((Object)this.obj, args);
            }
            String name = method.getName();
            Message message = ToJavaNode.findMessage(method.getAnnotation(MethodMessage.class));
            if (message == Message.WRITE) {
                if (args.length != 1) {
                    throw new IllegalStateException("Method needs to have a single argument to handle WRITE message " + method);
                }
                ToJavaNode.message(Message.WRITE, this.obj, name, args[0]);
                return null;
            }
            if (message == Message.HAS_SIZE || message == Message.IS_BOXED || message == Message.IS_EXECUTABLE || message == Message.IS_NULL || message == Message.GET_SIZE) {
                return ToJavaNode.message(message, this.obj, new Object[0]);
            }
            if (message == Message.READ) {
                Object val = ToJavaNode.message(Message.READ, this.obj, name);
                return ToJavaNode.toJava(val, method);
            }
            if (message == Message.UNBOX) {
                Object val = ToJavaNode.message(Message.UNBOX, this.obj, new Object[0]);
                return ToJavaNode.toJava(val, method);
            }
            if (Message.createExecute(0).equals(message)) {
                ArrayList<Object> copy = new ArrayList<Object>(args.length);
                copy.addAll(Arrays.asList(args));
                message = Message.createExecute(copy.size());
                Object val = ToJavaNode.message(message, this.obj, copy.toArray());
                return ToJavaNode.toJava(val, method);
            }
            if (Message.createInvoke(0).equals(message)) {
                ArrayList<Object> copy = new ArrayList<Object>(args.length + 1);
                copy.add(name);
                copy.addAll(Arrays.asList(args));
                message = Message.createInvoke(args.length);
                Object val = ToJavaNode.message(message, this.obj, copy.toArray());
                return ToJavaNode.toJava(val, method);
            }
            if (Message.createNew(0).equals(message)) {
                message = Message.createNew(args.length);
                Object val = ToJavaNode.message(message, this.obj, args);
                return ToJavaNode.toJava(val, method);
            }
            if (message == null) {
                Object ret;
                try {
                    ArrayList<Object> callArgs = new ArrayList<Object>(args.length);
                    callArgs.add(name);
                    callArgs.addAll(Arrays.asList(args));
                    ret = ToJavaNode.message(Message.createInvoke(args.length), this.obj, callArgs.toArray());
                }
                catch (InteropException ex) {
                    Object val = ToJavaNode.message(Message.READ, this.obj, name);
                    Object primitiveVal = ToJavaNode.toPrimitive(val, method.getReturnType());
                    if (primitiveVal != null) {
                        return primitiveVal;
                    }
                    TruffleObject attr = (TruffleObject)val;
                    if (Boolean.FALSE.equals(ToJavaNode.message(Message.IS_EXECUTABLE, attr, new Object[0]))) {
                        if (args.length == 0) {
                            return ToJavaNode.toJava(attr, method);
                        }
                        throw new IllegalArgumentException(attr + " cannot be invoked with " + args.length + " parameters");
                    }
                    ArrayList<Object> callArgs = new ArrayList<Object>(args.length);
                    callArgs.addAll(Arrays.asList(args));
                    ret = ToJavaNode.message(Message.createExecute(callArgs.size()), attr, callArgs.toArray());
                }
                return ToJavaNode.toJava(ret, method);
            }
            throw new IllegalArgumentException("Unknown message: " + message);
        }
    }

    private static final class SingleHandler
    implements InvocationHandler {
        private final TruffleObject symbol;
        private CallTarget target;

        SingleHandler(TruffleObject obj) {
            this.symbol = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            Object[] args;
            CompilerAsserts.neverPartOfCompilation();
            Object[] objectArray = args = arguments == null ? EMPTY : arguments;
            if (this.target == null) {
                Node executeMain = Message.createExecute(args.length).createNode();
                TemporaryRoot symbolNode = new TemporaryRoot(TruffleLanguage.class, executeMain, this.symbol);
                this.target = Truffle.getRuntime().createCallTarget(symbolNode);
            }
            Object ret = this.target.call(args);
            return ToJavaNode.toJava(ret, method);
        }
    }
}

