/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.encoding.EncodingOperations;
import org.jruby.truffle.core.exception.ExceptionOperations;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.CoreStrings;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.util.StringUtils;

public class CoreExceptions {
    private final RubyContext context;

    public CoreExceptions(RubyContext context) {
        this.context = context;
    }

    public DynamicObject argumentErrorOneHashRequired(Node currentNode) {
        return this.argumentError(this.coreStrings().ONE_HASH_REQUIRED.getRope(), currentNode, null);
    }

    public DynamicObject argumentError(String message, Node currentNode) {
        return this.argumentError(message, currentNode, null);
    }

    public DynamicObject argumentErrorProcWithoutBlock(Node currentNode) {
        return this.argumentError(this.coreStrings().PROC_WITHOUT_BLOCK.getRope(), currentNode, null);
    }

    public DynamicObject argumentErrorTooFewArguments(Node currentNode) {
        return this.argumentError(this.coreStrings().TOO_FEW_ARGUMENTS.getRope(), currentNode, null);
    }

    public DynamicObject argumentErrorTimeItervalPositive(Node currentNode) {
        return this.argumentError(this.coreStrings().TIME_INTERVAL_MUST_BE_POS.getRope(), currentNode, null);
    }

    public DynamicObject argumentErrorXOutsideOfString(Node currentNode) {
        return this.argumentError(this.coreStrings().X_OUTSIDE_OF_STRING.getRope(), currentNode, null);
    }

    public DynamicObject argumentErrorCantCompressNegativeNumbers(Node currentNode) {
        return this.argumentError(this.coreStrings().CANT_COMPRESS_NEGATIVE.getRope(), currentNode, null);
    }

    public DynamicObject argumentErrorOutOfRange(Node currentNode) {
        return this.argumentError(this.coreStrings().OUT_OF_RANGE.getRope(), currentNode, null);
    }

    public DynamicObject argumentErrorNegativeArraySize(Node currentNode) {
        return this.argumentError(this.coreStrings().NEGATIVE_ARRAY_SIZE.getRope(), currentNode, null);
    }

    public DynamicObject argumentErrorCharacterRequired(Node currentNode) {
        return this.argumentError("%c requires a character", currentNode);
    }

    public DynamicObject argumentErrorCantOmitPrecision(Node currentNode) {
        return this.argumentError("can't omit precision for a Float.", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject argumentErrorUnknownKeyword(Object name, Node currentNode) {
        return this.argumentError("unknown keyword: " + name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject argumentErrorInvalidRadix(int radix, Node currentNode) {
        return this.argumentError(StringUtils.format("invalid radix %d", radix), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject argumentErrorMissingKeyword(String name, Node currentNode) {
        return this.argumentError(StringUtils.format("missing keyword: %s", name), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject argumentError(int passed, int required, Node currentNode) {
        return this.argumentError(StringUtils.format("wrong number of arguments (%d for %d)", passed, required), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject argumentError(int passed, int required, int optional, Node currentNode) {
        return this.argumentError(StringUtils.format("wrong number of arguments (%d for %d..%d)", passed, required, required + optional), currentNode);
    }

    public DynamicObject argumentErrorEmptyVarargs(Node currentNode) {
        return this.argumentError(this.coreStrings().WRONG_ARGS_ZERO_PLUS_ONE.getRope(), currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject argumentErrorWrongArgumentType(Object object, String expectedType, Node currentNode) {
        String badClassName = Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(object)).getName();
        return this.argumentError(StringUtils.format("wrong argument type %s (expected %s)", badClassName, expectedType), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject argumentErrorInvalidValue(Object object, String expectedType, Node currentNode) {
        String badClassName = Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(object)).getName();
        return this.argumentError(StringUtils.format("invalid value for %s(): %s", badClassName, expectedType), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject argumentErrorNoReceiver(Node currentNode) {
        return this.argumentError("no receiver is available", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject argumentError(String message, Node currentNode, Throwable javaThrowable) {
        return this.argumentError(StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE), currentNode, javaThrowable);
    }

    public DynamicObject argumentError(Rope message, Node currentNode, Throwable javaThrowable) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getArgumentErrorClass(), StringOperations.createString(this.context, message), this.context.getCallStack().getBacktrace(currentNode, javaThrowable));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject frozenError(Object object, Node currentNode) {
        String className = Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(object)).getName();
        return this.runtimeError(StringUtils.format("can't modify frozen %s", className), currentNode);
    }

    public DynamicObject runtimeErrorNotConstant(Node currentNode) {
        return this.runtimeError("Truffle::Graal.assert_constant can only be called lexically", currentNode);
    }

    public DynamicObject runtimeErrorCompiled(Node currentNode) {
        return this.runtimeError("Truffle::Graal.assert_not_compiled can only be called lexically", currentNode);
    }

    public DynamicObject runtimeErrorCoverageNotEnabled(Node currentNode) {
        return this.runtimeError("coverage measurement is not enabled", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject runtimeError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getRuntimeErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject systemStackErrorStackLevelTooDeep(Node currentNode, Throwable javaThrowable) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getSystemStackErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope("stack level too deep", (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode, javaThrowable));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject mathDomainErrorAcos(Node currentNode) {
        return this.mathDomainError("acos", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject mathDomainErrorAcosh(Node currentNode) {
        return this.mathDomainError("acosh", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject mathDomainErrorAsin(Node currentNode) {
        return this.mathDomainError("asin", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject mathDomainErrorAtanh(Node currentNode) {
        return this.mathDomainError("atanh", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject mathDomainErrorGamma(Node currentNode) {
        return this.mathDomainError("gamma", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject mathDomainErrorLog2(Node currentNode) {
        return this.mathDomainError("log2", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject mathDomainErrorLog10(Node currentNode) {
        return this.mathDomainError("log10", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject mathDomainErrorLog(Node currentNode) {
        return this.mathDomainError("log", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject mathDomainError(String method, Node currentNode) {
        return ExceptionOperations.createSystemCallError(this.context.getCoreLibrary().getErrnoClass(Errno.EDOM), StringOperations.createString(this.context, StringOperations.encodeRope(StringUtils.format("Numerical argument is out of domain - \"%s\"", method), (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode), Errno.EDOM.intValue());
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject errnoError(int errno, Node currentNode) {
        Errno errnoObj = Errno.valueOf((long)errno);
        if (errnoObj == null) {
            return this.systemCallError(StringUtils.format("Unknown Error (%s)", errno), errno, currentNode);
        }
        return ExceptionOperations.createSystemCallError(this.context.getCoreLibrary().getErrnoClass(errnoObj), StringOperations.createString(this.context, StringOperations.encodeRope(errnoObj.description(), (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode), errno);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject errnoError(int errno, String message, Node currentNode) {
        Errno errnoObj = Errno.valueOf((long)errno);
        if (errnoObj == null) {
            return this.systemCallError(StringUtils.format("Unknown Error (%s) - %s", errno, message), errno, currentNode);
        }
        DynamicObject errnoClass = this.context.getCoreLibrary().getErrnoClass(errnoObj);
        if (errnoClass == null) {
            errnoClass = this.context.getCoreLibrary().getSystemCallErrorClass();
            message = "Unknown error: " + errno;
        }
        DynamicObject errorMessage = StringOperations.createString(this.context, StringOperations.encodeRope(StringUtils.format("%s%s", errnoObj.description(), message), (Encoding)UTF8Encoding.INSTANCE));
        return ExceptionOperations.createSystemCallError(errnoClass, errorMessage, this.context.getCallStack().getBacktrace(currentNode), errno);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject indexError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getIndexErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject indexTooSmallError(String type, int index, int length, Node currentNode) {
        return this.indexError(StringUtils.format("index %d too small for %s; minimum: -%d", index, type, length), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject negativeLengthError(int length, Node currentNode) {
        return this.indexError(StringUtils.format("negative length (%d)", length), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject localJumpError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getLocalJumpErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    public DynamicObject noBlockGiven(Node currentNode) {
        return this.localJumpError("no block given", currentNode);
    }

    public DynamicObject breakFromProcClosure(Node currentNode) {
        return this.localJumpError("break from proc-closure", currentNode);
    }

    public DynamicObject unexpectedReturn(Node currentNode) {
        return this.localJumpError("unexpected return", currentNode);
    }

    public DynamicObject noBlockToYieldTo(Node currentNode) {
        return this.localJumpError("no block given (yield)", currentNode);
    }

    public DynamicObject typeErrorCantCreateInstanceOfSingletonClass(Node currentNode) {
        return this.typeError("can't create instance of singleton class", currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject superclassMismatch(String name, Node currentNode) {
        return this.typeError("superclass mismatch for class " + name, currentNode);
    }

    public DynamicObject typeError(String message, Node currentNode) {
        return this.typeError(message, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorAllocatorUndefinedFor(DynamicObject rubyClass, Node currentNode) {
        String className = Layouts.MODULE.getFields(rubyClass).getName();
        return this.typeError(StringUtils.format("allocator undefined for %s", className), currentNode);
    }

    public DynamicObject typeErrorCantDefineSingleton(Node currentNode) {
        return this.typeError("can't define singleton", currentNode);
    }

    public DynamicObject typeErrorCantBeCastedToBigDecimal(Node currentNode) {
        return this.typeError("could not be casted to BigDecimal", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorMustHaveWriteMethod(Object object, Node currentNode) {
        return this.typeError(StringUtils.format("$stdout must have write method, %s given", Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(object)).getName()), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorCantConvertTo(Object from, String toClass, String methodUsed, Object result, Node currentNode) {
        String fromClass = Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(from)).getName();
        return this.typeError(StringUtils.format("can't convert %s to %s (%s#%s gives %s)", fromClass, toClass, fromClass, methodUsed, this.context.getCoreLibrary().getLogicalClass(result).toString()), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorCantConvertInto(Object from, String toClass, Node currentNode) {
        return this.typeError(StringUtils.format("can't convert %s into %s", Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(from)).getName(), toClass), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorIsNotA(Object value, String expectedType, Node currentNode) {
        return this.typeErrorIsNotA(value.toString(), expectedType, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorIsNotA(String value, String expectedType, Node currentNode) {
        return this.typeError(StringUtils.format("%s is not a %s", value, expectedType), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorIsNotAClassModule(Object value, Node currentNode) {
        return this.typeError(StringUtils.format("%s is not a class/module", value), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorNoImplicitConversion(Object from, String to, Node currentNode) {
        return this.typeError(StringUtils.format("no implicit conversion of %s into %s", Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(from)).getName(), to), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorMustBe(String variable, String type, Node currentNode) {
        return this.typeError(StringUtils.format("value of %s must be %s", variable, type), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorBadCoercion(Object from, String to, String coercionMethod, Object coercedTo, Node currentNode) {
        String badClassName = Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(from)).getName();
        return this.typeError(StringUtils.format("can't convert %s to %s (%s#%s gives %s)", badClassName, to, badClassName, coercionMethod, Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(coercedTo)).getName()), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorCantDump(Object object, Node currentNode) {
        String logicalClass = Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(object)).getName();
        return this.typeError(StringUtils.format("can't dump %s", logicalClass), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeErrorWrongArgumentType(Object object, String expectedType, Node currentNode) {
        String badClassName = Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(object)).getName();
        return this.typeError(StringUtils.format("wrong argument type %s (expected %s)", badClassName, expectedType), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject typeError(String message, Node currentNode, Throwable javaThrowable) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getTypeErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode, javaThrowable));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorConstantNotDefined(DynamicObject module, String name, Node currentNode) {
        return this.nameError(StringUtils.format("constant %s::%s not defined", Layouts.MODULE.getFields(module).getName(), name), null, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorUninitializedConstant(DynamicObject module, String name, Node currentNode) {
        assert (RubyGuards.isRubyModule(module));
        String message = module == this.context.getCoreLibrary().getObjectClass() ? StringUtils.format("uninitialized constant %s", name) : StringUtils.format("uninitialized constant %s::%s", Layouts.MODULE.getFields(module).getName(), name);
        return this.nameError(message, module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorUninitializedClassVariable(DynamicObject module, String name, Node currentNode) {
        assert (RubyGuards.isRubyModule(module));
        return this.nameError(StringUtils.format("uninitialized class variable %s in %s", name, Layouts.MODULE.getFields(module).getName()), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorPrivateConstant(DynamicObject module, String name, Node currentNode) {
        return this.nameError(StringUtils.format("private constant %s::%s referenced", Layouts.MODULE.getFields(module).getName(), name), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorInstanceNameNotAllowable(String name, Object receiver, Node currentNode) {
        return this.nameError(StringUtils.format("`%s' is not allowable as an instance variable name", name), receiver, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorInstanceVariableNotDefined(String name, Object receiver, Node currentNode) {
        return this.nameError(StringUtils.format("instance variable %s not defined", name), receiver, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorReadOnly(String name, Node currentNode) {
        return this.nameError(StringUtils.format("%s is a read-only variable", name), null, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorUndefinedLocalVariableOrMethod(String name, Object receiver, Node currentNode) {
        String className = Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(receiver)).getName();
        return this.nameError(StringUtils.format("undefined local variable or method `%s' for %s", name, className), receiver, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorUndefinedMethod(String name, DynamicObject module, Node currentNode) {
        assert (RubyGuards.isRubyModule(module));
        return this.nameError(StringUtils.format("undefined method `%s' for %s", name, Layouts.MODULE.getFields(module).getName()), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorMethodNotDefinedIn(DynamicObject module, String name, Node currentNode) {
        return this.nameError(StringUtils.format("method `%s' not defined in %s", name, Layouts.MODULE.getFields(module).getName()), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorPrivateMethod(String name, DynamicObject module, Node currentNode) {
        return this.nameError(StringUtils.format("method `%s' for %s is private", name, Layouts.MODULE.getFields(module).getName()), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorLocalVariableNotDefined(String name, DynamicObject binding, Node currentNode) {
        assert (RubyGuards.isRubyBinding(binding));
        return this.nameError(StringUtils.format("local variable `%s' not defined for %s", name, binding.toString()), binding, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorClassVariableNotDefined(String name, DynamicObject module, Node currentNode) {
        assert (RubyGuards.isRubyModule(module));
        return this.nameError(StringUtils.format("class variable `%s' not defined for %s", name, Layouts.MODULE.getFields(module).getName()), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameErrorImportNotFound(String name, Node currentNode) {
        return this.nameError(StringUtils.format("import '%s' not found", name), null, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject nameError(String message, Object receiver, String name, Node currentNode) {
        DynamicObject nameString = StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE));
        return Layouts.NAME_ERROR.createNameError(this.context.getCoreLibrary().getNameErrorFactory(), nameString, this.context.getCallStack().getBacktrace(currentNode), receiver, this.context.getSymbolTable().getSymbol(name));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject noMethodError(String message, Object receiver, String name, Object[] args, Node currentNode) {
        DynamicObject messageString = StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE));
        DynamicObject argsArray = ArrayHelpers.createArray(this.context, args, args.length);
        return Layouts.NO_METHOD_ERROR.createNoMethodError(this.context.getCoreLibrary().getNoMethodErrorFactory(), messageString, this.context.getCallStack().getBacktrace(currentNode), receiver, this.context.getSymbolTable().getSymbol(name), argsArray);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject noSuperMethodOutsideMethodError(Node currentNode) {
        DynamicObject messageString = StringOperations.createString(this.context, StringOperations.encodeRope("super called outside of method", (Encoding)UTF8Encoding.INSTANCE));
        DynamicObject noMethodError = Layouts.NAME_ERROR.createNameError(this.context.getCoreLibrary().getNoMethodErrorFactory(), messageString, this.context.getCallStack().getBacktrace(currentNode), null, this.context.getSymbolTable().getSymbol("<unknown>"));
        return noMethodError;
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject noSuperMethodError(String name, Object self, Object[] args, Node currentNode) {
        return this.noMethodError(StringUtils.format("super: no superclass method `%s'", name), self, name, args, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject noMethodErrorOnReceiver(String name, Object receiver, Object[] args, Node currentNode) {
        DynamicObject logicalClass = this.context.getCoreLibrary().getLogicalClass(receiver);
        String moduleName = Layouts.MODULE.getFields(logicalClass).getName();
        boolean hasInspect = ModuleOperations.lookupMethod(logicalClass, "inspect", Visibility.PUBLIC) != null;
        DynamicObject stringRepresentation = hasInspect ? this.context.send(receiver, "inspect", null, new Object[0]) : this.context.getCoreLibrary().getNilObject();
        return this.noMethodError(StringUtils.format("undefined method `%s' for %s:%s", name, stringRepresentation, moduleName), receiver, name, args, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject privateMethodError(String name, Object self, Object[] args, Node currentNode) {
        String className = Layouts.MODULE.getFields(this.context.getCoreLibrary().getLogicalClass(self)).getName();
        return this.noMethodError(StringUtils.format("private method `%s' called for %s", name, className), self, name, args, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject loadError(String message, String path, Node currentNode) {
        DynamicObject messageString = StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE));
        DynamicObject loadError = ExceptionOperations.createRubyException(this.context.getCoreLibrary().getLoadErrorClass(), messageString, this.context.getCallStack().getBacktrace(currentNode));
        loadError.define("@path", StringOperations.createString(this.context, StringOperations.encodeRope(path, (Encoding)UTF8Encoding.INSTANCE)), 0);
        return loadError;
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject loadErrorCannotLoad(String name, Node currentNode) {
        return this.loadError(StringUtils.format("cannot load such file -- %s", name), name, currentNode);
    }

    public DynamicObject zeroDivisionError(Node currentNode) {
        return this.zeroDivisionError(currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject zeroDivisionError(Node currentNode, ArithmeticException exception) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getZeroDivisionErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope("divided by 0", (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode, exception));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject notImplementedError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getNotImplementedErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(StringUtils.format("Method %s not implemented", message), (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject syntaxErrorInvalidRetry(Node currentNode) {
        return this.syntaxError("Invalid retry", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject syntaxError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getSyntaxErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject floatDomainError(String value, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getFloatDomainErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(value, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    public DynamicObject floatDomainErrorResultsToNaN(Node currentNode) {
        return this.floatDomainError("Computation results to 'NaN'(Not a Number)", currentNode);
    }

    public DynamicObject floatDomainErrorResultsToInfinity(Node currentNode) {
        return this.floatDomainError("Computation results to 'Infinity'", currentNode);
    }

    public DynamicObject floatDomainErrorResultsToNegInfinity(Node currentNode) {
        return this.floatDomainError("Computation results to '-Infinity'", currentNode);
    }

    public DynamicObject floatDomainErrorSqrtNegative(Node currentNode) {
        return this.floatDomainError("(VpSqrt) SQRT(negative value)", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject ioError(String fileName, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getIOErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(StringUtils.format("Error reading file -  %s", fileName), (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject rangeError(int code, DynamicObject encoding, Node currentNode) {
        assert (RubyGuards.isRubyEncoding(encoding));
        return this.rangeError(StringUtils.format("invalid codepoint %x in %s", code, EncodingOperations.getEncoding(encoding)), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject rangeError(long code, DynamicObject encoding, Node currentNode) {
        assert (RubyGuards.isRubyEncoding(encoding));
        return this.rangeError(StringUtils.format("invalid codepoint %x in %s", code, EncodingOperations.getEncoding(encoding)), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject rangeError(String type, String value, String range, Node currentNode) {
        return this.rangeError(StringUtils.format("%s %s out of range of %s", type, value, range), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject rangeError(DynamicObject range, Node currentNode) {
        assert (RubyGuards.isIntRange(range));
        return this.rangeError(StringUtils.format("%d..%s%d out of range", Layouts.INT_RANGE.getBegin(range), Layouts.INT_RANGE.getExcludedEnd(range) ? "." : "", Layouts.INT_RANGE.getEnd(range)), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject rangeErrorConvertToInt(long value, Node currentNode) {
        String direction;
        if (value < Integer.MIN_VALUE) {
            direction = "small";
        } else if (value > Integer.MAX_VALUE) {
            direction = "big";
        } else {
            throw new IllegalArgumentException();
        }
        return this.rangeError(StringUtils.format("integer %d too %s to convert to `int'", value, direction), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject rangeError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getRangeErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    public DynamicObject internalErrorUnsafe(Node currentNode) {
        return this.internalError("unsafe operation", currentNode, null);
    }

    public DynamicObject internalError(String message, Node currentNode) {
        return this.internalError(message, currentNode, null);
    }

    public DynamicObject internalErrorAssertConstantNotConstant(Node currentNode) {
        return this.internalError("Value in Truffle::Graal.assert_constant was not constant", currentNode);
    }

    public DynamicObject internalErrorAssertNotCompiledCompiled(Node currentNode) {
        return this.internalError("Call to Truffle::Graal.assert_not_compiled was compiled", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject internalError(String message, Node currentNode, Throwable javaThrowable) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getRubyTruffleErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope("internal implementation error - " + message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode, javaThrowable));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject regexpError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getRegexpErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject encodingCompatibilityErrorIncompatible(Encoding a, Encoding b, Node currentNode) {
        return this.encodingCompatibilityError(StringUtils.format("incompatible character encodings: %s and %s", a, b), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject encodingCompatibilityError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getEncodingCompatibilityErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject fiberError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getFiberErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    public DynamicObject deadFiberCalledError(Node currentNode) {
        return this.fiberError("dead fiber called", currentNode);
    }

    public DynamicObject yieldFromRootFiberError(Node currentNode) {
        return this.fiberError("can't yield from root fiber", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject threadError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getThreadErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    public DynamicObject threadErrorKilledThread(Node currentNode) {
        return this.threadError("killed thread", currentNode);
    }

    public DynamicObject threadErrorRecursiveLocking(Node currentNode) {
        return this.threadError("deadlock; recursive locking", currentNode);
    }

    public DynamicObject threadErrorUnlockNotLocked(Node currentNode) {
        return this.threadError("Attempt to unlock a mutex which is not locked", currentNode);
    }

    public DynamicObject threadErrorAlreadyLocked(Node currentNode) {
        return this.threadError("Attempt to unlock a mutex which is locked by another thread", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject securityError(String message, Node currentNode) {
        return ExceptionOperations.createRubyException(this.context.getCoreLibrary().getSecurityErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject systemCallError(String message, int errno, Node currentNode) {
        return ExceptionOperations.createSystemCallError(this.context.getCoreLibrary().getSystemCallErrorClass(), StringOperations.createString(this.context, StringOperations.encodeRope(message, (Encoding)UTF8Encoding.INSTANCE)), this.context.getCallStack().getBacktrace(currentNode), errno);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject eAGAINWaitReadable(Node currentNode) {
        return ExceptionOperations.createSystemCallError(this.context.getCoreLibrary().getEagainWaitReadable(), this.coreStrings().RESOURCE_TEMP_UNAVAIL.createInstance(), this.context.getCallStack().getBacktrace(currentNode), Errno.EAGAIN.intValue());
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject eAGAINWaitWritable(Node currentNode) {
        return ExceptionOperations.createSystemCallError(this.context.getCoreLibrary().getEagainWaitWritable(), this.coreStrings().RESOURCE_TEMP_UNAVAIL.createInstance(), this.context.getCallStack().getBacktrace(currentNode), Errno.EAGAIN.intValue());
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject systemExit(int exitStatus, Node currentNode) {
        DynamicObject message = StringOperations.createString(this.context, StringOperations.encodeRope("exit", (Encoding)UTF8Encoding.INSTANCE));
        DynamicObject systemExit = ExceptionOperations.createRubyException(this.context.getCoreLibrary().getSystemExitClass(), message, this.context.getCallStack().getBacktrace(currentNode));
        systemExit.define("@status", exitStatus, 0);
        return systemExit;
    }

    private CoreStrings coreStrings() {
        return this.context.getCoreStrings();
    }
}

