/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.parser.jruby;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.control.BreakID;
import org.jruby.truffle.language.control.ReturnID;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadDeclarationVariableNode;
import org.jruby.truffle.language.locals.ReadLocalVariableNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.parser.jruby.ParseEnvironment;
import org.jruby.truffle.language.parser.jruby.ReadLocalNode;
import org.jruby.truffle.language.parser.jruby.Translator;

public class TranslatorEnvironment {
    private final RubyContext context;
    private final ParseEnvironment parseEnvironment;
    private final FrameDescriptor frameDescriptor;
    private final List<FrameSlot> flipFlopStates = new ArrayList<FrameSlot>();
    private final ReturnID returnID;
    private final int blockDepth;
    private BreakID breakID;
    private final boolean ownScopeForAssignments;
    private final boolean neverAssignInParentScope;
    protected final TranslatorEnvironment parent;
    private boolean needsDeclarationFrame = false;
    private final SharedMethodInfo sharedMethodInfo;
    private final String namedMethodName;
    private static AtomicInteger tempIndex = new AtomicInteger();
    public boolean hasRestParameter = false;

    public TranslatorEnvironment(RubyContext context, TranslatorEnvironment parent, ParseEnvironment parseEnvironment, ReturnID returnID, boolean ownScopeForAssignments, boolean neverAssignInParentScope, SharedMethodInfo sharedMethodInfo, String namedMethodName, int blockDepth, BreakID breakID, FrameDescriptor frameDescriptor) {
        this.context = context;
        this.parent = parent;
        this.frameDescriptor = frameDescriptor;
        this.parseEnvironment = parseEnvironment;
        this.returnID = returnID;
        this.ownScopeForAssignments = ownScopeForAssignments;
        this.neverAssignInParentScope = neverAssignInParentScope;
        this.sharedMethodInfo = sharedMethodInfo;
        this.namedMethodName = namedMethodName;
        this.blockDepth = blockDepth;
        this.breakID = breakID;
    }

    public TranslatorEnvironment(RubyContext context, TranslatorEnvironment parent, ParseEnvironment parseEnvironment, ReturnID returnID, boolean ownScopeForAssignments, boolean neverAssignInParentScope, SharedMethodInfo methodIdentifier, String namedMethodName, int blockDepth, BreakID breakID) {
        this(context, parent, parseEnvironment, returnID, ownScopeForAssignments, neverAssignInParentScope, methodIdentifier, namedMethodName, blockDepth, breakID, new FrameDescriptor(context.getCoreLibrary().getNilObject()));
    }

    public LexicalScope getLexicalScope() {
        return this.parseEnvironment.getLexicalScope();
    }

    public LexicalScope pushLexicalScope() {
        return this.parseEnvironment.pushLexicalScope();
    }

    public void popLexicalScope() {
        this.parseEnvironment.popLexicalScope();
    }

    public TranslatorEnvironment getParent() {
        return this.parent;
    }

    public TranslatorEnvironment getParent(int level) {
        assert (level >= 0);
        if (level == 0) {
            return this;
        }
        return this.parent.getParent(level - 1);
    }

    public FrameSlot declareVar(String name) {
        return this.getFrameDescriptor().findOrAddFrameSlot(name);
    }

    public FrameSlot declareVarWhereAllowed(String name) {
        if (this.isBlock()) {
            return this.parent.declareVarWhereAllowed(name);
        }
        return this.declareVar(name);
    }

    public SharedMethodInfo findMethodForLocalVar(String name) {
        TranslatorEnvironment current = this;
        do {
            FrameSlot slot;
            if ((slot = current.getFrameDescriptor().findFrameSlot(name)) == null) continue;
            return current.sharedMethodInfo;
        } while ((current = current.parent) != null);
        return null;
    }

    public ReadLocalNode findOrAddLocalVarNodeDangerous(String name, SourceSection sourceSection) {
        ReadLocalNode localVar = this.findLocalVarNode(name, sourceSection);
        if (localVar == null) {
            this.declareVar(name);
            localVar = this.findLocalVarNode(name, sourceSection);
        }
        return localVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadLocalNode findLocalVarNode(String name, SourceSection sourceSection) {
        TranslatorEnvironment current = this;
        int level = -1;
        try {
            do {
                ++level;
                FrameSlot slot = current.getFrameDescriptor().findFrameSlot(name);
                if (slot == null) continue;
                LocalVariableType type = Translator.FRAME_LOCAL_GLOBAL_VARIABLES.contains(name) ? (Translator.ALWAYS_DEFINED_GLOBALS.contains(name) ? LocalVariableType.ALWAYS_DEFINED_GLOBAL : LocalVariableType.FRAME_LOCAL_GLOBAL) : LocalVariableType.FRAME_LOCAL;
                if (level == 0) {
                    ReadLocalVariableNode readLocalVariableNode = new ReadLocalVariableNode(this.context, sourceSection, type, slot);
                    return readLocalVariableNode;
                }
                ReadDeclarationVariableNode readDeclarationVariableNode = new ReadDeclarationVariableNode(this.context, sourceSection, type, level, slot);
                return readDeclarationVariableNode;
            } while ((current = current.parent) != null);
        }
        finally {
            if (current != null) {
                current = this;
                while (level-- > 0) {
                    current.needsDeclarationFrame = true;
                    current = current.parent;
                }
            }
        }
        return null;
    }

    public void setNeedsDeclarationFrame() {
        this.needsDeclarationFrame = true;
    }

    public boolean needsDeclarationFrame() {
        return this.needsDeclarationFrame;
    }

    public FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    public String allocateLocalTemp(String indicator) {
        String name = "rubytruffle_temp_" + indicator + "_" + tempIndex.getAndIncrement();
        this.declareVar(name);
        return name;
    }

    public ReturnID getReturnID() {
        return this.returnID;
    }

    public ParseEnvironment getParseEnvironment() {
        return this.parseEnvironment;
    }

    public boolean hasOwnScopeForAssignments() {
        return this.ownScopeForAssignments;
    }

    public boolean getNeverAssignInParentScope() {
        return this.neverAssignInParentScope;
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public List<FrameSlot> getFlipFlopStates() {
        return this.flipFlopStates;
    }

    public String getNamedMethodName() {
        return this.namedMethodName;
    }

    public boolean isBlock() {
        return this.blockDepth > 0;
    }

    public int getBlockDepth() {
        return this.blockDepth;
    }

    public BreakID getBreakID() {
        return this.breakID;
    }

    public void setBreakIDForWhile(BreakID breakID) {
        this.breakID = breakID;
    }
}

