/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bJ \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;", "", "()V", "getSmartCastSubType", "Lorg/jetbrains/kotlin/types/KotlinType;", "receiverParameterType", "smartCastTypes", "", "getSmartCastVariants", "", "receiverToCast", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "containingDeclarationOrModule", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "getSmartCastVariantsExcludingReceiver", "isSubTypeBySmartCastIgnoringNullability", "", "receiverArgument", "Companion", "kotlin-compiler"})
public final class SmartCastManager {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<KotlinType> getSmartCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkParameterIsNotNull(receiverToCast, "receiverToCast");
        Intrinsics.checkParameterIsNotNull(context, "context");
        BindingContext bindingContext = context.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        return this.getSmartCastVariants(receiverToCast, bindingContext, declarationDescriptor, dataFlowInfo);
    }

    @NotNull
    public final List<KotlinType> getSmartCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull DataFlowInfo dataFlowInfo) {
        Intrinsics.checkParameterIsNotNull(receiverToCast, "receiverToCast");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(containingDeclarationOrModule, "containingDeclarationOrModule");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Collection<KotlinType> variants = this.getSmartCastVariantsExcludingReceiver(bindingContext, containingDeclarationOrModule, dataFlowInfo, receiverToCast);
        ArrayList<KotlinType> result2 = new ArrayList<KotlinType>(variants.size() + 1);
        result2.add(receiverToCast.getType());
        result2.addAll(variants);
        return result2;
    }

    @NotNull
    public final Collection<KotlinType> getSmartCastVariantsExcludingReceiver(@NotNull ResolutionContext<?> context, @NotNull ReceiverValue receiverToCast) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(receiverToCast, "receiverToCast");
        BindingContext bindingContext = context.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        return this.getSmartCastVariantsExcludingReceiver(bindingContext, declarationDescriptor, dataFlowInfo, receiverToCast);
    }

    @NotNull
    public final Collection<KotlinType> getSmartCastVariantsExcludingReceiver(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull DataFlowInfo dataFlowInfo, @NotNull ReceiverValue receiverToCast) {
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(containingDeclarationOrModule, "containingDeclarationOrModule");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkParameterIsNotNull(receiverToCast, "receiverToCast");
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverToCast, bindingContext, containingDeclarationOrModule);
        return dataFlowInfo.getCollectedTypes(dataFlowValue);
    }

    public final boolean isSubTypeBySmartCastIgnoringNullability(@NotNull ReceiverValue receiverArgument, @NotNull KotlinType receiverParameterType, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkParameterIsNotNull(receiverArgument, "receiverArgument");
        Intrinsics.checkParameterIsNotNull(receiverParameterType, "receiverParameterType");
        Intrinsics.checkParameterIsNotNull(context, "context");
        List<KotlinType> smartCastTypes = this.getSmartCastVariants(receiverArgument, context);
        KotlinType kotlinType = TypeUtils.makeNullable(receiverParameterType);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.makeNullable(receiverParameterType)");
        return this.getSmartCastSubType(kotlinType, (Collection<? extends KotlinType>)smartCastTypes) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType getSmartCastSubType(KotlinType receiverParameterType, Collection<? extends KotlinType> smartCastTypes) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = smartCastTypes;
        void var5_4 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(it, receiverParameterType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List subTypes = CollectionsKt.distinct((List)destination$iv$iv);
        if (subTypes.isEmpty()) {
            return null;
        }
        KotlinType intersection = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, subTypes);
        if (intersection == null || !intersection.getConstructor().isDenotable()) {
            return receiverParameterType;
        }
        return intersection;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000bJ@\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000bJ0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager$Companion;", "", "()V", "checkAndRecordPossibleCast", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastResult;", "dataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "additionalPredicate", "Lkotlin/Function1;", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "calleeExpression", "recordExpressionType", "recordCastOrError", "", "type", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "kotlin-compiler"})
    public static final class Companion {
        private final void recordCastOrError(KtExpression expression, KotlinType type2, BindingTrace trace, DataFlowValue dataFlowValue, boolean recordExpressionType) {
            if (KotlinBuiltIns.isNullableNothing(type2)) {
                return;
            }
            if (dataFlowValue.isPredictable()) {
                trace.record(BindingContext.SMARTCAST, expression, type2);
                if (recordExpressionType) {
                    trace.recordType(expression, type2);
                }
            } else {
                trace.report(Errors.SMARTCAST_IMPOSSIBLE.on((KtExpression)((PsiElement)expression), type2, expression.getText(), dataFlowValue.getKind().getDescription()));
            }
        }

        @Nullable
        public final SmartCastResult checkAndRecordPossibleCast(@NotNull DataFlowValue dataFlowValue, @NotNull KotlinType expectedType, @Nullable KtExpression expression, @NotNull ResolutionContext<?> c, @Nullable KtExpression calleeExpression, boolean recordExpressionType) {
            Intrinsics.checkParameterIsNotNull(dataFlowValue, "dataFlowValue");
            Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
            Intrinsics.checkParameterIsNotNull(c, "c");
            return this.checkAndRecordPossibleCast(dataFlowValue, expectedType, null, expression, c, calleeExpression, recordExpressionType);
        }

        @Nullable
        public final SmartCastResult checkAndRecordPossibleCast(@NotNull DataFlowValue dataFlowValue, @NotNull KotlinType expectedType, @Nullable Function1<? super KotlinType, Boolean> additionalPredicate, @Nullable KtExpression expression, @NotNull ResolutionContext<?> c, @Nullable KtExpression calleeExpression, boolean recordExpressionType) {
            Intrinsics.checkParameterIsNotNull(dataFlowValue, "dataFlowValue");
            Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
            Intrinsics.checkParameterIsNotNull(c, "c");
            for (KotlinType possibleType : c.dataFlowInfo.getCollectedTypes(dataFlowValue)) {
                if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(possibleType, expectedType) || additionalPredicate != null && !additionalPredicate.invoke(possibleType).booleanValue()) continue;
                if (expression != null) {
                    BindingTrace bindingTrace = c.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
                    this.recordCastOrError(expression, possibleType, bindingTrace, dataFlowValue, recordExpressionType);
                } else if (calleeExpression != null && dataFlowValue.isPredictable()) {
                    c.trace.record(BindingContext.IMPLICIT_RECEIVER_SMARTCAST, calleeExpression, possibleType);
                }
                return new SmartCastResult(possibleType, dataFlowValue.isPredictable());
            }
            if (!c.dataFlowInfo.getCollectedNullability(dataFlowValue).canBeNull() && !expectedType.isMarkedNullable()) {
                boolean immanentlyNotNull = !dataFlowValue.getImmanentNullability().canBeNull();
                KotlinType nullableExpectedType = TypeUtils.makeNullable(expectedType);
                if (ArgumentTypeResolver.isSubtypeOfForArgumentType(dataFlowValue.getType(), nullableExpectedType) && (additionalPredicate == null || additionalPredicate.invoke(dataFlowValue.getType()).booleanValue())) {
                    if (!immanentlyNotNull && expression != null) {
                        KotlinType kotlinType = dataFlowValue.getType();
                        BindingTrace bindingTrace = c.trace;
                        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
                        this.recordCastOrError(expression, kotlinType, bindingTrace, dataFlowValue, recordExpressionType);
                    }
                    return new SmartCastResult(dataFlowValue.getType(), immanentlyNotNull || dataFlowValue.isPredictable());
                }
                KotlinType kotlinType = nullableExpectedType;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "nullableExpectedType");
                return this.checkAndRecordPossibleCast(dataFlowValue, kotlinType, expression, c, calleeExpression, recordExpressionType);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

