/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.SSLConnector;
import org.zaproxy.zap.utils.FontUtils;

public class SecurityProtocolsPanel
extends JPanel {
    private static final long serialVersionUID = 5096843444189699353L;
    private Map<String, JCheckBox> checkBoxesSslTlsProtocols;
    private boolean supportedSecurityProtocolsInitialised;

    public SecurityProtocolsPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("generic.options.panel.security.protocols.title"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.checkBoxesSslTlsProtocols = new HashMap<String, JCheckBox>();
        JCheckBox jCheckBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.ssl2hello.label"));
        jCheckBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("SSLv2Hello", jCheckBox);
        this.add((Component)jCheckBox, gridBagConstraints);
        jCheckBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.ssl3.label"));
        jCheckBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("SSLv3", jCheckBox);
        this.add((Component)jCheckBox, gridBagConstraints);
        jCheckBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.tlsv1.label"));
        jCheckBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("TLSv1", jCheckBox);
        this.add((Component)jCheckBox, gridBagConstraints);
        jCheckBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.tlsv1.1.label"));
        jCheckBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("TLSv1.1", jCheckBox);
        this.add((Component)jCheckBox, gridBagConstraints);
        jCheckBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.tlsv1.2.label"));
        jCheckBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("TLSv1.2", jCheckBox);
        this.add((Component)jCheckBox, gridBagConstraints);
    }

    /*
     * WARNING - void declaration
     */
    public void setSecurityProtocolsEnabled(String[] stringArray) {
        if (!this.supportedSecurityProtocolsInitialised) {
            String[] object = SSLConnector.getSupportedProtocols();
            for (Object object2 : object) {
                JCheckBox jCheckBox = this.checkBoxesSslTlsProtocols.get(object2);
                if (jCheckBox == null) continue;
                jCheckBox.setEnabled(true);
            }
            Object var3_4 = null;
            for (JCheckBox jCheckBox : this.checkBoxesSslTlsProtocols.values()) {
                void var3_5;
                if (jCheckBox.isEnabled()) continue;
                if (var3_5 == null) {
                    String string = Constant.messages.getString("generic.options.panel.security.protocols.protocol.not.supported.tooltip");
                }
                jCheckBox.setToolTipText((String)var3_5);
            }
            this.supportedSecurityProtocolsInitialised = true;
        }
        for (JCheckBox jCheckBox : this.checkBoxesSslTlsProtocols.values()) {
            jCheckBox.setSelected(false);
        }
        for (String string : stringArray) {
            Object object2;
            object2 = this.checkBoxesSslTlsProtocols.get(string);
            if (object2 == null || !((Component)object2).isEnabled()) continue;
            ((AbstractButton)object2).setSelected(true);
        }
    }

    public void validateSecurityProtocols() throws Exception {
        boolean bl = false;
        JComponent jComponent = null;
        for (Map.Entry<String, JCheckBox> entry : this.checkBoxesSslTlsProtocols.entrySet()) {
            JCheckBox jCheckBox = entry.getValue();
            if (!jCheckBox.isEnabled()) continue;
            if (jComponent == null) {
                jComponent = jCheckBox;
            }
            if (!jCheckBox.isSelected()) continue;
            bl = true;
            break;
        }
        if (jComponent != null && !bl) {
            jComponent.requestFocusInWindow();
            throw new Exception(Constant.messages.getString("generic.options.panel.security.protocols.error.no.protocols.selected"));
        }
    }

    public String[] getSelectedProtocols() {
        int n = 0;
        String[] stringArray = new String[this.checkBoxesSslTlsProtocols.values().size()];
        for (Map.Entry<String, JCheckBox> entry : this.checkBoxesSslTlsProtocols.entrySet()) {
            JCheckBox jCheckBox = entry.getValue();
            if (!jCheckBox.isEnabled() || !jCheckBox.isSelected()) continue;
            stringArray[n] = entry.getKey();
            ++n;
        }
        return Arrays.copyOf(stringArray, n);
    }
}

