/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Base64;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.RAMOutputStream;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.ScrollIdForNode;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;

final class TransportSearchHelper {
    static ShardSearchTransportRequest internalSearchRequest(ShardRouting shardRouting, int numberOfShards, SearchRequest request, String[] filteringAliases, long nowInMillis) {
        return new ShardSearchTransportRequest(request, shardRouting, numberOfShards, filteringAliases, nowInMillis);
    }

    static InternalScrollSearchRequest internalScrollSearchRequest(long id, SearchScrollRequest request) {
        return new InternalScrollSearchRequest(request, id);
    }

    static String buildScrollId(SearchType searchType, AtomicArray<? extends SearchPhaseResult> searchPhaseResults) throws IOException {
        if (searchType == SearchType.DFS_QUERY_THEN_FETCH || searchType == SearchType.QUERY_THEN_FETCH) {
            return TransportSearchHelper.buildScrollId("queryThenFetch", searchPhaseResults);
        }
        if (searchType == SearchType.QUERY_AND_FETCH || searchType == SearchType.DFS_QUERY_AND_FETCH) {
            return TransportSearchHelper.buildScrollId("queryAndFetch", searchPhaseResults);
        }
        throw new IllegalStateException("search_type [" + (Object)((Object)searchType) + "] not supported");
    }

    static String buildScrollId(String type, AtomicArray<? extends SearchPhaseResult> searchPhaseResults) throws IOException {
        try (RAMOutputStream out = new RAMOutputStream();){
            out.writeString(type);
            out.writeVInt(searchPhaseResults.asList().size());
            for (AtomicArray.Entry<? extends SearchPhaseResult> entry : searchPhaseResults.asList()) {
                SearchPhaseResult searchPhaseResult = (SearchPhaseResult)entry.value;
                out.writeLong(searchPhaseResult.id());
                out.writeString(searchPhaseResult.shardTarget().nodeId());
            }
            byte[] bytes = new byte[(int)out.getFilePointer()];
            out.writeTo(bytes, 0);
            String string = Base64.getUrlEncoder().encodeToString(bytes);
            return string;
        }
    }

    static ParsedScrollId parseScrollId(String scrollId) {
        try {
            byte[] bytes = Base64.getUrlDecoder().decode(scrollId);
            ByteArrayDataInput in = new ByteArrayDataInput(bytes);
            String type = in.readString();
            ScrollIdForNode[] context = new ScrollIdForNode[in.readVInt()];
            for (int i = 0; i < context.length; ++i) {
                long id = in.readLong();
                String target = in.readString();
                context[i] = new ScrollIdForNode(target, id);
            }
            if (in.getPosition() != bytes.length) {
                throw new IllegalArgumentException("Not all bytes were read");
            }
            return new ParsedScrollId(scrollId, type, context);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse scroll id", e);
        }
    }

    private TransportSearchHelper() {
    }
}

