/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.client.transport.TransportClientNodesService;
import org.elasticsearch.client.transport.support.TransportProxyClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.internal.InternalSettingsPreparer;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportService;

public abstract class TransportClient
extends AbstractClient {
    public static final String CLIENT_TYPE = "transport";
    final Injector injector;
    final NamedWriteableRegistry namedWriteableRegistry;
    private final List<LifecycleComponent> pluginLifecycleComponents;
    private final TransportClientNodesService nodesService;
    private final TransportProxyClient proxy;

    private static PluginsService newPluginService(Settings settings, Collection<Class<? extends Plugin>> plugins) {
        Settings.Builder settingsBuilder = Settings.builder().put(TcpTransport.PING_SCHEDULE.getKey(), "5s").put(InternalSettingsPreparer.prepareSettings(settings)).put(NetworkService.NETWORK_SERVER.getKey(), false).put(CLIENT_TYPE_SETTING_S.getKey(), CLIENT_TYPE);
        return new PluginsService(settingsBuilder.build(), null, null, plugins);
    }

    protected static Collection<Class<? extends Plugin>> addPlugins(Collection<Class<? extends Plugin>> collection, Class<? extends Plugin> ... plugins) {
        return TransportClient.addPlugins(collection, Arrays.asList(plugins));
    }

    protected static Collection<Class<? extends Plugin>> addPlugins(Collection<Class<? extends Plugin>> collection, Collection<Class<? extends Plugin>> plugins) {
        ArrayList<Class<? extends Plugin>> list = new ArrayList<Class<? extends Plugin>>(collection);
        for (Class<? extends Plugin> p : plugins) {
            if (list.contains(p)) {
                throw new IllegalArgumentException("plugin already exists: " + p);
            }
            list.add(p);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientTemplate buildTemplate(Settings providedSettings, Settings defaultSettings, Collection<Class<? extends Plugin>> plugins) {
        if (!Node.NODE_NAME_SETTING.exists(providedSettings)) {
            providedSettings = Settings.builder().put(providedSettings).put(Node.NODE_NAME_SETTING.getKey(), "_client_").build();
        }
        PluginsService pluginsService = TransportClient.newPluginService(providedSettings, plugins);
        Settings settings = Settings.builder().put(defaultSettings).put(pluginsService.updatedSettings()).build();
        ArrayList<Closeable> resourcesToClose = new ArrayList<Closeable>();
        ThreadPool threadPool = new ThreadPool(settings, new ExecutorBuilder[0]);
        resourcesToClose.add(() -> ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS));
        NetworkService networkService = new NetworkService(settings, Collections.emptyList());
        try {
            ArrayList additionalSettings = new ArrayList();
            ArrayList<String> additionalSettingsFilter = new ArrayList<String>();
            additionalSettings.addAll(pluginsService.getPluginSettings());
            additionalSettingsFilter.addAll(pluginsService.getPluginSettingsFilter());
            for (ExecutorBuilder builder : threadPool.builders()) {
                additionalSettings.addAll(builder.getRegisteredSettings());
            }
            SettingsModule settingsModule = new SettingsModule(settings, additionalSettings, additionalSettingsFilter);
            NetworkModule networkModule = new NetworkModule(networkService, settings, true);
            SearchModule searchModule = new SearchModule(settings, true, pluginsService.filterPlugins(SearchPlugin.class));
            ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
            entries.addAll(networkModule.getNamedWriteables());
            entries.addAll(searchModule.getNamedWriteables());
            entries.addAll(pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedWriteables().stream()).collect(Collectors.toList()));
            NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(entries);
            ModulesBuilder modules = new ModulesBuilder();
            for (Module pluginModule : pluginsService.createGuiceModules()) {
                modules.add(pluginModule);
            }
            modules.add(networkModule);
            modules.add(b -> b.bind(ThreadPool.class).toInstance(threadPool));
            ActionModule actionModule = new ActionModule(false, true, settings, null, settingsModule.getClusterSettings(), pluginsService.filterPlugins(ActionPlugin.class));
            modules.add(actionModule);
            pluginsService.processModules(modules);
            CircuitBreakerService circuitBreakerService = Node.createCircuitBreakerService(settingsModule.getSettings(), settingsModule.getClusterSettings());
            resourcesToClose.add(circuitBreakerService);
            BigArrays bigArrays = new BigArrays(settings, circuitBreakerService);
            resourcesToClose.add(bigArrays);
            modules.add(settingsModule);
            modules.add(b -> {
                b.bind(BigArrays.class).toInstance(bigArrays);
                b.bind(PluginsService.class).toInstance(pluginsService);
                b.bind(CircuitBreakerService.class).toInstance(circuitBreakerService);
                b.bind(NamedWriteableRegistry.class).toInstance(namedWriteableRegistry);
            });
            Injector injector = modules.createInjector();
            TransportService transportService = injector.getInstance(TransportService.class);
            TransportClientNodesService nodesService = new TransportClientNodesService(settings, transportService, threadPool);
            TransportProxyClient proxy = new TransportProxyClient(settings, transportService, nodesService, actionModule.getActions().values().stream().map(x -> x.getAction()).collect(Collectors.toList()));
            ArrayList pluginLifecycleComponents = new ArrayList();
            pluginLifecycleComponents.addAll(pluginsService.getGuiceServiceClasses().stream().map(injector::getInstance).collect(Collectors.toList()));
            resourcesToClose.addAll(pluginLifecycleComponents);
            transportService.start();
            transportService.acceptIncomingRequests();
            ClientTemplate transportClient = new ClientTemplate(injector, pluginLifecycleComponents, nodesService, proxy, namedWriteableRegistry);
            resourcesToClose.clear();
            ClientTemplate clientTemplate = transportClient;
            return clientTemplate;
        }
        finally {
            IOUtils.closeWhileHandlingException(resourcesToClose);
        }
    }

    public TransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins) {
        this(TransportClient.buildTemplate(settings, Settings.EMPTY, plugins));
    }

    protected TransportClient(Settings settings, Settings defaultSettings, Collection<Class<? extends Plugin>> plugins) {
        this(TransportClient.buildTemplate(settings, defaultSettings, plugins));
    }

    private TransportClient(ClientTemplate template) {
        super(template.getSettings(), template.getThreadPool());
        this.injector = template.injector;
        this.pluginLifecycleComponents = Collections.unmodifiableList(template.pluginLifecycleComponents);
        this.nodesService = template.nodesService;
        this.proxy = template.proxy;
        this.namedWriteableRegistry = template.namedWriteableRegistry;
    }

    public List<TransportAddress> transportAddresses() {
        return this.nodesService.transportAddresses();
    }

    public List<DiscoveryNode> connectedNodes() {
        return this.nodesService.connectedNodes();
    }

    public List<DiscoveryNode> filteredNodes() {
        return this.nodesService.filteredNodes();
    }

    public List<DiscoveryNode> listedNodes() {
        return this.nodesService.listedNodes();
    }

    public TransportClient addTransportAddress(TransportAddress transportAddress) {
        this.nodesService.addTransportAddresses(transportAddress);
        return this;
    }

    public TransportClient addTransportAddresses(TransportAddress ... transportAddress) {
        this.nodesService.addTransportAddresses(transportAddress);
        return this;
    }

    public TransportClient removeTransportAddress(TransportAddress transportAddress) {
        this.nodesService.removeTransportAddress(transportAddress);
        return this;
    }

    @Override
    public void close() {
        ArrayList<Object> closeables = new ArrayList<Object>();
        closeables.add(this.nodesService);
        closeables.add(this.injector.getInstance(TransportService.class));
        for (LifecycleComponent plugin : this.pluginLifecycleComponents) {
            closeables.add(plugin);
        }
        closeables.add(() -> ThreadPool.terminate(this.injector.getInstance(ThreadPool.class), 10L, TimeUnit.SECONDS));
        closeables.add(this.injector.getInstance(BigArrays.class));
        IOUtils.closeWhileHandlingException(closeables);
    }

    @Override
    protected <Request extends ActionRequest<Request>, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        this.proxy.execute(action, request, listener);
    }

    private static final class ClientTemplate {
        final Injector injector;
        private final List<LifecycleComponent> pluginLifecycleComponents;
        private final TransportClientNodesService nodesService;
        private final TransportProxyClient proxy;
        private final NamedWriteableRegistry namedWriteableRegistry;

        private ClientTemplate(Injector injector, List<LifecycleComponent> pluginLifecycleComponents, TransportClientNodesService nodesService, TransportProxyClient proxy, NamedWriteableRegistry namedWriteableRegistry) {
            this.injector = injector;
            this.pluginLifecycleComponents = pluginLifecycleComponents;
            this.nodesService = nodesService;
            this.proxy = proxy;
            this.namedWriteableRegistry = namedWriteableRegistry;
        }

        Settings getSettings() {
            return this.injector.getInstance(Settings.class);
        }

        ThreadPool getThreadPool() {
            return this.injector.getInstance(ThreadPool.class);
        }
    }
}

