/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import com.carrotsearch.hppc.ObjectIntHashMap;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class AwarenessAllocationDecider
extends AllocationDecider {
    public static final String NAME = "awareness";
    public static final Setting<String[]> CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING = new Setting<String[]>("cluster.routing.allocation.awareness.attributes", "", Strings::splitStringByCommaToArray, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Settings> CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING = Setting.groupSetting("cluster.routing.allocation.awareness.force.", Setting.Property.Dynamic, Setting.Property.NodeScope);
    private String[] awarenessAttributes;
    private volatile Map<String, String[]> forcedAwarenessAttributes;

    public AwarenessAllocationDecider() {
        this(Settings.Builder.EMPTY_SETTINGS);
    }

    public AwarenessAllocationDecider(Settings settings) {
        this(settings, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
    }

    public AwarenessAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.awarenessAttributes = CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        this.setForcedAwarenessAttributes(CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING, this::setForcedAwarenessAttributes);
    }

    private void setForcedAwarenessAttributes(Settings forceSettings) {
        HashMap<String, String[]> forcedAwarenessAttributes = new HashMap<String, String[]>();
        Map<String, Settings> forceGroups = forceSettings.getAsGroups();
        for (Map.Entry<String, Settings> entry : forceGroups.entrySet()) {
            String[] aValues = entry.getValue().getAsArray("values");
            if (aValues.length <= 0) continue;
            forcedAwarenessAttributes.put(entry.getKey(), aValues);
        }
        this.forcedAwarenessAttributes = forcedAwarenessAttributes;
    }

    private void setAwarenessAttributes(String[] awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, true);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, false);
    }

    private Decision underCapacity(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, boolean moveToNode) {
        if (this.awarenessAttributes.length == 0) {
            return allocation.decision(Decision.YES, NAME, "allocation awareness is not enabled", new Object[0]);
        }
        IndexMetaData indexMetaData = allocation.metaData().getIndexSafe(shardRouting.index());
        int shardCount = indexMetaData.getNumberOfReplicas() + 1;
        for (String awarenessAttribute : this.awarenessAttributes) {
            int requiredCountPerAttribute;
            if (!node.node().getAttributes().containsKey(awarenessAttribute)) {
                return allocation.decision(Decision.NO, NAME, "node does not contain the awareness attribute: [%s]", awarenessAttribute);
            }
            ObjectIntHashMap<String> nodesPerAttribute = allocation.routingNodes().nodesPerAttributesCounts(awarenessAttribute);
            ObjectIntHashMap shardPerAttribute = new ObjectIntHashMap();
            for (ShardRouting assignedShard : allocation.routingNodes().assignedShards(shardRouting.shardId())) {
                if (!assignedShard.started() && !assignedShard.initializing()) continue;
                String[] routingNode = allocation.routingNodes().node(assignedShard.currentNodeId());
                shardPerAttribute.addTo((Object)routingNode.node().getAttributes().get(awarenessAttribute), 1);
            }
            if (moveToNode) {
                if (shardRouting.assignedToNode()) {
                    String nodeId;
                    String string = nodeId = shardRouting.relocating() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId();
                    if (!node.nodeId().equals(nodeId)) {
                        shardPerAttribute.putOrAdd((Object)allocation.routingNodes().node(nodeId).node().getAttributes().get(awarenessAttribute), 0, -1);
                        shardPerAttribute.addTo((Object)node.node().getAttributes().get(awarenessAttribute), 1);
                    }
                } else {
                    shardPerAttribute.addTo((Object)node.node().getAttributes().get(awarenessAttribute), 1);
                }
            }
            int numberOfAttributes = nodesPerAttribute.size();
            String[] fullValues = this.forcedAwarenessAttributes.get(awarenessAttribute);
            if (fullValues != null) {
                for (String fullValue : fullValues) {
                    if (shardPerAttribute.containsKey((Object)fullValue)) continue;
                    ++numberOfAttributes;
                }
            }
            int averagePerAttribute = shardCount / numberOfAttributes;
            int totalLeftover = shardCount % numberOfAttributes;
            if (averagePerAttribute == 0) {
                totalLeftover = 0;
                requiredCountPerAttribute = 1;
            } else {
                requiredCountPerAttribute = averagePerAttribute;
            }
            int leftoverPerAttribute = totalLeftover == 0 ? 0 : 1;
            int currentNodeCount = shardPerAttribute.get((Object)node.node().getAttributes().get(awarenessAttribute));
            if (currentNodeCount > requiredCountPerAttribute + leftoverPerAttribute) {
                return allocation.decision(Decision.NO, NAME, "there are too many shards on the node for attribute [%s], there are [%d] total shards for the index  and [%d] total attributes values, expected the node count [%d] to be lower or equal to the required number of shards per attribute [%d] plus leftover [%d]", awarenessAttribute, shardCount, numberOfAttributes, currentNodeCount, requiredCountPerAttribute, leftoverPerAttribute);
            }
            if (currentNodeCount > requiredCountPerAttribute) continue;
        }
        return allocation.decision(Decision.YES, NAME, "node meets all awareness attribute requirements", new Object[0]);
    }
}

