/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.support.replication.ReplicationTask;
import org.elasticsearch.cluster.routing.allocation.command.AllocateEmptyPrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateReplicaAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateStalePrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommandRegistry;
import org.elasticsearch.cluster.routing.allocation.command.CancelAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ExtensionPoint;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.tasks.RawTaskStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.local.LocalTransport;

public class NetworkModule
extends AbstractModule {
    public static final String TRANSPORT_TYPE_KEY = "transport.type";
    public static final String HTTP_TYPE_KEY = "http.type";
    public static final String LOCAL_TRANSPORT = "local";
    public static final String HTTP_TYPE_DEFAULT_KEY = "http.type.default";
    public static final String TRANSPORT_TYPE_DEFAULT_KEY = "transport.type.default";
    public static final Setting<String> TRANSPORT_DEFAULT_TYPE_SETTING = Setting.simpleString("transport.type.default", Setting.Property.NodeScope);
    public static final Setting<String> HTTP_DEFAULT_TYPE_SETTING = Setting.simpleString("http.type.default", Setting.Property.NodeScope);
    public static final Setting<String> HTTP_TYPE_SETTING = Setting.simpleString("http.type", Setting.Property.NodeScope);
    public static final Setting<Boolean> HTTP_ENABLED = Setting.boolSetting("http.enabled", true, Setting.Property.NodeScope);
    public static final Setting<String> TRANSPORT_TYPE_SETTING = Setting.simpleString("transport.type", Setting.Property.NodeScope);
    private final NetworkService networkService;
    private final Settings settings;
    private final boolean transportClient;
    private final AllocationCommandRegistry allocationCommandRegistry = new AllocationCommandRegistry();
    private final ExtensionPoint.SelectedType<Transport> transportTypes = new ExtensionPoint.SelectedType<Transport>("transport", Transport.class);
    private final ExtensionPoint.SelectedType<HttpServerTransport> httpTransportTypes = new ExtensionPoint.SelectedType<HttpServerTransport>("http_transport", HttpServerTransport.class);
    private final List<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final List<TransportInterceptor> transportIntercetors = new ArrayList<TransportInterceptor>();

    public NetworkModule(NetworkService networkService, Settings settings, boolean transportClient) {
        this.networkService = networkService;
        this.settings = settings;
        this.transportClient = transportClient;
        this.registerTransport(LOCAL_TRANSPORT, LocalTransport.class);
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(Task.Status.class, "replication", ReplicationTask.Status::new));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(Task.Status.class, "raw", RawTaskStatus::new));
        this.registerBuiltinAllocationCommands();
    }

    public boolean isTransportClient() {
        return this.transportClient;
    }

    public void registerTransport(String name, Class<? extends Transport> clazz) {
        this.transportTypes.registerExtension(name, clazz);
    }

    public void registerHttpTransport(String name, Class<? extends HttpServerTransport> clazz) {
        if (this.transportClient) {
            throw new IllegalArgumentException("Cannot register http transport " + clazz.getName() + " for transport client");
        }
        this.httpTransportTypes.registerExtension(name, clazz);
    }

    private <T extends AllocationCommand> void registerAllocationCommand(Writeable.Reader<T> reader, AllocationCommand.Parser<T> parser, ParseField commandName) {
        this.allocationCommandRegistry.register(parser, commandName);
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(AllocationCommand.class, commandName.getPreferredName(), reader));
    }

    public AllocationCommandRegistry getAllocationCommandRegistry() {
        return this.allocationCommandRegistry;
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWriteables;
    }

    @Override
    protected void configure() {
        this.bind(NetworkService.class).toInstance(this.networkService);
        this.bindTransportService();
        this.transportTypes.bindType(this.binder(), this.settings, TRANSPORT_TYPE_KEY, TRANSPORT_DEFAULT_TYPE_SETTING.get(this.settings));
        this.bind(TransportInterceptor.class).toInstance(new CompositeTransportInterceptor(this.transportIntercetors));
        if (!this.transportClient) {
            if (HTTP_ENABLED.get(this.settings).booleanValue()) {
                this.bind(HttpServer.class).asEagerSingleton();
                this.httpTransportTypes.bindType(this.binder(), this.settings, HTTP_TYPE_SETTING.getKey(), HTTP_DEFAULT_TYPE_SETTING.get(this.settings));
            } else {
                this.bind(HttpServer.class).toProvider(Providers.of(null));
            }
            this.bind(AllocationCommandRegistry.class).toInstance(this.allocationCommandRegistry);
        }
    }

    private void registerBuiltinAllocationCommands() {
        this.registerAllocationCommand(CancelAllocationCommand::new, CancelAllocationCommand::fromXContent, CancelAllocationCommand.COMMAND_NAME_FIELD);
        this.registerAllocationCommand(MoveAllocationCommand::new, MoveAllocationCommand::fromXContent, MoveAllocationCommand.COMMAND_NAME_FIELD);
        this.registerAllocationCommand(AllocateReplicaAllocationCommand::new, AllocateReplicaAllocationCommand::fromXContent, AllocateReplicaAllocationCommand.COMMAND_NAME_FIELD);
        this.registerAllocationCommand(AllocateEmptyPrimaryAllocationCommand::new, AllocateEmptyPrimaryAllocationCommand::fromXContent, AllocateEmptyPrimaryAllocationCommand.COMMAND_NAME_FIELD);
        this.registerAllocationCommand(AllocateStalePrimaryAllocationCommand::new, AllocateStalePrimaryAllocationCommand::fromXContent, AllocateStalePrimaryAllocationCommand.COMMAND_NAME_FIELD);
    }

    public boolean canRegisterHttpExtensions() {
        return !this.transportClient;
    }

    public void addTransportInterceptor(TransportInterceptor interceptor) {
        this.transportIntercetors.add(Objects.requireNonNull(interceptor, "interceptor must not be null"));
    }

    protected void bindTransportService() {
        this.bind(TransportService.class).asEagerSingleton();
    }

    static final class CompositeTransportInterceptor
    implements TransportInterceptor {
        final List<TransportInterceptor> transportInterceptors;

        private CompositeTransportInterceptor(List<TransportInterceptor> transportInterceptors) {
            this.transportInterceptors = new ArrayList<TransportInterceptor>(transportInterceptors);
        }

        @Override
        public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, TransportRequestHandler<T> actualHandler) {
            for (TransportInterceptor interceptor : this.transportInterceptors) {
                actualHandler = interceptor.interceptHandler(action, actualHandler);
            }
            return actualHandler;
        }

        @Override
        public TransportInterceptor.AsyncSender interceptSender(TransportInterceptor.AsyncSender sender) {
            for (TransportInterceptor interceptor : this.transportInterceptors) {
                sender = interceptor.interceptSender(sender);
            }
            return sender;
        }
    }
}

