/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.TransportNodesListGatewayMetaState;
import org.elasticsearch.index.NodeServicesProvider;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class GatewayService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    public static final Setting<Integer> EXPECTED_NODES_SETTING = Setting.intSetting("gateway.expected_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Integer> EXPECTED_DATA_NODES_SETTING = Setting.intSetting("gateway.expected_data_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Integer> EXPECTED_MASTER_NODES_SETTING = Setting.intSetting("gateway.expected_master_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<TimeValue> RECOVER_AFTER_TIME_SETTING = Setting.positiveTimeSetting("gateway.recover_after_time", TimeValue.timeValueMillis(0L), Setting.Property.NodeScope);
    public static final Setting<Integer> RECOVER_AFTER_NODES_SETTING = Setting.intSetting("gateway.recover_after_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Integer> RECOVER_AFTER_DATA_NODES_SETTING = Setting.intSetting("gateway.recover_after_data_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Integer> RECOVER_AFTER_MASTER_NODES_SETTING = Setting.intSetting("gateway.recover_after_master_nodes", 0, 0, Setting.Property.NodeScope);
    public static final ClusterBlock STATE_NOT_RECOVERED_BLOCK = new ClusterBlock(1, "state not recovered / initialized", true, true, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    public static final TimeValue DEFAULT_RECOVER_AFTER_TIME_IF_EXPECTED_NODES_IS_SET = TimeValue.timeValueMinutes(5L);
    private final Gateway gateway;
    private final ThreadPool threadPool;
    private final AllocationService allocationService;
    private final ClusterService clusterService;
    private final TimeValue recoverAfterTime;
    private final int recoverAfterNodes;
    private final int expectedNodes;
    private final int recoverAfterDataNodes;
    private final int expectedDataNodes;
    private final int recoverAfterMasterNodes;
    private final int expectedMasterNodes;
    private final AtomicBoolean recovered = new AtomicBoolean();
    private final AtomicBoolean scheduledRecovery = new AtomicBoolean();

    @Inject
    public GatewayService(Settings settings, AllocationService allocationService, ClusterService clusterService, ThreadPool threadPool, GatewayMetaState metaState, TransportNodesListGatewayMetaState listGatewayMetaState, Discovery discovery, NodeServicesProvider nodeServicesProvider, IndicesService indicesService) {
        super(settings);
        this.gateway = new Gateway(settings, clusterService, metaState, listGatewayMetaState, discovery, nodeServicesProvider, indicesService);
        this.allocationService = allocationService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.expectedNodes = EXPECTED_NODES_SETTING.get(this.settings);
        this.expectedDataNodes = EXPECTED_DATA_NODES_SETTING.get(this.settings);
        this.expectedMasterNodes = EXPECTED_MASTER_NODES_SETTING.get(this.settings);
        this.recoverAfterTime = RECOVER_AFTER_TIME_SETTING.exists(this.settings) ? RECOVER_AFTER_TIME_SETTING.get(this.settings) : (this.expectedNodes >= 0 || this.expectedDataNodes >= 0 || this.expectedMasterNodes >= 0 ? DEFAULT_RECOVER_AFTER_TIME_IF_EXPECTED_NODES_IS_SET : null);
        this.recoverAfterNodes = RECOVER_AFTER_NODES_SETTING.get(this.settings);
        this.recoverAfterDataNodes = RECOVER_AFTER_DATA_NODES_SETTING.get(this.settings);
        this.recoverAfterMasterNodes = RECOVER_AFTER_MASTER_NODES_SETTING.exists(this.settings) ? RECOVER_AFTER_MASTER_NODES_SETTING.get(this.settings).intValue() : settings.getAsInt("discovery.zen.minimum_master_nodes", -1).intValue();
        this.clusterService.addInitialStateBlock(STATE_NOT_RECOVERED_BLOCK);
    }

    @Override
    protected void doStart() {
        this.clusterService.addLast(this);
    }

    @Override
    protected void doStop() {
        this.clusterService.remove(this);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (this.lifecycle.stoppedOrClosed()) {
            return;
        }
        ClusterState state = event.state();
        if (!state.nodes().isLocalNodeElectedMaster()) {
            return;
        }
        if (!state.blocks().hasGlobalBlock(STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNodes nodes = state.nodes();
        if (state.nodes().getMasterNodeId() == null) {
            this.logger.debug("not recovering from gateway, no master elected yet");
        } else if (this.recoverAfterNodes != -1 && nodes.getMasterAndDataNodes().size() < this.recoverAfterNodes) {
            this.logger.debug("not recovering from gateway, nodes_size (data+master) [{}] < recover_after_nodes [{}]", (Object)nodes.getMasterAndDataNodes().size(), (Object)this.recoverAfterNodes);
        } else if (this.recoverAfterDataNodes != -1 && nodes.getDataNodes().size() < this.recoverAfterDataNodes) {
            this.logger.debug("not recovering from gateway, nodes_size (data) [{}] < recover_after_data_nodes [{}]", (Object)nodes.getDataNodes().size(), (Object)this.recoverAfterDataNodes);
        } else if (this.recoverAfterMasterNodes != -1 && nodes.getMasterNodes().size() < this.recoverAfterMasterNodes) {
            this.logger.debug("not recovering from gateway, nodes_size (master) [{}] < recover_after_master_nodes [{}]", (Object)nodes.getMasterNodes().size(), (Object)this.recoverAfterMasterNodes);
        } else {
            String reason;
            boolean enforceRecoverAfterTime;
            if (this.expectedNodes == -1 && this.expectedMasterNodes == -1 && this.expectedDataNodes == -1) {
                enforceRecoverAfterTime = true;
                reason = "recover_after_time was set to [" + this.recoverAfterTime + "]";
            } else {
                enforceRecoverAfterTime = false;
                reason = "";
                if (this.expectedNodes != -1 && nodes.getMasterAndDataNodes().size() < this.expectedNodes) {
                    enforceRecoverAfterTime = true;
                    reason = "expecting [" + this.expectedNodes + "] nodes, but only have [" + nodes.getMasterAndDataNodes().size() + "]";
                } else if (this.expectedDataNodes != -1 && nodes.getDataNodes().size() < this.expectedDataNodes) {
                    enforceRecoverAfterTime = true;
                    reason = "expecting [" + this.expectedDataNodes + "] data nodes, but only have [" + nodes.getDataNodes().size() + "]";
                } else if (this.expectedMasterNodes != -1 && nodes.getMasterNodes().size() < this.expectedMasterNodes) {
                    enforceRecoverAfterTime = true;
                    reason = "expecting [" + this.expectedMasterNodes + "] master nodes, but only have [" + nodes.getMasterNodes().size() + "]";
                }
            }
            this.performStateRecovery(enforceRecoverAfterTime, reason);
        }
    }

    private void performStateRecovery(boolean enforceRecoverAfterTime, String reason) {
        final GatewayRecoveryListener recoveryListener = new GatewayRecoveryListener();
        if (enforceRecoverAfterTime && this.recoverAfterTime != null) {
            if (this.scheduledRecovery.compareAndSet(false, true)) {
                this.logger.info("delaying initial state recovery for [{}]. {}", (Object)this.recoverAfterTime, (Object)reason);
                this.threadPool.schedule(this.recoverAfterTime, "generic", () -> {
                    if (this.recovered.compareAndSet(false, true)) {
                        this.logger.info("recover_after_time [{}] elapsed. performing state recovery...", (Object)this.recoverAfterTime);
                        this.gateway.performStateRecovery(recoveryListener);
                    }
                });
            }
        } else if (this.recovered.compareAndSet(false, true)) {
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    GatewayService.this.logger.warn("Recovery failed", (Throwable)e);
                    recoveryListener.onFailure("state recovery failed: " + e.getMessage());
                }

                @Override
                protected void doRun() throws Exception {
                    GatewayService.this.gateway.performStateRecovery(recoveryListener);
                }
            });
        }
    }

    public Gateway getGateway() {
        return this.gateway;
    }

    public TimeValue recoverAfterTime() {
        return this.recoverAfterTime;
    }

    class GatewayRecoveryListener
    implements Gateway.GatewayStateRecoveredListener {
        GatewayRecoveryListener() {
        }

        @Override
        public void onSuccess(final ClusterState recoveredState) {
            GatewayService.this.logger.trace("successful state recovery, importing cluster state...");
            GatewayService.this.clusterService.submitStateUpdateTask("local-gateway-elected-state", new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    assert (currentState.metaData().indices().isEmpty());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).blocks(recoveredState.blocks()).removeGlobalBlock(STATE_NOT_RECOVERED_BLOCK);
                    MetaData.Builder metaDataBuilder = MetaData.builder(recoveredState.metaData());
                    metaDataBuilder.generateClusterUuidIfNeeded();
                    if (MetaData.SETTING_READ_ONLY_SETTING.get(recoveredState.metaData().settings()).booleanValue() || MetaData.SETTING_READ_ONLY_SETTING.get(currentState.metaData().settings()).booleanValue()) {
                        blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
                    }
                    for (IndexMetaData indexMetaData : recoveredState.metaData()) {
                        metaDataBuilder.put(indexMetaData, false);
                        blocks.addBlocks(indexMetaData);
                    }
                    ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metaData(metaDataBuilder).build();
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable());
                    for (ObjectCursor cursor : updatedState.metaData().indices().values()) {
                        routingTableBuilder.addAsRecovery((IndexMetaData)cursor.value);
                    }
                    routingTableBuilder.version(0L);
                    updatedState = ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build();
                    return GatewayService.this.allocationService.reroute(updatedState, "state recovered");
                }

                @Override
                public void onFailure(String source, Exception e) {
                    GatewayService.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                    GatewayRecoveryListener.this.onFailure("failed to updated cluster state");
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    GatewayService.this.logger.info("recovered [{}] indices into cluster_state", (Object)newState.metaData().indices().size());
                }
            });
        }

        @Override
        public void onFailure(String message) {
            GatewayService.this.recovered.set(false);
            GatewayService.this.scheduledRecovery.set(false);
            GatewayService.this.logger.info("metadata state not restored, reason: {}", (Object)message);
        }
    }
}

