'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var cov_o4tfba3lv = function () {
  var path = '/Users/gajuskuizinas/Documents/dev/gajus/table/src/calculateCellHeight.js',
      hash = 'a65906da9699d691d072da9a76fc1ac18702e1f5',
      global = new Function('return this')(),
      gcv = '__coverage__',
      coverageData = {
    path: '/Users/gajuskuizinas/Documents/dev/gajus/table/src/calculateCellHeight.js',
    statementMap: {
      '0': {
        start: {
          line: 12,
          column: 2
        },
        end: {
          line: 14,
          column: 3
        }
      },
      '1': {
        start: {
          line: 13,
          column: 4
        },
        end: {
          line: 13,
          column: 47
        }
      },
      '2': {
        start: {
          line: 16,
          column: 2
        },
        end: {
          line: 18,
          column: 3
        }
      },
      '3': {
        start: {
          line: 17,
          column: 4
        },
        end: {
          line: 17,
          column: 56
        }
      },
      '4': {
        start: {
          line: 20,
          column: 2
        },
        end: {
          line: 22,
          column: 3
        }
      },
      '5': {
        start: {
          line: 21,
          column: 4
        },
        end: {
          line: 21,
          column: 60
        }
      },
      '6': {
        start: {
          line: 24,
          column: 2
        },
        end: {
          line: 26,
          column: 3
        }
      },
      '7': {
        start: {
          line: 25,
          column: 4
        },
        end: {
          line: 25,
          column: 47
        }
      },
      '8': {
        start: {
          line: 28,
          column: 2
        },
        end: {
          line: 28,
          column: 50
        }
      }
    },
    fnMap: {
      '0': {
        name: '(anonymous_0)',
        decl: {
          start: {
            line: 11,
            column: 15
          },
          end: {
            line: 11,
            column: 16
          }
        },
        loc: {
          start: {
            line: 11,
            column: 60
          },
          end: {
            line: 29,
            column: 1
          }
        }
      }
    },
    branchMap: {
      '0': {
        loc: {
          start: {
            line: 11,
            column: 36
          },
          end: {
            line: 11,
            column: 55
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 11,
            column: 50
          },
          end: {
            line: 11,
            column: 55
          }
        }]
      },
      '1': {
        loc: {
          start: {
            line: 12,
            column: 2
          },
          end: {
            line: 14,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 12,
            column: 2
          },
          end: {
            line: 14,
            column: 3
          }
        }, {
          start: {
            line: 12,
            column: 2
          },
          end: {
            line: 14,
            column: 3
          }
        }]
      },
      '2': {
        loc: {
          start: {
            line: 16,
            column: 2
          },
          end: {
            line: 18,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 16,
            column: 2
          },
          end: {
            line: 18,
            column: 3
          }
        }, {
          start: {
            line: 16,
            column: 2
          },
          end: {
            line: 18,
            column: 3
          }
        }]
      },
      '3': {
        loc: {
          start: {
            line: 20,
            column: 2
          },
          end: {
            line: 22,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 20,
            column: 2
          },
          end: {
            line: 22,
            column: 3
          }
        }, {
          start: {
            line: 20,
            column: 2
          },
          end: {
            line: 22,
            column: 3
          }
        }]
      },
      '4': {
        loc: {
          start: {
            line: 24,
            column: 2
          },
          end: {
            line: 26,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 24,
            column: 2
          },
          end: {
            line: 26,
            column: 3
          }
        }, {
          start: {
            line: 24,
            column: 2
          },
          end: {
            line: 26,
            column: 3
          }
        }]
      }
    },
    s: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0,
      '5': 0,
      '6': 0,
      '7': 0,
      '8': 0
    },
    f: {
      '0': 0
    },
    b: {
      '0': [0],
      '1': [0, 0],
      '2': [0, 0],
      '3': [0, 0],
      '4': [0, 0]
    }
  },
      coverage = global[gcv] || (global[gcv] = {});

  if (coverage[path] && coverage[path].hash === hash) {
    return coverage[path];
  }

  coverageData.hash = hash;
  return coverage[path] = coverageData;
}();

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _stringWidth = require('string-width');

var _stringWidth2 = _interopRequireDefault(_stringWidth);

var _wrapWord = require('./wrapWord');

var _wrapWord2 = _interopRequireDefault(_wrapWord);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @param {string} value
 * @param {number} columnWidth
 * @param {boolean} useWrapWord
 * @returns {number}
 */
exports.default = function (value, columnWidth) {
  let useWrapWord = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : (++cov_o4tfba3lv.b[0][0], false);
  ++cov_o4tfba3lv.f[0];
  ++cov_o4tfba3lv.s[0];

  if (!_lodash2.default.isString(value)) {
    ++cov_o4tfba3lv.b[1][0];
    ++cov_o4tfba3lv.s[1];

    throw new Error('Value must be a string.');
  } else {
    ++cov_o4tfba3lv.b[1][1];
  }

  ++cov_o4tfba3lv.s[2];
  if (!_lodash2.default.isInteger(columnWidth)) {
    ++cov_o4tfba3lv.b[2][0];
    ++cov_o4tfba3lv.s[3];

    throw new Error('Column width must be an integer.');
  } else {
    ++cov_o4tfba3lv.b[2][1];
  }

  ++cov_o4tfba3lv.s[4];
  if (columnWidth < 1) {
    ++cov_o4tfba3lv.b[3][0];
    ++cov_o4tfba3lv.s[5];

    throw new Error('Column width must be greater than 0.');
  } else {
    ++cov_o4tfba3lv.b[3][1];
  }

  ++cov_o4tfba3lv.s[6];
  if (useWrapWord) {
    ++cov_o4tfba3lv.b[4][0];
    ++cov_o4tfba3lv.s[7];

    return (0, _wrapWord2.default)(value, columnWidth).length;
  } else {
    ++cov_o4tfba3lv.b[4][1];
  }

  ++cov_o4tfba3lv.s[8];
  return _lodash2.default.ceil((0, _stringWidth2.default)(value) / columnWidth);
};

module.exports = exports['default'];