/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.internal.configurer.HierarchicalElementDeduplicator;
import org.gradle.plugins.ide.internal.configurer.NameDeduplicationAdapter;

public class IdeaNameDeduper {
    private static final Predicate<Project> HAS_IDEA_PLUGIN = new Predicate<Project>(){

        public boolean apply(Project project) {
            return IdeaNameDeduper.hasIdeaPlugin(project);
        }
    };
    private static final Function<Project, IdeaModule> GET_IDEA_MODULE = new Function<Project, IdeaModule>(){

        public IdeaModule apply(Project p) {
            return IdeaNameDeduper.getModule(p);
        }
    };

    public void configureRoot(Project rootProject) {
        Set projects = Sets.filter((Set)rootProject.getAllprojects(), HAS_IDEA_PLUGIN);
        Iterable ideaModules = Iterables.transform((Iterable)projects, GET_IDEA_MODULE);
        HierarchicalElementDeduplicator<IdeaModule> deduplicator = new HierarchicalElementDeduplicator<IdeaModule>(new IdeaDeduplicationAdapter());
        Map<IdeaModule, String> deduplicated = deduplicator.deduplicate(ideaModules);
        for (Map.Entry<IdeaModule, String> entry : deduplicated.entrySet()) {
            entry.getKey().setName(entry.getValue());
        }
    }

    private static boolean hasIdeaPlugin(Project project) {
        return project.getPlugins().hasPlugin(IdeaPlugin.class);
    }

    private static IdeaModule getModule(Project parent) {
        return ((IdeaModel)parent.getExtensions().getByType(IdeaModel.class)).getModule();
    }

    private static class IdeaDeduplicationAdapter
    implements NameDeduplicationAdapter<IdeaModule> {
        private IdeaDeduplicationAdapter() {
        }

        @Override
        public String getName(IdeaModule element) {
            return element.getName();
        }

        @Override
        public IdeaModule getParent(IdeaModule element) {
            Project parent = element.getProject().getParent();
            if (parent == null) {
                return null;
            }
            return IdeaNameDeduper.hasIdeaPlugin(parent) ? IdeaNameDeduper.getModule(parent) : null;
        }
    }
}

