/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.webpane.platform.Invoker;
import com.sun.webpane.sg.prism.PrismImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RTImage
extends PrismImage
implements ResourceFactoryListener {
    private RTTexture txt;
    private int width;
    private int height;
    private boolean listenerAdded = false;
    private ByteBuffer pixelBuffer;

    public RTImage(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    @Override
    public Image getImage() {
        return Image.fromByteBgraPreData(this.getPixelBuffer(), this.getWidth(), this.getHeight());
    }

    @Override
    public Graphics getGraphics() {
        return this.getTexture().createGraphics();
    }

    private RTTexture getTexture() {
        if (this.txt == null) {
            ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
            this.txt = resourceFactory.createRTTexture(this.width, this.height);
            if (!this.listenerAdded) {
                resourceFactory.addFactoryListener(this);
                this.listenerAdded = true;
            }
        }
        return this.txt;
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        graphics.drawTexture(this.getTexture(), n, n2, n3, n4, n5, n6, n7, n8);
    }

    @Override
    public void dispose() {
        Invoker.getInvoker().invokeOnRenderThread(new Runnable(){

            @Override
            public void run() {
                if (RTImage.this.txt != null) {
                    RTImage.this.txt.dispose();
                    RTImage.this.txt = null;
                }
            }
        });
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getPixelBuffer() {
        boolean bl = false;
        if (this.pixelBuffer == null) {
            this.pixelBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4);
            if (this.pixelBuffer != null) {
                this.pixelBuffer.order(ByteOrder.nativeOrder());
                bl = true;
            }
        }
        if (bl || this.isDirty()) {
            Invoker.getInvoker().runOnRenderThread(new Runnable(){

                @Override
                public void run() {
                    RTImage.this.flushRQ();
                    if (RTImage.this.txt != null && RTImage.this.pixelBuffer != null) {
                        PixelFormat pixelFormat = RTImage.this.txt.getPixelFormat();
                        if (pixelFormat != PixelFormat.INT_ARGB_PRE && pixelFormat != PixelFormat.BYTE_BGRA_PRE) {
                            throw new AssertionError((Object)("Unexpected pixel format: " + (Object)((Object)pixelFormat)));
                        }
                        RTImage.this.pixelBuffer.rewind();
                        int[] nArray = RTImage.this.txt.getPixels();
                        if (nArray != null) {
                            RTImage.this.pixelBuffer.asIntBuffer().put(nArray);
                        } else {
                            RTImage.this.txt.readPixels(RTImage.this.pixelBuffer);
                        }
                    }
                }
            });
        }
        return this.pixelBuffer;
    }

    @Override
    public void drawPixelBuffer() {
        Invoker.getInvoker().invokeOnRenderThread(new Runnable(){

            @Override
            public void run() {
                Graphics graphics = RTImage.this.getGraphics();
                if (graphics != null && RTImage.this.pixelBuffer != null) {
                    RTImage.this.pixelBuffer.rewind();
                    Image image = Image.fromByteBgraPreData(RTImage.this.pixelBuffer, RTImage.this.width, RTImage.this.height);
                    Texture texture = graphics.getResourceFactory().createTexture(image);
                    graphics.clear();
                    graphics.drawTexture(texture, 0.0f, 0.0f, RTImage.this.width, RTImage.this.height);
                    texture.dispose();
                }
            }
        });
    }

    @Override
    public void factoryReset() {
        if (this.txt != null) {
            this.txt.dispose();
            this.txt = null;
        }
    }

    @Override
    public void factoryReleased() {
    }
}

