/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.search.suggest.Suggest;

public class QuerySearchResult
extends QuerySearchResultProvider {
    private long id;
    private SearchShardTarget shardTarget;
    private int from;
    private int size;
    private TopDocs topDocs;
    private DocValueFormat[] sortValueFormats;
    private InternalAggregations aggregations;
    private List<SiblingPipelineAggregator> pipelineAggregators;
    private Suggest suggest;
    private boolean searchTimedOut;
    private Boolean terminatedEarly = null;
    private ProfileShardResult profileShardResults;

    public QuerySearchResult() {
    }

    public QuerySearchResult(long id, SearchShardTarget shardTarget) {
        this.id = id;
        this.shardTarget = shardTarget;
    }

    @Override
    public boolean includeFetch() {
        return false;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public void shardTarget(SearchShardTarget shardTarget) {
        this.shardTarget = shardTarget;
    }

    public void searchTimedOut(boolean searchTimedOut) {
        this.searchTimedOut = searchTimedOut;
    }

    public boolean searchTimedOut() {
        return this.searchTimedOut;
    }

    public void terminatedEarly(boolean terminatedEarly) {
        this.terminatedEarly = terminatedEarly;
    }

    public Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public TopDocs topDocs() {
        return this.topDocs;
    }

    public void topDocs(TopDocs topDocs, DocValueFormat[] sortValueFormats) {
        int numFields;
        this.topDocs = topDocs;
        if (topDocs.scoreDocs.length > 0 && topDocs.scoreDocs[0] instanceof FieldDoc && (numFields = ((FieldDoc)topDocs.scoreDocs[0]).fields.length) != sortValueFormats.length) {
            throw new IllegalArgumentException("The number of sort fields does not match: " + numFields + " != " + sortValueFormats.length);
        }
        this.sortValueFormats = sortValueFormats;
    }

    public DocValueFormat[] sortValueFormats() {
        return this.sortValueFormats;
    }

    public Aggregations aggregations() {
        return this.aggregations;
    }

    public void aggregations(InternalAggregations aggregations) {
        this.aggregations = aggregations;
    }

    @Nullable
    public ProfileShardResult profileResults() {
        return this.profileShardResults;
    }

    public void profileResults(ProfileShardResult shardResults) {
        this.profileShardResults = shardResults;
    }

    public List<SiblingPipelineAggregator> pipelineAggregators() {
        return this.pipelineAggregators;
    }

    public void pipelineAggregators(List<SiblingPipelineAggregator> pipelineAggregators) {
        this.pipelineAggregators = pipelineAggregators;
    }

    public Suggest suggest() {
        return this.suggest;
    }

    public void suggest(Suggest suggest) {
        this.suggest = suggest;
    }

    public int from() {
        return this.from;
    }

    public QuerySearchResult from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public QuerySearchResult size(int size) {
        this.size = size;
        return this;
    }

    public boolean hasHits() {
        return this.topDocs != null && this.topDocs.scoreDocs.length > 0 || this.suggest != null && this.suggest.hasScoreDocs();
    }

    public static QuerySearchResult readQuerySearchResult(StreamInput in) throws IOException {
        QuerySearchResult result = new QuerySearchResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        long id = in.readLong();
        this.readFromWithId(id, in);
    }

    public void readFromWithId(long id, StreamInput in) throws IOException {
        this.id = id;
        this.from = in.readVInt();
        this.size = in.readVInt();
        int numSortFieldsPlus1 = in.readVInt();
        if (numSortFieldsPlus1 == 0) {
            this.sortValueFormats = null;
        } else {
            this.sortValueFormats = new DocValueFormat[numSortFieldsPlus1 - 1];
            for (int i = 0; i < this.sortValueFormats.length; ++i) {
                this.sortValueFormats[i] = in.readNamedWriteable(DocValueFormat.class);
            }
        }
        this.topDocs = Lucene.readTopDocs(in);
        if (in.readBoolean()) {
            this.aggregations = InternalAggregations.readAggregations(in);
        }
        this.pipelineAggregators = in.readNamedWriteableList(PipelineAggregator.class).stream().map(a -> (SiblingPipelineAggregator)a).collect(Collectors.toList());
        if (in.readBoolean()) {
            this.suggest = Suggest.readSuggest(in);
        }
        this.searchTimedOut = in.readBoolean();
        this.terminatedEarly = in.readOptionalBoolean();
        this.profileShardResults = in.readOptionalWriteable(ProfileShardResult::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        this.writeToNoId(out);
    }

    public void writeToNoId(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        if (this.sortValueFormats == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(1 + this.sortValueFormats.length);
            for (int i = 0; i < this.sortValueFormats.length; ++i) {
                out.writeNamedWriteable(this.sortValueFormats[i]);
            }
        }
        Lucene.writeTopDocs(out, this.topDocs);
        if (this.aggregations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.aggregations.writeTo(out);
        }
        out.writeNamedWriteableList(this.pipelineAggregators == null ? Collections.emptyList() : this.pipelineAggregators);
        if (this.suggest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.suggest.writeTo(out);
        }
        out.writeBoolean(this.searchTimedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        out.writeOptionalWriteable(this.profileShardResults);
    }
}

