'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var cov_3c92k3xh1 = function () {
  var path = '/Users/gajuskuizinas/Documents/dev/gajus/table/src/makeStreamConfig.js',
      hash = 'a51cd8d347bf6e0ccdfb4ff4cb6c763d2f8b1f98',
      global = new Function('return this')(),
      gcv = '__coverage__',
      coverageData = {
    path: '/Users/gajuskuizinas/Documents/dev/gajus/table/src/makeStreamConfig.js',
    statementMap: {
      '0': {
        start: {
          line: 11,
          column: 19
        },
        end: {
          line: 13,
          column: 1
        }
      },
      '1': {
        start: {
          line: 12,
          column: 2
        },
        end: {
          line: 12,
          column: 64
        }
      },
      '2': {
        start: {
          line: 24,
          column: 20
        },
        end: {
          line: 40,
          column: 1
        }
      },
      '3': {
        start: {
          line: 25,
          column: 2
        },
        end: {
          line: 37,
          column: 5
        }
      },
      '4': {
        start: {
          line: 26,
          column: 4
        },
        end: {
          line: 28,
          column: 5
        }
      },
      '5': {
        start: {
          line: 27,
          column: 6
        },
        end: {
          line: 27,
          column: 26
        }
      },
      '6': {
        start: {
          line: 30,
          column: 4
        },
        end: {
          line: 36,
          column: 38
        }
      },
      '7': {
        start: {
          line: 39,
          column: 2
        },
        end: {
          line: 39,
          column: 17
        }
      },
      '8': {
        start: {
          line: 67,
          column: 2
        },
        end: {
          line: 67,
          column: 50
        }
      },
      '9': {
        start: {
          line: 69,
          column: 17
        },
        end: {
          line: 69,
          column: 40
        }
      },
      '10': {
        start: {
          line: 71,
          column: 2
        },
        end: {
          line: 73,
          column: 3
        }
      },
      '11': {
        start: {
          line: 72,
          column: 4
        },
        end: {
          line: 72,
          column: 87
        }
      },
      '12': {
        start: {
          line: 75,
          column: 2
        },
        end: {
          line: 77,
          column: 3
        }
      },
      '13': {
        start: {
          line: 76,
          column: 4
        },
        end: {
          line: 76,
          column: 56
        }
      },
      '14': {
        start: {
          line: 79,
          column: 2
        },
        end: {
          line: 79,
          column: 44
        }
      },
      '15': {
        start: {
          line: 80,
          column: 2
        },
        end: {
          line: 80,
          column: 89
        }
      },
      '16': {
        start: {
          line: 82,
          column: 2
        },
        end: {
          line: 82,
          column: 16
        }
      }
    },
    fnMap: {
      '0': {
        name: '(anonymous_0)',
        decl: {
          start: {
            line: 11,
            column: 19
          },
          end: {
            line: 11,
            column: 20
          }
        },
        loc: {
          start: {
            line: 11,
            column: 36
          },
          end: {
            line: 13,
            column: 1
          }
        }
      },
      '1': {
        name: '(anonymous_1)',
        decl: {
          start: {
            line: 24,
            column: 20
          },
          end: {
            line: 24,
            column: 21
          }
        },
        loc: {
          start: {
            line: 24,
            column: 71
          },
          end: {
            line: 40,
            column: 1
          }
        }
      },
      '2': {
        name: '(anonymous_2)',
        decl: {
          start: {
            line: 25,
            column: 23
          },
          end: {
            line: 25,
            column: 24
          }
        },
        loc: {
          start: {
            line: 25,
            column: 34
          },
          end: {
            line: 37,
            column: 3
          }
        }
      },
      '3': {
        name: '(anonymous_3)',
        decl: {
          start: {
            line: 66,
            column: 15
          },
          end: {
            line: 66,
            column: 16
          }
        },
        loc: {
          start: {
            line: 66,
            column: 36
          },
          end: {
            line: 83,
            column: 1
          }
        }
      }
    },
    branchMap: {
      '0': {
        loc: {
          start: {
            line: 11,
            column: 20
          },
          end: {
            line: 11,
            column: 31
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 11,
            column: 29
          },
          end: {
            line: 11,
            column: 31
          }
        }]
      },
      '1': {
        loc: {
          start: {
            line: 24,
            column: 34
          },
          end: {
            line: 24,
            column: 46
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 24,
            column: 44
          },
          end: {
            line: 24,
            column: 46
          }
        }]
      },
      '2': {
        loc: {
          start: {
            line: 24,
            column: 48
          },
          end: {
            line: 24,
            column: 66
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 24,
            column: 64
          },
          end: {
            line: 24,
            column: 66
          }
        }]
      },
      '3': {
        loc: {
          start: {
            line: 26,
            column: 4
          },
          end: {
            line: 28,
            column: 5
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 26,
            column: 4
          },
          end: {
            line: 28,
            column: 5
          }
        }, {
          start: {
            line: 26,
            column: 4
          },
          end: {
            line: 28,
            column: 5
          }
        }]
      },
      '4': {
        loc: {
          start: {
            line: 66,
            column: 16
          },
          end: {
            line: 66,
            column: 31
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 66,
            column: 29
          },
          end: {
            line: 66,
            column: 31
          }
        }]
      },
      '5': {
        loc: {
          start: {
            line: 71,
            column: 2
          },
          end: {
            line: 73,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 71,
            column: 2
          },
          end: {
            line: 73,
            column: 3
          }
        }, {
          start: {
            line: 71,
            column: 2
          },
          end: {
            line: 73,
            column: 3
          }
        }]
      },
      '6': {
        loc: {
          start: {
            line: 71,
            column: 6
          },
          end: {
            line: 71,
            column: 58
          }
        },
        type: 'binary-expr',
        locations: [{
          start: {
            line: 71,
            column: 6
          },
          end: {
            line: 71,
            column: 27
          }
        }, {
          start: {
            line: 71,
            column: 31
          },
          end: {
            line: 71,
            column: 58
          }
        }]
      },
      '7': {
        loc: {
          start: {
            line: 75,
            column: 2
          },
          end: {
            line: 77,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 75,
            column: 2
          },
          end: {
            line: 77,
            column: 3
          }
        }, {
          start: {
            line: 75,
            column: 2
          },
          end: {
            line: 77,
            column: 3
          }
        }]
      }
    },
    s: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0,
      '5': 0,
      '6': 0,
      '7': 0,
      '8': 0,
      '9': 0,
      '10': 0,
      '11': 0,
      '12': 0,
      '13': 0,
      '14': 0,
      '15': 0,
      '16': 0
    },
    f: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0
    },
    b: {
      '0': [0],
      '1': [0],
      '2': [0],
      '3': [0, 0],
      '4': [0],
      '5': [0, 0],
      '6': [0, 0],
      '7': [0, 0]
    }
  },
      coverage = global[gcv] || (global[gcv] = {});

  if (coverage[path] && coverage[path].hash === hash) {
    return coverage[path];
  }

  coverageData.hash = hash;
  return coverage[path] = coverageData;
}();

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _getBorderCharacters = require('./getBorderCharacters');

var _getBorderCharacters2 = _interopRequireDefault(_getBorderCharacters);

var _validateConfig = require('./validateConfig');

var _validateConfig2 = _interopRequireDefault(_validateConfig);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Merges user provided border characters with the default border ("honeywell") characters.
 *
 * @param {Object} border
 * @returns {Object}
 */
const makeBorder = (++cov_3c92k3xh1.s[0], function () {
  let border = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : (++cov_3c92k3xh1.b[0][0], {});
  ++cov_3c92k3xh1.f[0];
  ++cov_3c92k3xh1.s[1];

  return _lodash2.default.assign({}, (0, _getBorderCharacters2.default)('honeywell'), border);
});

/**
 * Creates a configuration for every column using default
 * values for the missing configuration properties.
 *
 * @param {number} columnCount
 * @param {Object} columns
 * @param {Object} columnDefault
 * @returns {Object}
 */
const makeColumns = (++cov_3c92k3xh1.s[2], function (columnCount) {
  let columns = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (++cov_3c92k3xh1.b[1][0], {});
  let columnDefault = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : (++cov_3c92k3xh1.b[2][0], {});
  ++cov_3c92k3xh1.f[1];
  ++cov_3c92k3xh1.s[3];

  _lodash2.default.times(columnCount, index => {
    ++cov_3c92k3xh1.f[2];
    ++cov_3c92k3xh1.s[4];

    if (_lodash2.default.isUndefined(columns[index])) {
      ++cov_3c92k3xh1.b[3][0];
      ++cov_3c92k3xh1.s[5];

      columns[index] = {};
    } else {
      ++cov_3c92k3xh1.b[3][1];
    }

    ++cov_3c92k3xh1.s[6];
    columns[index] = _lodash2.default.assign({
      alignment: 'left',
      paddingLeft: 1,
      paddingRight: 1,
      truncate: Infinity,
      wrapWord: false
    }, columnDefault, columns[index]);
  });

  ++cov_3c92k3xh1.s[7];
  return columns;
});

/**
 * @typedef {Object} columnConfig
 * @property {string} alignment
 * @property {number} width
 * @property {number} truncate
 * @property {number} paddingLeft
 * @property {number} paddingRight
 */

/**
 * @typedef {Object} streamConfig
 * @property {columnConfig} columnDefault
 * @property {Object} border
 * @property {columnConfig[]}
 * @property {number} columnCount Number of columns in the table (required).
 */

/**
 * Makes a new configuration object out of the userConfig object
 * using default values for the missing configuration properties.
 *
 * @param {streamConfig} userConfig
 * @returns {Object}
 */

exports.default = function () {
  let userConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : (++cov_3c92k3xh1.b[4][0], {});
  ++cov_3c92k3xh1.f[3];
  ++cov_3c92k3xh1.s[8];

  (0, _validateConfig2.default)('streamConfig.json', userConfig);

  const config = (++cov_3c92k3xh1.s[9], _lodash2.default.cloneDeep(userConfig));

  ++cov_3c92k3xh1.s[10];
  if ((++cov_3c92k3xh1.b[6][0], !config.columnDefault) || (++cov_3c92k3xh1.b[6][1], !config.columnDefault.width)) {
    ++cov_3c92k3xh1.b[5][0];
    ++cov_3c92k3xh1.s[11];

    throw new Error('Must provide config.columnDefault.width when creating a stream.');
  } else {
    ++cov_3c92k3xh1.b[5][1];
  }

  ++cov_3c92k3xh1.s[12];
  if (!config.columnCount) {
    ++cov_3c92k3xh1.b[7][0];
    ++cov_3c92k3xh1.s[13];

    throw new Error('Must provide config.columnCount.');
  } else {
    ++cov_3c92k3xh1.b[7][1];
  }

  ++cov_3c92k3xh1.s[14];
  config.border = makeBorder(config.border);
  ++cov_3c92k3xh1.s[15];
  config.columns = makeColumns(config.columnCount, config.columns, config.columnDefault);

  ++cov_3c92k3xh1.s[16];
  return config;
};

module.exports = exports['default'];