/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.snappy;

import java.lang.ref.SoftReference;

class BufferRecycler {
    protected static final ThreadLocal<SoftReference<BufferRecycler>> recyclerRef = new ThreadLocal();
    private short[] encodingHash;

    BufferRecycler() {
    }

    public static BufferRecycler instance() {
        SoftReference<BufferRecycler> ref = recyclerRef.get();
        BufferRecycler bufferRecycler = ref == null ? null : ref.get();
        if (bufferRecycler == null) {
            bufferRecycler = new BufferRecycler();
            recyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
        }
        return bufferRecycler;
    }

    public short[] allocEncodingHash(int suggestedSize) {
        short[] buf = this.encodingHash;
        if (buf == null || buf.length < suggestedSize) {
            buf = new short[suggestedSize];
        } else {
            this.encodingHash = null;
        }
        return buf;
    }

    public void releaseEncodingHash(short[] buffer) {
        if (this.encodingHash == null || buffer != null && buffer.length > this.encodingHash.length) {
            this.encodingHash = buffer;
        }
    }
}

