/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.parsing.KotlinParsing;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilderImpl;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;

public class KotlinParser
implements PsiParser {
    private final KotlinScriptDefinitionProvider scriptDefinitionProvider;

    public KotlinParser(Project project) {
        this.scriptDefinitionProvider = KotlinScriptDefinitionProvider.getInstance(project);
    }

    @Override
    @NotNull
    public ASTNode parse(@NotNull IElementType iElementType, @NotNull PsiBuilder psiBuilder) {
        if (iElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iElementType", "org/jetbrains/kotlin/parsing/KotlinParser", "parse"));
        }
        if (psiBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiBuilder", "org/jetbrains/kotlin/parsing/KotlinParser", "parse"));
        }
        throw new IllegalStateException("use another parse");
    }

    @NotNull
    public ASTNode parse(IElementType iElementType, PsiBuilder psiBuilder, PsiFile psiFile) {
        KotlinParsing ktParsing = KotlinParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        if (this.scriptDefinitionProvider != null && this.scriptDefinitionProvider.isScript(psiFile) || psiFile.getName().endsWith(".kts")) {
            ktParsing.parseScript();
        } else {
            ktParsing.parseFile();
        }
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParser", "parse"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode parseTypeCodeFragment(PsiBuilder psiBuilder) {
        KotlinParsing ktParsing = KotlinParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        ktParsing.parseTypeCodeFragment();
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParser", "parseTypeCodeFragment"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode parseExpressionCodeFragment(PsiBuilder psiBuilder) {
        KotlinParsing ktParsing = KotlinParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        ktParsing.parseExpressionCodeFragment();
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParser", "parseExpressionCodeFragment"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode parseBlockCodeFragment(PsiBuilder psiBuilder) {
        KotlinParsing ktParsing = KotlinParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        ktParsing.parseBlockCodeFragment();
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParser", "parseBlockCodeFragment"));
        }
        return aSTNode;
    }
}

