/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.stats;

import com.netflix.servo.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class StatsBuffer {
    private int count;
    private double mean;
    private double sumSquares;
    private double variance;
    private double stddev;
    private long min;
    private long max;
    private long total;
    private double[] percentiles;
    private double[] percentileValues;
    private final int size;
    private final long[] values;
    private AtomicBoolean statsComputed = new AtomicBoolean(false);

    public StatsBuffer(int size, double[] percentiles) {
        Preconditions.checkArgument(size > 0, "Size of the buffer must be greater than 0");
        Preconditions.checkArgument(percentiles != null, "Percents array must be non-null. Pass a 0-sized array if you don't want any percentileValues to be computed.");
        Preconditions.checkArgument(StatsBuffer.validPercentiles(percentiles), "All percentiles should be in the interval (0.0, 100.0]");
        this.values = new long[size];
        this.size = size;
        this.percentiles = Arrays.copyOf(percentiles, percentiles.length);
        this.percentileValues = new double[percentiles.length];
        this.reset();
    }

    private static boolean validPercentiles(double[] percentiles) {
        for (double percentile : percentiles) {
            if (!(percentile <= 0.0) && !(percentile > 100.0)) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.statsComputed.set(false);
        this.count = 0;
        this.total = 0L;
        this.mean = 0.0;
        this.variance = 0.0;
        this.stddev = 0.0;
        this.min = 0L;
        this.max = 0L;
        this.sumSquares = 0.0;
        for (int i = 0; i < this.percentileValues.length; ++i) {
            this.percentileValues[i] = 0.0;
        }
    }

    public void record(long n) {
        this.values[this.count++ % this.size] = n;
        this.total += n;
        this.sumSquares += (double)(n * n);
    }

    public void computeStats() {
        if (this.statsComputed.getAndSet(true)) {
            return;
        }
        if (this.count == 0) {
            return;
        }
        int curSize = Math.min(this.count, this.size);
        Arrays.sort(this.values, 0, curSize);
        this.min = this.values[0];
        this.max = this.values[curSize - 1];
        this.mean = (double)this.total / (double)this.count;
        this.variance = this.sumSquares / (double)curSize - this.mean * this.mean;
        this.stddev = Math.sqrt(this.variance);
        this.computePercentiles(curSize);
    }

    private void computePercentiles(int curSize) {
        for (int i = 0; i < this.percentiles.length; ++i) {
            this.percentileValues[i] = this.calcPercentile(curSize, this.percentiles[i]);
        }
    }

    private double calcPercentile(int curSize, double percent) {
        if (curSize == 0) {
            return 0.0;
        }
        if (curSize == 1) {
            return this.values[0];
        }
        double rank = percent * (double)curSize / 100.0;
        int ir = (int)Math.floor(rank);
        int irNext = ir + 1;
        double fr = rank - (double)ir;
        if (irNext >= curSize) {
            return this.values[curSize - 1];
        }
        if (fr == 0.0) {
            return this.values[ir];
        }
        double lower = this.values[ir];
        double upper = this.values[irNext];
        return fr * (upper - lower) + lower;
    }

    public int getCount() {
        return this.count;
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getStdDev() {
        return this.stddev;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getTotalTime() {
        return this.total;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"}, justification="Performance critical code. Users treat it as read-only")
    public double[] getPercentileValues() {
        return this.percentileValues;
    }

    public double[] getPercentiles() {
        return Arrays.copyOf(this.percentiles, this.percentiles.length);
    }
}

