/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;

public class KeyProviderUtil {
    public static FileKeyProvider.Format detectKeyFileFormat(File location) throws IOException {
        return KeyProviderUtil.detectKeyFileFormat(new FileReader(location), new File(location + ".pub").exists());
    }

    public static FileKeyProvider.Format detectKeyFileFormat(String privateKey, boolean separatePubKey) throws IOException {
        return KeyProviderUtil.detectKeyFileFormat(new StringReader(privateKey), separatePubKey);
    }

    private static FileKeyProvider.Format detectKeyFileFormat(Reader privateKey, boolean separatePubKey) throws IOException {
        BufferedReader br = new BufferedReader(privateKey);
        String firstLine = br.readLine();
        IOUtils.closeQuietly(br);
        if (firstLine == null) {
            throw new IOException("Empty file");
        }
        if (firstLine.startsWith("-----BEGIN") && firstLine.endsWith("PRIVATE KEY-----")) {
            if (separatePubKey) {
                return FileKeyProvider.Format.OpenSSH;
            }
            return FileKeyProvider.Format.PKCS8;
        }
        return FileKeyProvider.Format.Unknown;
    }
}

