/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jcp.xml.dsig.internal.dom.ApacheData;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMTransform;
import org.jcp.xml.dsig.internal.dom.DOMURIDereferencer;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.jcp.xml.dsig.internal.dom.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMRetrievalMethod
extends DOMStructure
implements RetrievalMethod,
DOMURIReference {
    private final List transforms;
    private String uri;
    private String type;
    private Attr here;

    public DOMRetrievalMethod(String uri, String type, List transforms) {
        if (uri == null) {
            throw new NullPointerException("uri cannot be null");
        }
        if (transforms == null || transforms.isEmpty()) {
            this.transforms = Collections.EMPTY_LIST;
        } else {
            ArrayList transformsCopy = new ArrayList(transforms);
            int size = transformsCopy.size();
            for (int i = 0; i < size; ++i) {
                if (transformsCopy.get(i) instanceof Transform) continue;
                throw new ClassCastException("transforms[" + i + "] is not a valid type");
            }
            this.transforms = Collections.unmodifiableList(transformsCopy);
        }
        this.uri = uri;
        if (uri != null && !uri.equals("")) {
            try {
                new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this.type = type;
    }

    public DOMRetrievalMethod(Element rmElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        this.uri = DOMUtils.getAttributeValue(rmElem, "URI");
        this.type = DOMUtils.getAttributeValue(rmElem, "Type");
        this.here = rmElem.getAttributeNodeNS(null, "URI");
        boolean secVal = Utils.secureValidation(context);
        ArrayList<DOMTransform> transforms = new ArrayList<DOMTransform>();
        Element transformsElem = DOMUtils.getFirstChildElement(rmElem);
        int transformCount = 0;
        if (transformsElem != null) {
            Element transformElem = DOMUtils.getFirstChildElement(transformsElem);
            while (transformElem != null) {
                transforms.add(new DOMTransform(transformElem, context, provider));
                transformElem = DOMUtils.getNextSiblingElement(transformElem);
                if (!secVal || ++transformCount <= 5) continue;
                String error = "A maxiumum of 5 transforms per Reference are allowed with secure validation";
                throw new MarshalException(error);
            }
        }
        this.transforms = transforms.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(transforms);
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List getTransforms() {
        return this.transforms;
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element rmElem = DOMUtils.createElement(ownerDoc, "RetrievalMethod", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttribute(rmElem, "URI", this.uri);
        DOMUtils.setAttribute(rmElem, "Type", this.type);
        if (!this.transforms.isEmpty()) {
            Element transformsElem = DOMUtils.createElement(ownerDoc, "Transforms", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
            rmElem.appendChild(transformsElem);
            int size = this.transforms.size();
            for (int i = 0; i < size; ++i) {
                ((DOMTransform)this.transforms.get(i)).marshal(transformsElem, dsPrefix, context);
            }
        }
        parent.appendChild(rmElem);
        this.here = rmElem.getAttributeNodeNS(null, "URI");
    }

    @Override
    public Node getHere() {
        return this.here;
    }

    @Override
    public Data dereference(XMLCryptoContext context) throws URIReferenceException {
        Node root;
        NodeSetData nsd;
        Iterator i;
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        URIDereferencer deref = context.getURIDereferencer();
        if (deref == null) {
            deref = DOMURIDereferencer.INSTANCE;
        }
        Data data = deref.dereference(this, context);
        try {
            int size = this.transforms.size();
            for (int i2 = 0; i2 < size; ++i2) {
                Transform transform = (Transform)this.transforms.get(i2);
                data = ((DOMTransform)transform).transform(data, context);
            }
        }
        catch (Exception e) {
            throw new URIReferenceException(e);
        }
        if (data instanceof NodeSetData && Utils.secureValidation(context) && (i = (nsd = (NodeSetData)data).iterator()).hasNext() && "RetrievalMethod".equals((root = (Node)i.next()).getLocalName())) {
            throw new URIReferenceException("It is forbidden to have one RetrievalMethod point to another when secure validation is enabled");
        }
        return data;
    }

    public XMLStructure dereferenceAsXMLStructure(XMLCryptoContext context) throws URIReferenceException {
        try {
            ApacheData data = (ApacheData)this.dereference(context);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(data.getXMLSignatureInput().getBytes()));
            Element kiElem = doc.getDocumentElement();
            if (kiElem.getLocalName().equals("X509Data")) {
                return new DOMX509Data(kiElem);
            }
            return null;
        }
        catch (Exception e) {
            throw new URIReferenceException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RetrievalMethod)) {
            return false;
        }
        RetrievalMethod orm = (RetrievalMethod)obj;
        boolean typesEqual = this.type == null ? orm.getType() == null : this.type.equals(orm.getType());
        return this.uri.equals(orm.getURI()) && this.transforms.equals(orm.getTransforms()) && typesEqual;
    }
}

