/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    int imageHandle;
    int tooltipsHandle;
    ImageList imageList;
    Image highlightImage;

    public TrayItem(Tray tray, int n) {
        super(tray, n);
        this.parent = tray;
        this.createWidget(tray.getItemCount());
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.parent.createItem(this, n);
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.handle = OS.gtk_status_icon_new();
        if (this.handle == 0) {
            this.error(2);
        }
        this.imageHandle = OS.gtk_image_new();
        OS.gtk_status_icon_set_visible(this.handle, true);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.imageHandle);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Image getHighlightImage() {
        this.checkWidget();
        return this.highlightImage;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    int gtk_activate(int n) {
        this.sendSelectionEvent(13);
        int n2 = OS.gdk_event_peek();
        if (n2 != 0) {
            int n3 = OS.GDK_EVENT_TYPE(n2);
            int n4 = OS.gtk_get_current_event();
            int n5 = 0;
            if (n4 != 0) {
                n5 = OS.GDK_EVENT_TYPE(n4);
                OS.gdk_event_free(n4);
            }
            OS.gdk_event_free(n2);
            if (n5 == 4 && n3 == 5) {
                this.sendSelectionEvent(14);
            }
        }
        return 0;
    }

    @Override
    int gtk_button_press_event(int n, int n2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        if (gdkEventButton.type == 6) {
            return 0;
        }
        if (gdkEventButton.button == 3 && gdkEventButton.type == 4) {
            this.sendEvent(35);
            return 0;
        }
        if (gdkEventButton.type == 5) {
            this.sendSelectionEvent(14);
        } else {
            this.sendSelectionEvent(13);
        }
        return 0;
    }

    @Override
    int gtk_size_allocate(int n, int n2) {
        if (this.image != null && this.image.mask != 0 && OS.gdk_drawable_get_depth(this.image.mask) == 1) {
            int n3;
            GtkAllocation gtkAllocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(n, gtkAllocation);
            int n4 = (int)Math.floor((double)gtkAllocation.x + (double)(gtkAllocation.width - OS.GTK_WIDGET_REQUISITION_WIDTH(n)) * 0.5 + 0.5);
            int n5 = (int)Math.floor((double)gtkAllocation.y + (double)(gtkAllocation.height - OS.GTK_WIDGET_REQUISITION_HEIGHT(n)) * 0.5 + 0.5);
            Rectangle rectangle = this.image.getBoundsInPixels();
            int n6 = OS.gdk_drawable_get_image(this.image.mask, 0, 0, rectangle.width, rectangle.height);
            if (n6 == 0) {
                this.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, n6);
            byte[] byArray = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(byArray, gdkImage.mem, byArray.length);
            OS.g_object_unref(n6);
            Region region = new Region(this.display);
            for (n3 = 0; n3 < rectangle.height; ++n3) {
                for (int i = 0; i < rectangle.width; ++i) {
                    int n7 = n3 * gdkImage.bpl + (i >> 3);
                    int n8 = byArray[n7] & 0xFF;
                    int n9 = 1 << (i & 7);
                    if ((n8 & n9) == 0) continue;
                    Rectangle rectangle2 = DPIUtil.autoScaleDown(new Rectangle(n4 + i, n5 + n3, 1, 1));
                    region.add(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            }
            OS.gtk_widget_realize(this.handle);
            n3 = this.gtk_widget_get_window(this.handle);
            OS.gdk_window_shape_combine_region(n3, region.handle, 0, 0);
            region.dispose();
        }
        return 0;
    }

    @Override
    int gtk_status_icon_popup_menu(int n, int n2, int n3) {
        Display display = this.display;
        display.currentTrayItem = this;
        this.sendEvent(35);
        if (!this.isDisposed()) {
            display.runPopups();
        }
        display.currentTrayItem = null;
        return 0;
    }

    @Override
    void hookEvents() {
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.popup_menu, this.display.getClosure(63), false);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.gtk_status_icon_get_visible(this.handle);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.imageHandle, this);
    }

    @Override
    void releaseHandle() {
        if (this.handle != 0) {
            OS.g_object_unref(this.handle);
        }
        this.imageHandle = 0;
        this.handle = 0;
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.tooltipsHandle != 0) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.toolTipText = null;
        this.highlightImage = null;
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setHighlightImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.highlightImage = image;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            int n;
            if (this.imageList == null) {
                this.imageList = new ImageList();
            }
            if ((n = this.imageList.indexOf(image)) == -1) {
                n = this.imageList.add(image);
            } else {
                this.imageList.put(n, image);
            }
            int n2 = this.imageList.getPixbuf(n);
            OS.gtk_status_icon_set_from_pixbuf(this.handle, n2);
            OS.gtk_status_icon_set_visible(this.handle, true);
        } else {
            OS.gtk_widget_set_size_request(this.handle, 1, 1);
            OS.gtk_status_icon_set_from_pixbuf(this.handle, 0);
            OS.gtk_status_icon_set_visible(this.handle, false);
        }
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip toolTip2 = this.toolTip;
        ToolTip toolTip3 = toolTip;
        if (toolTip2 != null) {
            toolTip2.item = null;
        }
        this.toolTip = toolTip3;
        if (toolTip3 != null) {
            toolTip3.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        byte[] byArray = null;
        if (string != null && string.length() > 0) {
            byArray = Converter.wcsToMbcs(null, string, true);
        }
        OS.gtk_status_icon_set_tooltip(this.handle, byArray);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (OS.gtk_status_icon_get_visible(this.handle) == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.gtk_status_icon_set_visible(this.handle, bl);
        } else {
            OS.gtk_status_icon_set_visible(this.handle, bl);
            this.sendEvent(23);
        }
    }
}

