/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.credentials.AwsCredentials;
import org.gradle.authentication.Authentication;
import org.gradle.internal.authentication.AllSchemesAuthentication;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transport.aws.s3.S3Client;
import org.gradle.internal.resource.transport.aws.s3.S3ConnectionProperties;
import org.gradle.internal.resource.transport.aws.s3.S3ResourceConnector;

public class S3ConnectorFactory
implements ResourceConnectorFactory {
    public Set<String> getSupportedProtocols() {
        return Collections.singleton("s3");
    }

    public Set<Class<? extends Authentication>> getSupportedAuthentication() {
        HashSet<Class<? extends Authentication>> supported = new HashSet<Class<? extends Authentication>>();
        supported.add(AllSchemesAuthentication.class);
        return supported;
    }

    public ExternalResourceConnector createResourceConnector(ResourceConnectorSpecification connectionDetails) {
        AwsCredentials awsCredentials = (AwsCredentials)connectionDetails.getCredentials(AwsCredentials.class);
        if (awsCredentials == null) {
            throw new IllegalArgumentException("AwsCredentials must be set for S3 backed repository.");
        }
        return new S3ResourceConnector(new S3Client(awsCredentials, new S3ConnectionProperties()));
    }
}

