/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.uno;

import com.sun.star.uno.Any;
import com.sun.star.uno.Enum;
import com.sun.star.uno.Exception;
import com.sun.star.uno.ITypeDescription;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XInterface;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type {
    private static final String TYPE_NAME_VOID = "void";
    private static final String TYPE_NAME_BOOLEAN = "boolean";
    private static final String TYPE_NAME_BYTE = "byte";
    private static final String TYPE_NAME_SHORT = "short";
    private static final String TYPE_NAME_UNSIGNED_SHORT = "unsigned short";
    private static final String TYPE_NAME_LONG = "long";
    private static final String TYPE_NAME_UNSIGNED_LONG = "unsigned long";
    private static final String TYPE_NAME_HYPER = "hyper";
    private static final String TYPE_NAME_UNSIGNED_HYPER = "unsigned hyper";
    private static final String TYPE_NAME_FLOAT = "float";
    private static final String TYPE_NAME_DOUBLE = "double";
    private static final String TYPE_NAME_CHAR = "char";
    private static final String TYPE_NAME_STRING = "string";
    private static final String TYPE_NAME_TYPE = "type";
    private static final String TYPE_NAME_ANY = "any";
    private static final String[] __typeClassToTypeName = new String[]{"void", "char", "boolean", "byte", "short", "unsigned short", "long", "unsigned long", "hyper", "unsigned hyper", "float", "double", "string", "type", "any"};
    private static final HashMap<Class<?>, TypeClass[]> __javaClassToTypeClass = new HashMap();
    public static final Type VOID;
    public static final Type CHAR;
    public static final Type BOOLEAN;
    public static final Type BYTE;
    public static final Type SHORT;
    public static final Type UNSIGNED_SHORT;
    public static final Type LONG;
    public static final Type UNSIGNED_LONG;
    public static final Type HYPER;
    public static final Type UNSIGNED_HYPER;
    public static final Type FLOAT;
    public static final Type DOUBLE;
    public static final Type STRING;
    public static final Type TYPE;
    public static final Type ANY;
    protected TypeClass _typeClass;
    protected String _typeName;
    protected Class<?> _class;
    protected ITypeDescription _iTypeDescription;

    public Type() {
        this.init(null, Void.TYPE, false, false);
    }

    public Type(String typeName, TypeClass typeClass) {
        this._typeClass = typeClass;
        this._typeName = typeName;
    }

    public Type(Class<?> zClass) {
        this.init(null, zClass, false, false);
    }

    public Type(Class<?> zClass, boolean alternative) {
        this.init(null, zClass, alternative, false);
    }

    public Type(ITypeDescription typeDescription) {
        this._typeName = typeDescription.getTypeName();
        this._typeClass = typeDescription.getTypeClass();
        this._iTypeDescription = typeDescription;
    }

    public Type(String typeName) {
        int i;
        if (typeName.startsWith("[]")) {
            this._typeName = typeName;
            this._typeClass = TypeClass.SEQUENCE;
            return;
        }
        for (i = 0; i < __typeClassToTypeName.length; ++i) {
            if (!__typeClassToTypeName[i].equals(typeName)) continue;
            this._typeName = typeName;
            this._typeClass = TypeClass.fromInt(i);
            return;
        }
        i = typeName.indexOf(60);
        try {
            this.init(typeName, Class.forName(i < 0 ? typeName : typeName.substring(0, i)), false, i >= 0);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Type(TypeClass typeClass) {
        if (!Type.__isTypeClassPrimitive(typeClass)) {
            throw new IllegalArgumentException(typeClass + " is not primitive");
        }
        this._typeClass = typeClass;
        this._typeName = __typeClassToTypeName[typeClass.getValue()];
    }

    public TypeClass getTypeClass() {
        return this._typeClass;
    }

    public String getTypeName() {
        return this._typeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getZClass() {
        Type type = this;
        synchronized (type) {
            if (this._class == null) {
                this._class = this.determineClass();
            }
        }
        return this._class;
    }

    public ITypeDescription getTypeDescription() {
        return this._iTypeDescription;
    }

    public void setTypeDescription(ITypeDescription typeDescription) {
        this._iTypeDescription = typeDescription;
    }

    public boolean isSupertypeOf(Type type) {
        if (this._typeClass != type._typeClass) {
            return false;
        }
        switch (this._typeClass.getValue()) {
            case 15: 
            case 20: {
                return this._typeName.equals(type._typeName);
            }
            case 17: {
                if (this._typeName.indexOf(60) >= 0 || type._typeName.indexOf(60) >= 0) {
                    return this._typeName.equals(type._typeName);
                }
            }
            case 19: 
            case 22: {
                Class<?> c1 = this.getZClass();
                Class<?> c2 = type.getZClass();
                return c1 != null && c2 != null && c1.isAssignableFrom(c2);
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof Type && this._typeClass == ((Type)obj)._typeClass && this._typeName.equals(((Type)obj)._typeName);
    }

    public int hashCode() {
        return this._typeName.hashCode();
    }

    public String toString() {
        return "Type[" + this._typeName + "]";
    }

    private void init(String name, Class<?> zClass, boolean alternative, boolean arguments) {
        TypeClass[] tc = __javaClassToTypeClass.get(zClass);
        if (tc != null) {
            this._typeClass = tc[alternative ? 1 : 0];
            this._typeName = this._typeClass == TypeClass.INTERFACE ? XInterface.class.getName() : __typeClassToTypeName[this._typeClass.getValue()];
        } else if (zClass.isArray()) {
            Type t = new Type(zClass.getComponentType(), alternative);
            this._typeClass = t.getTypeClass() != TypeClass.UNKNOWN ? TypeClass.SEQUENCE : TypeClass.UNKNOWN;
            this._typeName = "[]" + t.getTypeName();
        } else if (Enum.class.isAssignableFrom(zClass)) {
            this._typeClass = zClass != Enum.class ? TypeClass.ENUM : TypeClass.UNKNOWN;
            this._typeName = zClass.getName();
            this._class = zClass;
        } else if (Throwable.class.isAssignableFrom(zClass)) {
            this._typeClass = Exception.class.isAssignableFrom(zClass) || RuntimeException.class.isAssignableFrom(zClass) ? TypeClass.EXCEPTION : TypeClass.UNKNOWN;
            this._typeName = zClass.getName();
            this._class = zClass;
        } else if (zClass.isInterface()) {
            this._typeClass = XInterface.class.isAssignableFrom(zClass) ? TypeClass.INTERFACE : TypeClass.UNKNOWN;
            this._typeName = zClass.getName();
            this._class = zClass;
        } else if (XInterface.class.isAssignableFrom(zClass)) {
            this._typeClass = TypeClass.INTERFACE;
            this._typeName = XInterface.class.getName();
            this._class = XInterface.class;
        } else {
            this._typeClass = TypeClass.STRUCT;
            this._typeName = name == null ? zClass.getName() : name;
            this._class = zClass;
        }
        if (arguments && this._typeClass != TypeClass.STRUCT) {
            throw new IllegalArgumentException(zClass + " cannot have type arguments");
        }
    }

    private Class<?> determineClass() {
        switch (this._typeClass.getValue()) {
            case 0: {
                return this._typeName.equals(TYPE_NAME_VOID) ? Void.TYPE : null;
            }
            case 2: {
                return this._typeName.equals(TYPE_NAME_BOOLEAN) ? Boolean.TYPE : null;
            }
            case 3: {
                return this._typeName.equals(TYPE_NAME_BYTE) ? Byte.TYPE : null;
            }
            case 4: {
                return this._typeName.equals(TYPE_NAME_SHORT) ? Short.TYPE : null;
            }
            case 5: {
                return this._typeName.equals(TYPE_NAME_UNSIGNED_SHORT) ? Short.TYPE : null;
            }
            case 6: {
                return this._typeName.equals(TYPE_NAME_LONG) ? Integer.TYPE : null;
            }
            case 7: {
                return this._typeName.equals(TYPE_NAME_UNSIGNED_LONG) ? Integer.TYPE : null;
            }
            case 8: {
                return this._typeName.equals(TYPE_NAME_HYPER) ? Long.TYPE : null;
            }
            case 9: {
                return this._typeName.equals(TYPE_NAME_UNSIGNED_HYPER) ? Long.TYPE : null;
            }
            case 10: {
                return this._typeName.equals(TYPE_NAME_FLOAT) ? Float.TYPE : null;
            }
            case 11: {
                return this._typeName.equals(TYPE_NAME_DOUBLE) ? Double.TYPE : null;
            }
            case 1: {
                return this._typeName.equals(TYPE_NAME_CHAR) ? Character.TYPE : null;
            }
            case 12: {
                return this._typeName.equals(TYPE_NAME_STRING) ? String.class : null;
            }
            case 13: {
                return this._typeName.equals(TYPE_NAME_TYPE) ? Type.class : null;
            }
            case 14: {
                return this._typeName.equals(TYPE_NAME_ANY) ? Object.class : null;
            }
            case 20: {
                StringBuffer buf = new StringBuffer();
                int offset = 0;
                while (this._typeName.startsWith("[]", offset)) {
                    buf.append('[');
                    offset += "[]".length();
                }
                if (buf.length() == 0) {
                    return null;
                }
                String base = this._typeName.substring(offset);
                if (base.equals(TYPE_NAME_VOID)) {
                    buf.append('V');
                } else if (base.equals(TYPE_NAME_BOOLEAN)) {
                    buf.append('Z');
                } else if (base.equals(TYPE_NAME_BYTE)) {
                    buf.append('B');
                } else if (base.equals(TYPE_NAME_SHORT) || base.equals(TYPE_NAME_UNSIGNED_SHORT)) {
                    buf.append('S');
                } else if (base.equals(TYPE_NAME_LONG) || base.equals(TYPE_NAME_UNSIGNED_LONG)) {
                    buf.append('I');
                } else if (base.equals(TYPE_NAME_HYPER) || base.equals(TYPE_NAME_UNSIGNED_HYPER)) {
                    buf.append('J');
                } else if (base.equals(TYPE_NAME_FLOAT)) {
                    buf.append('F');
                } else if (base.equals(TYPE_NAME_DOUBLE)) {
                    buf.append('D');
                } else if (base.equals(TYPE_NAME_CHAR)) {
                    buf.append('C');
                } else if (base.equals(TYPE_NAME_STRING)) {
                    buf.append("Ljava.lang.String;");
                } else if (base.equals(TYPE_NAME_TYPE)) {
                    buf.append("Lcom.sun.star.uno.Type;");
                } else if (base.equals(TYPE_NAME_ANY)) {
                    buf.append("Ljava.lang.Object;");
                } else {
                    Class<?> c;
                    int args = base.indexOf(60);
                    if (args >= 0) {
                        base = base.substring(0, args);
                    }
                    try {
                        c = Class.forName(base);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                    if (args < 0 && new Type(c).getTypeClass() == TypeClass.UNKNOWN) {
                        return null;
                    }
                    buf.append('L');
                    buf.append(base);
                    buf.append(';');
                }
                try {
                    return Class.forName(buf.toString());
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            case 15: 
            case 19: 
            case 22: {
                Class<?> c;
                try {
                    c = Class.forName(this._typeName);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                return new Type(c).equals(this) ? c : null;
            }
            case 17: {
                Class<?> c;
                int args = this._typeName.indexOf(60);
                try {
                    c = Class.forName(args < 0 ? this._typeName : this._typeName.substring(0, args));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                return args >= 0 || new Type(c).equals(this) ? c : null;
            }
        }
        return null;
    }

    private static boolean __isTypeClassPrimitive(TypeClass typeClass) {
        return typeClass.getValue() < __typeClassToTypeName.length;
    }

    static {
        __javaClassToTypeClass.put(Void.TYPE, new TypeClass[]{TypeClass.VOID, TypeClass.VOID});
        __javaClassToTypeClass.put(Void.class, new TypeClass[]{TypeClass.VOID, TypeClass.VOID});
        __javaClassToTypeClass.put(Boolean.TYPE, new TypeClass[]{TypeClass.BOOLEAN, TypeClass.BOOLEAN});
        __javaClassToTypeClass.put(Boolean.class, new TypeClass[]{TypeClass.BOOLEAN, TypeClass.BOOLEAN});
        __javaClassToTypeClass.put(Byte.TYPE, new TypeClass[]{TypeClass.BYTE, TypeClass.BYTE});
        __javaClassToTypeClass.put(Byte.class, new TypeClass[]{TypeClass.BYTE, TypeClass.BYTE});
        __javaClassToTypeClass.put(Short.TYPE, new TypeClass[]{TypeClass.SHORT, TypeClass.UNSIGNED_SHORT});
        __javaClassToTypeClass.put(Short.class, new TypeClass[]{TypeClass.SHORT, TypeClass.UNSIGNED_SHORT});
        __javaClassToTypeClass.put(Integer.TYPE, new TypeClass[]{TypeClass.LONG, TypeClass.UNSIGNED_LONG});
        __javaClassToTypeClass.put(Integer.class, new TypeClass[]{TypeClass.LONG, TypeClass.UNSIGNED_LONG});
        __javaClassToTypeClass.put(Long.TYPE, new TypeClass[]{TypeClass.HYPER, TypeClass.UNSIGNED_HYPER});
        __javaClassToTypeClass.put(Long.class, new TypeClass[]{TypeClass.HYPER, TypeClass.UNSIGNED_HYPER});
        __javaClassToTypeClass.put(Float.TYPE, new TypeClass[]{TypeClass.FLOAT, TypeClass.FLOAT});
        __javaClassToTypeClass.put(Float.class, new TypeClass[]{TypeClass.FLOAT, TypeClass.FLOAT});
        __javaClassToTypeClass.put(Double.TYPE, new TypeClass[]{TypeClass.DOUBLE, TypeClass.DOUBLE});
        __javaClassToTypeClass.put(Double.class, new TypeClass[]{TypeClass.DOUBLE, TypeClass.DOUBLE});
        __javaClassToTypeClass.put(Character.TYPE, new TypeClass[]{TypeClass.CHAR, TypeClass.CHAR});
        __javaClassToTypeClass.put(Character.class, new TypeClass[]{TypeClass.CHAR, TypeClass.CHAR});
        __javaClassToTypeClass.put(String.class, new TypeClass[]{TypeClass.STRING, TypeClass.STRING});
        __javaClassToTypeClass.put(Type.class, new TypeClass[]{TypeClass.TYPE, TypeClass.TYPE});
        __javaClassToTypeClass.put(Any.class, new TypeClass[]{TypeClass.ANY, TypeClass.ANY});
        __javaClassToTypeClass.put(Object.class, new TypeClass[]{TypeClass.ANY, TypeClass.INTERFACE});
        VOID = new Type(Void.TYPE);
        CHAR = new Type(Character.TYPE);
        BOOLEAN = new Type(Boolean.TYPE);
        BYTE = new Type(Byte.TYPE);
        SHORT = new Type(Short.TYPE);
        UNSIGNED_SHORT = new Type(TYPE_NAME_UNSIGNED_SHORT, TypeClass.UNSIGNED_SHORT);
        LONG = new Type(Integer.TYPE);
        UNSIGNED_LONG = new Type(TYPE_NAME_UNSIGNED_LONG, TypeClass.UNSIGNED_LONG);
        HYPER = new Type(Long.TYPE);
        UNSIGNED_HYPER = new Type(TYPE_NAME_UNSIGNED_HYPER, TypeClass.UNSIGNED_HYPER);
        FLOAT = new Type(Float.TYPE);
        DOUBLE = new Type(Double.TYPE);
        STRING = new Type(String.class);
        TYPE = new Type(Type.class);
        ANY = new Type(Any.class);
    }
}

