/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ILambda;
import org.objectweb.asm.Type;

public final class ECapturingFunctionRef
extends AExpression
implements ILambda {
    private final String variable;
    private final String call;
    private FunctionRef ref;
    private Locals.Variable captured;
    private String defPointer;

    public ECapturingFunctionRef(Location location, String variable, String call) {
        super(location);
        this.variable = Objects.requireNonNull(variable);
        this.call = Objects.requireNonNull(call);
    }

    @Override
    void extractVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    @Override
    void analyze(Locals variables) {
        this.captured = variables.getVariable(this.location, this.variable);
        if (this.expected == null) {
            this.defPointer = this.captured.type.sort == Definition.Sort.DEF ? "D" + this.variable + "." + this.call + ",1" : "S" + this.captured.type.name + "." + this.call + ",1";
            this.actual = Definition.getType("String");
        } else {
            this.defPointer = null;
            if (this.captured.type.sort != Definition.Sort.DEF) {
                try {
                    this.ref = new FunctionRef(this.expected, this.captured.type.name, this.call, 1);
                }
                catch (IllegalArgumentException e) {
                    throw this.createError(e);
                }
            }
            this.actual = this.expected;
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (this.defPointer != null) {
            writer.push(null);
            writer.visitVarInsn(this.captured.type.type.getOpcode(21), this.captured.getSlot());
        } else if (this.ref == null) {
            writer.visitVarInsn(this.captured.type.type.getOpcode(21), this.captured.getSlot());
            Type methodType = Type.getMethodType((Type)this.expected.type, (Type[])new Type[]{this.captured.type.type});
            writer.invokeDefCall(this.call, methodType, 6, this.expected.name);
        } else {
            writer.visitVarInsn(this.captured.type.type.getOpcode(21), this.captured.getSlot());
            String invokedType = this.ref.invokedType.toMethodDescriptorString();
            Type samMethodType = Type.getMethodType((String)this.ref.samMethodType.toMethodDescriptorString());
            Type interfaceType = Type.getMethodType((String)this.ref.interfaceMethodType.toMethodDescriptorString());
            if (this.ref.needsBridges()) {
                writer.invokeDynamic(this.ref.invokedName, invokedType, WriterConstants.LAMBDA_BOOTSTRAP_HANDLE, new Object[]{samMethodType, this.ref.implMethodASM, samMethodType, 4, 1, interfaceType});
            } else {
                writer.invokeDynamic(this.ref.invokedName, invokedType, WriterConstants.LAMBDA_BOOTSTRAP_HANDLE, new Object[]{samMethodType, this.ref.implMethodASM, samMethodType, 0});
            }
        }
    }

    @Override
    public String getPointer() {
        return this.defPointer;
    }

    @Override
    public Type[] getCaptures() {
        return new Type[]{this.captured.type.type};
    }
}

