/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.LegacyDateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.joda.time.DateTimeZone;

public class RangeQueryBuilder
extends AbstractQueryBuilder<RangeQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "range";
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    private static final ParseField FIELDDATA_FIELD = new ParseField("fielddata", new String[0]).withAllDeprecated("[no replacement]");
    private static final ParseField NAME_FIELD = new ParseField("_name", new String[0]).withAllDeprecated("query name is not supported in short version of range query");
    private static final ParseField LTE_FIELD = new ParseField("lte", "le");
    private static final ParseField GTE_FIELD = new ParseField("gte", "ge");
    private static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
    private static final ParseField TO_FIELD = new ParseField("to", new String[0]);
    private static final ParseField INCLUDE_LOWER_FIELD = new ParseField("include_lower", new String[0]);
    private static final ParseField INCLUDE_UPPER_FIELD = new ParseField("include_upper", new String[0]);
    private static final ParseField GT_FIELD = new ParseField("gt", new String[0]);
    private static final ParseField LT_FIELD = new ParseField("lt", new String[0]);
    private static final ParseField TIME_ZONE_FIELD = new ParseField("time_zone", new String[0]);
    private static final ParseField FORMAT_FIELD = new ParseField("format", new String[0]);
    private final String fieldName;
    private Object from;
    private Object to;
    private DateTimeZone timeZone;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private FormatDateTimeFormatter format;

    public RangeQueryBuilder(String fieldName) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.fieldName = fieldName;
    }

    public RangeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.from = in.readGenericValue();
        this.to = in.readGenericValue();
        this.includeLower = in.readBoolean();
        this.includeUpper = in.readBoolean();
        this.timeZone = in.readOptionalTimeZone();
        String formatString = in.readOptionalString();
        if (formatString != null) {
            this.format = Joda.forPattern(formatString);
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.from);
        out.writeGenericValue(this.to);
        out.writeBoolean(this.includeLower);
        out.writeBoolean(this.includeUpper);
        out.writeOptionalTimeZone(this.timeZone);
        String formatString = null;
        if (this.format != null) {
            formatString = this.format.format();
        }
        out.writeOptionalString(formatString);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public RangeQueryBuilder from(Object from, boolean includeLower) {
        this.from = RangeQueryBuilder.convertToBytesRefIfString(from);
        this.includeLower = includeLower;
        return this;
    }

    public RangeQueryBuilder from(Object from) {
        return this.from(from, this.includeLower);
    }

    public Object from() {
        return RangeQueryBuilder.convertToStringIfBytesRef(this.from);
    }

    public RangeQueryBuilder gt(Object from) {
        return this.from(from, false);
    }

    public RangeQueryBuilder gte(Object from) {
        return this.from(from, true);
    }

    public RangeQueryBuilder to(Object to, boolean includeUpper) {
        this.to = RangeQueryBuilder.convertToBytesRefIfString(to);
        this.includeUpper = includeUpper;
        return this;
    }

    public RangeQueryBuilder to(Object to) {
        return this.to(to, this.includeUpper);
    }

    public Object to() {
        return RangeQueryBuilder.convertToStringIfBytesRef(this.to);
    }

    public RangeQueryBuilder lt(Object to) {
        return this.to(to, false);
    }

    public RangeQueryBuilder lte(Object to) {
        return this.to(to, true);
    }

    public RangeQueryBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public RangeQueryBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    public RangeQueryBuilder timeZone(String timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("timezone cannot be null");
        }
        this.timeZone = DateTimeZone.forID((String)timeZone);
        return this;
    }

    public String timeZone() {
        return this.timeZone == null ? null : this.timeZone.getID();
    }

    public RangeQueryBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("format cannot be null");
        }
        this.format = Joda.forPattern(format);
        return this;
    }

    public String format() {
        return this.format == null ? null : this.format.format();
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(FROM_FIELD.getPreferredName(), RangeQueryBuilder.convertToStringIfBytesRef(this.from));
        builder.field(TO_FIELD.getPreferredName(), RangeQueryBuilder.convertToStringIfBytesRef(this.to));
        builder.field(INCLUDE_LOWER_FIELD.getPreferredName(), this.includeLower);
        builder.field(INCLUDE_UPPER_FIELD.getPreferredName(), this.includeUpper);
        if (this.timeZone != null) {
            builder.field(TIME_ZONE_FIELD.getPreferredName(), this.timeZone.getID());
        }
        if (this.format != null) {
            builder.field(FORMAT_FIELD.getPreferredName(), this.format.format());
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static Optional<RangeQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        Object from = null;
        Object to = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        String timeZone = null;
        float boost = 1.0f;
        String queryName = null;
        String format = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                RangeQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, FROM_FIELD)) {
                        from = parser.objectBytes();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, TO_FIELD)) {
                        to = parser.objectBytes();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, INCLUDE_LOWER_FIELD)) {
                        includeLower = parser.booleanValue();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, INCLUDE_UPPER_FIELD)) {
                        includeUpper = parser.booleanValue();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, GT_FIELD)) {
                        from = parser.objectBytes();
                        includeLower = false;
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, GTE_FIELD)) {
                        from = parser.objectBytes();
                        includeLower = true;
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, LT_FIELD)) {
                        to = parser.objectBytes();
                        includeUpper = false;
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, LTE_FIELD)) {
                        to = parser.objectBytes();
                        includeUpper = true;
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, TIME_ZONE_FIELD)) {
                        timeZone = parser.text();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, FORMAT_FIELD)) {
                        format = parser.text();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[range] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (parseContext.getParseFieldMatcher().match(currentFieldName, NAME_FIELD)) {
                queryName = parser.text();
                continue;
            }
            if (parseContext.getParseFieldMatcher().match(currentFieldName, FIELDDATA_FIELD)) continue;
            throw new ParsingException(parser.getTokenLocation(), "[range] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(fieldName);
        rangeQuery.from(from);
        rangeQuery.to(to);
        rangeQuery.includeLower(includeLower);
        rangeQuery.includeUpper(includeUpper);
        if (timeZone != null) {
            rangeQuery.timeZone(timeZone);
        }
        rangeQuery.boost(boost);
        rangeQuery.queryName(queryName);
        if (format != null) {
            rangeQuery.format(format);
        }
        return Optional.of(rangeQuery);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    protected MappedFieldType.Relation getRelation(QueryRewriteContext queryRewriteContext) throws IOException {
        IndexReader reader = queryRewriteContext.getIndexReader();
        if (reader == null) {
            return MappedFieldType.Relation.INTERSECTS;
        }
        MapperService mapperService = queryRewriteContext.getMapperService();
        MappedFieldType fieldType = mapperService.fullName(this.fieldName);
        if (fieldType == null) {
            return MappedFieldType.Relation.DISJOINT;
        }
        DateMathParser dateMathParser = this.format == null ? null : new DateMathParser(this.format);
        return fieldType.isFieldWithinQuery(queryRewriteContext.getIndexReader(), this.from, this.to, this.includeLower, this.includeUpper, this.timeZone, dateMathParser);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        MappedFieldType.Relation relation = this.getRelation(queryRewriteContext);
        switch (relation) {
            case DISJOINT: {
                return new MatchNoneQueryBuilder();
            }
            case WITHIN: {
                if (this.from != null || this.to != null) {
                    RangeQueryBuilder newRangeQuery = new RangeQueryBuilder(this.fieldName);
                    newRangeQuery.from(null);
                    newRangeQuery.to(null);
                    newRangeQuery.format = this.format;
                    newRangeQuery.timeZone = this.timeZone;
                    return newRangeQuery;
                }
                return this;
            }
            case INTERSECTS: {
                return this;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query query = null;
        MappedFieldType mapper = context.fieldMapper(this.fieldName);
        if (mapper != null) {
            if (mapper instanceof LegacyDateFieldMapper.DateFieldType) {
                DateMathParser forcedDateParser = null;
                if (this.format != null) {
                    forcedDateParser = new DateMathParser(this.format);
                }
                query = ((LegacyDateFieldMapper.DateFieldType)mapper).rangeQuery(this.from, this.to, this.includeLower, this.includeUpper, this.timeZone, forcedDateParser);
            } else if (mapper instanceof DateFieldMapper.DateFieldType) {
                DateMathParser forcedDateParser = null;
                if (this.format != null) {
                    forcedDateParser = new DateMathParser(this.format);
                }
                query = ((DateFieldMapper.DateFieldType)mapper).rangeQuery(this.from, this.to, this.includeLower, this.includeUpper, this.timeZone, forcedDateParser);
            } else {
                if (this.timeZone != null) {
                    throw new QueryShardException(context, "[range] time_zone can not be applied to non date field [" + this.fieldName + "]", new Object[0]);
                }
                query = mapper.rangeQuery(this.from, this.to, this.includeLower, this.includeUpper);
            }
        } else if (this.timeZone != null) {
            throw new QueryShardException(context, "[range] time_zone can not be applied to non unmapped field [" + this.fieldName + "]", new Object[0]);
        }
        if (query == null) {
            query = new TermRangeQuery(this.fieldName, BytesRefs.toBytesRef(this.from), BytesRefs.toBytesRef(this.to), this.includeLower, this.includeUpper);
        }
        return query;
    }

    @Override
    protected int doHashCode() {
        String timeZoneId = this.timeZone == null ? null : this.timeZone.getID();
        String formatString = this.format == null ? null : this.format.format();
        return Objects.hash(this.fieldName, this.from, this.to, timeZoneId, this.includeLower, this.includeUpper, formatString);
    }

    @Override
    protected boolean doEquals(RangeQueryBuilder other) {
        String timeZoneId = this.timeZone == null ? null : this.timeZone.getID();
        String formatString = this.format == null ? null : this.format.format();
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(timeZoneId, other.timeZone()) && Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(formatString, other.format());
    }
}

