/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestValidateQueryAction
extends BaseRestHandler {
    private final IndicesQueriesRegistry indicesQueriesRegistry;
    private static final String INDEX_FIELD = "index";
    private static final String VALID_FIELD = "valid";
    private static final String EXPLANATIONS_FIELD = "explanations";
    private static final String ERROR_FIELD = "error";
    private static final String EXPLANATION_FIELD = "explanation";

    @Inject
    public RestValidateQueryAction(Settings settings, RestController controller, IndicesQueriesRegistry indicesQueriesRegistry) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/_validate/query", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_validate/query", this);
        this.indicesQueriesRegistry = indicesQueriesRegistry;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        ValidateQueryRequest validateQueryRequest = new ValidateQueryRequest(Strings.splitStringByCommaToArray(request.param(INDEX_FIELD)));
        validateQueryRequest.indicesOptions(IndicesOptions.fromRequest(request, validateQueryRequest.indicesOptions()));
        validateQueryRequest.explain(request.paramAsBoolean("explain", false));
        validateQueryRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        validateQueryRequest.rewrite(request.paramAsBoolean("rewrite", false));
        Exception bodyParsingException = null;
        if (RestActions.hasBodyContent(request)) {
            try {
                validateQueryRequest.query(RestActions.getQueryContent(RestActions.getRestContent(request), this.indicesQueriesRegistry, this.parseFieldMatcher));
            }
            catch (Exception e) {
                bodyParsingException = e;
            }
        } else if (request.hasParam("q")) {
            QueryBuilder queryBuilder = RestActions.urlParamsToQueryBuilder(request);
            validateQueryRequest.query(queryBuilder);
        }
        Exception finalBodyParsingException = bodyParsingException;
        return channel -> {
            if (finalBodyParsingException != null) {
                if (finalBodyParsingException instanceof ParsingException) {
                    this.handleException(validateQueryRequest, ((ParsingException)finalBodyParsingException).getDetailedMessage(), channel);
                } else {
                    this.handleException(validateQueryRequest, finalBodyParsingException.getMessage(), channel);
                }
            } else {
                client.admin().indices().validateQuery(validateQueryRequest, (ActionListener<ValidateQueryResponse>)new RestBuilderListener<ValidateQueryResponse>(channel){

                    @Override
                    public RestResponse buildResponse(ValidateQueryResponse response, XContentBuilder builder) throws Exception {
                        builder.startObject();
                        builder.field(RestValidateQueryAction.VALID_FIELD, response.isValid());
                        RestActions.buildBroadcastShardsHeader(builder, request, response);
                        if (response.getQueryExplanation() != null && !response.getQueryExplanation().isEmpty()) {
                            builder.startArray(RestValidateQueryAction.EXPLANATIONS_FIELD);
                            for (QueryExplanation queryExplanation : response.getQueryExplanation()) {
                                builder.startObject();
                                if (queryExplanation.getIndex() != null) {
                                    builder.field(RestValidateQueryAction.INDEX_FIELD, queryExplanation.getIndex());
                                }
                                builder.field(RestValidateQueryAction.VALID_FIELD, queryExplanation.isValid());
                                if (queryExplanation.getError() != null) {
                                    builder.field(RestValidateQueryAction.ERROR_FIELD, queryExplanation.getError());
                                }
                                if (queryExplanation.getExplanation() != null) {
                                    builder.field(RestValidateQueryAction.EXPLANATION_FIELD, queryExplanation.getExplanation());
                                }
                                builder.endObject();
                            }
                            builder.endArray();
                        }
                        builder.endObject();
                        return new BytesRestResponse(RestStatus.OK, builder);
                    }
                });
            }
        };
    }

    private void handleException(ValidateQueryRequest request, String message, RestChannel channel) throws IOException {
        channel.sendResponse(RestValidateQueryAction.buildErrorResponse(channel.newBuilder(), message, request.explain()));
    }

    private static BytesRestResponse buildErrorResponse(XContentBuilder builder, String error, boolean explain) throws IOException {
        builder.startObject();
        builder.field(VALID_FIELD, false);
        if (explain) {
            builder.field(ERROR_FIELD, error);
        }
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }
}

