'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.drawBorderTop = exports.drawBorderJoin = exports.drawBorderBottom = exports.drawBorder = undefined;

var cov_a6zw0ub9o = function () {
  var path = '/Users/gajuskuizinas/Documents/dev/gajus/table/src/drawBorder.js',
      hash = '4e518697633f89fcc2ec65c54c9d288ff127a8f1',
      global = new Function('return this')(),
      gcv = '__coverage__',
      coverageData = {
    path: '/Users/gajuskuizinas/Documents/dev/gajus/table/src/drawBorder.js',
    statementMap: {
      '0': {
        start: {
          line: 16,
          column: 19
        },
        end: {
          line: 24,
          column: 1
        }
      },
      '1': {
        start: {
          line: 17,
          column: 18
        },
        end: {
          line: 21,
          column: 21
        }
      },
      '2': {
        start: {
          line: 19,
          column: 6
        },
        end: {
          line: 19,
          column: 40
        }
      },
      '3': {
        start: {
          line: 23,
          column: 2
        },
        end: {
          line: 23,
          column: 51
        }
      },
      '4': {
        start: {
          line: 39,
          column: 22
        },
        end: {
          line: 46,
          column: 1
        }
      },
      '5': {
        start: {
          line: 40,
          column: 2
        },
        end: {
          line: 45,
          column: 5
        }
      },
      '6': {
        start: {
          line: 61,
          column: 23
        },
        end: {
          line: 68,
          column: 1
        }
      },
      '7': {
        start: {
          line: 62,
          column: 2
        },
        end: {
          line: 67,
          column: 5
        }
      },
      '8': {
        start: {
          line: 83,
          column: 25
        },
        end: {
          line: 90,
          column: 1
        }
      },
      '9': {
        start: {
          line: 84,
          column: 2
        },
        end: {
          line: 89,
          column: 5
        }
      }
    },
    fnMap: {
      '0': {
        name: '(anonymous_0)',
        decl: {
          start: {
            line: 16,
            column: 19
          },
          end: {
            line: 16,
            column: 20
          }
        },
        loc: {
          start: {
            line: 16,
            column: 47
          },
          end: {
            line: 24,
            column: 1
          }
        }
      },
      '1': {
        name: '(anonymous_1)',
        decl: {
          start: {
            line: 18,
            column: 26
          },
          end: {
            line: 18,
            column: 27
          }
        },
        loc: {
          start: {
            line: 18,
            column: 36
          },
          end: {
            line: 20,
            column: 5
          }
        }
      },
      '2': {
        name: '(anonymous_2)',
        decl: {
          start: {
            line: 39,
            column: 22
          },
          end: {
            line: 39,
            column: 23
          }
        },
        loc: {
          start: {
            line: 39,
            column: 50
          },
          end: {
            line: 46,
            column: 1
          }
        }
      },
      '3': {
        name: '(anonymous_3)',
        decl: {
          start: {
            line: 61,
            column: 23
          },
          end: {
            line: 61,
            column: 24
          }
        },
        loc: {
          start: {
            line: 61,
            column: 51
          },
          end: {
            line: 68,
            column: 1
          }
        }
      },
      '4': {
        name: '(anonymous_4)',
        decl: {
          start: {
            line: 83,
            column: 25
          },
          end: {
            line: 83,
            column: 26
          }
        },
        loc: {
          start: {
            line: 83,
            column: 53
          },
          end: {
            line: 90,
            column: 1
          }
        }
      }
    },
    branchMap: {},
    s: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0,
      '5': 0,
      '6': 0,
      '7': 0,
      '8': 0,
      '9': 0
    },
    f: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0
    },
    b: {}
  },
      coverage = global[gcv] || (global[gcv] = {});

  if (coverage[path] && coverage[path].hash === hash) {
    return coverage[path];
  }

  coverageData.hash = hash;
  return coverage[path] = coverageData;
}();

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @typedef drawBorder~parts
 * @property {string} left
 * @property {string} right
 * @property {string} body
 * @property {string} join
 */

/**
 * @param {number[]} columnSizeIndex
 * @param {drawBorder~parts} parts
 * @returns {string}
 */
const drawBorder = (++cov_a6zw0ub9o.s[0], (columnSizeIndex, parts) => {
  ++cov_a6zw0ub9o.f[0];

  const columns = (++cov_a6zw0ub9o.s[1], _lodash2.default.map(columnSizeIndex, size => {
    ++cov_a6zw0ub9o.f[1];
    ++cov_a6zw0ub9o.s[2];

    return _lodash2.default.repeat(parts.body, size);
  }).join(parts.join));

  ++cov_a6zw0ub9o.s[3];
  return parts.left + columns + parts.right + '\n';
});

/**
 * @typedef drawBorderTop~parts
 * @property {string} topLeft
 * @property {string} topRight
 * @property {string} topBody
 * @property {string} topJoin
 */

/**
 * @param {number[]} columnSizeIndex
 * @param {drawBorderTop~parts} parts
 * @returns {string}
 */
const drawBorderTop = (++cov_a6zw0ub9o.s[4], (columnSizeIndex, parts) => {
  ++cov_a6zw0ub9o.f[2];
  ++cov_a6zw0ub9o.s[5];

  return drawBorder(columnSizeIndex, {
    body: parts.topBody,
    join: parts.topJoin,
    left: parts.topLeft,
    right: parts.topRight
  });
});

/**
 * @typedef drawBorderJoin~parts
 * @property {string} joinLeft
 * @property {string} joinRight
 * @property {string} joinBody
 * @property {string} joinJoin
 */

/**
 * @param {number[]} columnSizeIndex
 * @param {drawBorderJoin~parts} parts
 * @returns {string}
 */
const drawBorderJoin = (++cov_a6zw0ub9o.s[6], (columnSizeIndex, parts) => {
  ++cov_a6zw0ub9o.f[3];
  ++cov_a6zw0ub9o.s[7];

  return drawBorder(columnSizeIndex, {
    body: parts.joinBody,
    join: parts.joinJoin,
    left: parts.joinLeft,
    right: parts.joinRight
  });
});

/**
 * @typedef drawBorderBottom~parts
 * @property {string} topLeft
 * @property {string} topRight
 * @property {string} topBody
 * @property {string} topJoin
 */

/**
 * @param {number[]} columnSizeIndex
 * @param {drawBorderBottom~parts} parts
 * @returns {string}
 */
const drawBorderBottom = (++cov_a6zw0ub9o.s[8], (columnSizeIndex, parts) => {
  ++cov_a6zw0ub9o.f[4];
  ++cov_a6zw0ub9o.s[9];

  return drawBorder(columnSizeIndex, {
    body: parts.bottomBody,
    join: parts.bottomJoin,
    left: parts.bottomLeft,
    right: parts.bottomRight
  });
});

exports.drawBorder = drawBorder;
exports.drawBorderBottom = drawBorderBottom;
exports.drawBorderJoin = drawBorderJoin;
exports.drawBorderTop = drawBorderTop;