/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.io.DirectBufferWrapper;

public class ReadWriteDirectBufferWrapper
extends DirectBufferWrapper {
    protected ReadWriteDirectBufferWrapper(File file2, long offset2, long length) {
        super(file2, offset2, length);
        assert (length <= Integer.MAX_VALUE) : length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer create() throws IOException {
        RandomAccessFile file2 = this.createFile();
        try {
            ByteBuffer byteBuffer;
            FileChannel channel = file2.getChannel();
            try {
                channel.position(this.myPosition);
                ByteBuffer buffer = ByteBuffer.allocateDirect((int)this.myLength);
                channel.read(buffer);
                byteBuffer = buffer;
            }
            catch (Throwable throwable) {
                channel.close();
                throw throwable;
            }
            channel.close();
            return byteBuffer;
        }
        finally {
            file2.close();
        }
    }

    private RandomAccessFile createFile() throws FileNotFoundException {
        return FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<RandomAccessFile, FileNotFoundException>(){

            @Override
            @Nullable
            public RandomAccessFile execute(boolean finalAttempt) throws FileNotFoundException {
                try {
                    return new RandomAccessFile(ReadWriteDirectBufferWrapper.this.myFile, "rw");
                }
                catch (FileNotFoundException ex) {
                    if (!finalAttempt) {
                        return null;
                    }
                    throw ex;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer == null || !this.isDirty()) {
            return;
        }
        try {
            RandomAccessFile file2 = this.createFile();
            try {
                FileChannel channel = file2.getChannel();
                try {
                    channel.position(this.myPosition);
                    buffer.rewind();
                    channel.write(buffer);
                    this.myDirty = false;
                }
                finally {
                    channel.close();
                }
            }
            finally {
                file2.close();
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }
}

