/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

public class KotlinFunctionIntrinsic
extends FunctionIntrinsic {
    @NotNull
    private final String functionName;

    public KotlinFunctionIntrinsic(@NotNull String functionName) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "<init>"));
        }
        this.functionName = functionName;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "apply"));
        }
        JsNameRef function2 = JsAstUtils.pureFqn(this.functionName, (JsExpression)Namer.kotlinObject());
        JsInvocation jsInvocation = new JsInvocation((JsExpression)function2, receiver == null ? arguments : TranslationUtils.generateInvocationArguments(receiver, arguments));
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "apply"));
        }
        return jsInvocation;
    }
}

